/*
 * Decompiled with CFR 0.152.
 */
package imagetools;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Layer;

public class RoiTraceSelectionModel {
    static final Color COLOUR_HIGHLIGHTED_TRACE = Color.BLUE;
    static final Color COLOUR_SELECTED_TRACE = Color.RED;
    static final Color COLOUR_NONSELECTED_TRACE = new Color(0.0f, 0.0f, 0.0f, 0.1f);
    public final ChannelData channel1;
    public ChannelData channel2;

    public RoiTraceSelectionModel(File inputFile) throws Exception {
        this.channel1 = new ChannelData(inputFile);
    }

    public void updatePlots(TraceAlignmentParameters alignmentParameters, int highlightedRoiIndex, VARIANCE_TYPE varianceType, boolean hideNonHighlightedTraces) {
        this.channel1.updatePlots(alignmentParameters.alignYMax, alignmentParameters.findYMax, alignmentParameters.yMaxFrame, alignmentParameters.yMaxValue, alignmentParameters.alignYMin, alignmentParameters.findYMin, alignmentParameters.yMinFrame, alignmentParameters.yMinValue, highlightedRoiIndex, varianceType, hideNonHighlightedTraces);
        if (this.channel2 != null) {
            this.channel2.updatePlots(alignmentParameters.alignYMax, alignmentParameters.findYMax, alignmentParameters.yMaxFrame, alignmentParameters.yMaxValue, alignmentParameters.alignYMin, alignmentParameters.findYMin, alignmentParameters.yMinFrame, alignmentParameters.yMinValue, highlightedRoiIndex, varianceType, hideNonHighlightedTraces);
        }
    }

    public int getSelectedRoiCount() {
        return this.channel1.getSelectedRoiCount();
    }

    public boolean isRoiSelected() {
        return this.channel1.isRoiSelected();
    }

    public int getFrameCount() {
        return this.channel1.frameCount;
    }

    public int getRoiCount() {
        return this.channel1.roiCount;
    }

    public boolean hasTimes() {
        return this.channel1.hasTimes;
    }

    public String[] getRoiNames() {
        return this.channel1.roiNames;
    }

    public void removeMarkers() {
        this.channel1.removeMarkers();
        if (this.channel2 != null) {
            this.channel2.removeMarkers();
        }
    }

    public void clearMarkers() {
        this.channel1.clearMarkers();
        if (this.channel2 != null) {
            this.channel2.clearMarkers();
        }
    }

    static class ChannelData {
        private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("0.###");
        private final Color COLOUR_DEVIATION_MARKER = new Color(1.0f, 0.0f, 0.0f, 0.2f);
        private final Color COLOUR_BASELINE_MARKER = new Color(0.0f, 1.0f, 0.0f, 0.1f);
        private final Color COLOUR_DETECTION_MARKER = new Color(0.0f, 0.0f, 1.0f, 0.1f);
        private final Color COLOUR_SELECTION_MARKER = new Color(0.0f, 0.0f, 1.0f, 0.1f);
        private final double[] means;
        private final double[] standardDeviations;
        private final double[] standardErrors;
        private final double[][] rawObservations;
        private final double[][] processedObservations;
        private final double[][] scaledObservations;
        private final double[] times;
        final boolean hasTimes;
        private final String timeHeader;
        public String warnings;
        public final XYPlot tracesPlot;
        public final XYPlot meanPlot;
        private XYIntervalSeriesCollection meanPlotData = new XYIntervalSeriesCollection();
        private XYSeriesCollection tracesPlotData = new XYSeriesCollection();
        private final IntervalMarker deviationMarker = new IntervalMarker(-10000.0, 0.0, (Paint)this.COLOUR_DEVIATION_MARKER);
        private final IntervalMarker traceBaselineMarker = new IntervalMarker(1.0, 2.0, (Paint)this.COLOUR_BASELINE_MARKER);
        private final IntervalMarker traceDetectionMarker = new IntervalMarker(1.0, 2.0, (Paint)this.COLOUR_DETECTION_MARKER);
        private final IntervalMarker traceSelectionMarker = new IntervalMarker(1.0, 2.0, (Paint)this.COLOUR_SELECTION_MARKER);
        final String[] roiNames;
        final int roiCount;
        final int frameCount;
        boolean[] roiSelected;

        public ChannelData(File inputFile) throws Exception {
            this(new FileReader(inputFile));
        }

        public ChannelData(ChannelData otherChannel, File inputFile) throws Exception {
            this(otherChannel, new FileReader(inputFile));
        }

        ChannelData(Reader reader) throws Exception {
            List data;
            try {
                data = new CSVReader(reader).readAll();
            }
            finally {
                reader.close();
            }
            String[] roiNameRow = (String[])data.remove(0);
            this.roiCount = data.size() == 0 ? 0 : ((String[])data.get(0)).length - 1;
            this.frameCount = this.roiCount == 0 ? 0 : data.size();
            this.roiSelected = new boolean[this.roiCount];
            Arrays.fill(this.roiSelected, true);
            this.roiNames = new String[this.roiCount];
            this.rawObservations = new double[this.frameCount][this.roiCount];
            this.processedObservations = new double[this.frameCount][this.roiCount];
            this.times = new double[this.frameCount];
            this.means = new double[this.frameCount];
            this.standardDeviations = new double[this.frameCount];
            this.standardErrors = new double[this.frameCount];
            this.timeHeader = roiNameRow[0].trim();
            this.hasTimes = "time".equalsIgnoreCase(this.timeHeader);
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                this.roiNames[roiIndex] = roiNameRow[roiIndex + 1].trim();
                if (this.roiNames[roiIndex].equals("")) {
                    throw new IllegalArgumentException("Input data does not contain valid header row.");
                }
                ++roiIndex;
            }
            int invalidRowCount = 0;
            int firstInvalidRow = 0;
            int frameIndex = 0;
            while (frameIndex < this.frameCount) {
                boolean invalidRow;
                String[] frameData;
                block18: {
                    frameData = (String[])data.get(frameIndex);
                    invalidRow = false;
                    try {
                        this.times[frameIndex] = Float.parseFloat(frameData[0]);
                    }
                    catch (NumberFormatException ex) {
                        if (invalidRow) break block18;
                        ++invalidRowCount;
                        if (firstInvalidRow == 0) {
                            firstInvalidRow = frameIndex + 2;
                        }
                        invalidRow = true;
                    }
                }
                int roiIndex2 = 0;
                while (roiIndex2 < this.roiCount) {
                    block19: {
                        try {
                            this.rawObservations[frameIndex][roiIndex2] = Float.parseFloat(frameData[roiIndex2 + 1]);
                        }
                        catch (NumberFormatException ex) {
                            if (invalidRow) break block19;
                            ++invalidRowCount;
                            if (firstInvalidRow == 0) {
                                firstInvalidRow = frameIndex + 2;
                            }
                            invalidRow = true;
                        }
                    }
                    ++roiIndex2;
                }
                ++frameIndex;
            }
            if (invalidRowCount > 0) {
                this.warnings = "Input data missing values on " + invalidRowCount + " lines starting at line " + firstInvalidRow;
            }
            this.scaledObservations = new double[this.frameCount][this.roiCount];
            int roiIndex3 = 0;
            while (roiIndex3 < this.roiCount) {
                double rawYStartValue = this.rawObservations[0][roiIndex3];
                double rawYEndValue = this.rawObservations[this.frameCount - 1][roiIndex3];
                double yOffset = rawYStartValue;
                double yScale = 1.0 / (rawYEndValue - rawYStartValue);
                if (Double.isInfinite(yScale)) {
                    yScale = 1.0;
                }
                int frameIndex2 = 0;
                while (frameIndex2 < this.frameCount) {
                    this.scaledObservations[frameIndex2][roiIndex3] = (this.rawObservations[frameIndex2][roiIndex3] - yOffset) * yScale;
                    ++frameIndex2;
                }
                ++roiIndex3;
            }
            this.calculateMeans();
            DeviationRenderer meanRenderer = new DeviationRenderer(true, false);
            meanRenderer.setSeriesFillPaint(0, (Paint)Color.RED);
            meanRenderer.setSeriesPaint(0, (Paint)Color.RED);
            this.meanPlot = new XYPlot((XYDataset)this.meanPlotData, null, (ValueAxis)new NumberAxis("Fluorescence Intensity"), (XYItemRenderer)meanRenderer);
            this.meanPlot.setOrientation(PlotOrientation.VERTICAL);
            XYLineAndShapeRenderer tracesRenderer = new XYLineAndShapeRenderer(true, false);
            this.tracesPlot = new XYPlot((XYDataset)this.tracesPlotData, null, (ValueAxis)new NumberAxis("Fluorescence Intensity"), (XYItemRenderer)tracesRenderer);
            this.tracesPlot.setOrientation(PlotOrientation.VERTICAL);
            this.updatePlots(false, false, 0, 0.0, false, false, 0, 0.0, -1, VARIANCE_TYPE.STDDEV, false);
        }

        ChannelData(ChannelData otherChannel, Reader reader) throws Exception {
            this(reader);
            if (!Arrays.equals(otherChannel.roiNames, this.roiNames)) {
                throw new IllegalArgumentException("Channels have different ROI names.");
            }
            if (otherChannel.hasTimes != this.hasTimes) {
                throw new IllegalArgumentException("Only 1 channel has frame times.");
            }
            if (otherChannel.frameCount != this.frameCount) {
                throw new IllegalArgumentException("Channels have different frame counts.");
            }
            this.roiSelected = otherChannel.roiSelected;
        }

        private void calculateMeans() {
            int selectedRoiCount = this.getSelectedRoiCount();
            int frameIndex = 0;
            while (frameIndex < this.frameCount) {
                double intensity;
                int roiIndex;
                if (selectedRoiCount > 0) {
                    double sum = 0.0;
                    roiIndex = 0;
                    while (roiIndex < this.roiCount) {
                        if (this.roiSelected[roiIndex]) {
                            intensity = this.processedObservations[frameIndex][roiIndex];
                            sum += intensity;
                        }
                        ++roiIndex;
                    }
                    this.means[frameIndex] = (float)(sum / (double)selectedRoiCount);
                } else {
                    this.means[frameIndex] = 0.0;
                }
                if (selectedRoiCount > 1) {
                    double variance = 0.0;
                    roiIndex = 0;
                    while (roiIndex < this.roiCount) {
                        if (this.roiSelected[roiIndex]) {
                            intensity = this.processedObservations[frameIndex][roiIndex];
                            variance += (intensity - this.means[frameIndex]) * (intensity - this.means[frameIndex]);
                        }
                        ++roiIndex;
                    }
                    this.standardDeviations[frameIndex] = (float)Math.sqrt(variance / (double)(selectedRoiCount - 1));
                    this.standardErrors[frameIndex] = this.standardDeviations[frameIndex] / Math.sqrt(selectedRoiCount);
                } else {
                    this.standardDeviations[frameIndex] = 0.0;
                    this.standardErrors[frameIndex] = 0.0;
                }
                ++frameIndex;
            }
        }

        public synchronized void updatePlots(boolean alignYMax, boolean findYMax, int yMaxFrame, double yMaxValue, boolean alignYMin, boolean findYMin, int yMinFrame, double yMinValue, int highlightedRoiIndex, VARIANCE_TYPE varianceType, boolean hideNonHighlightedTraces) {
            if (varianceType == null) {
                throw new NullPointerException();
            }
            if (alignYMax && !findYMax && (yMaxFrame < 1 || yMaxFrame > this.frameCount) || alignYMin && !findYMin && (yMinFrame < 1 || yMinFrame > this.frameCount)) {
                throw new IllegalArgumentException("Invalid frame index");
            }
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                if (alignYMax) {
                    int frameIndex;
                    double rawYMaxValue;
                    if (findYMax) {
                        rawYMaxValue = this.rawObservations[0][roiIndex];
                        frameIndex = 1;
                        while (frameIndex < this.frameCount) {
                            rawYMaxValue = Math.max(rawYMaxValue, this.rawObservations[frameIndex][roiIndex]);
                            ++frameIndex;
                        }
                    } else {
                        rawYMaxValue = this.rawObservations[yMaxFrame - 1][roiIndex];
                    }
                    if (alignYMin) {
                        int frameIndex2;
                        double rawYMinValue;
                        double yScale = 1.0;
                        if (findYMin) {
                            rawYMinValue = this.rawObservations[0][roiIndex];
                            frameIndex2 = 1;
                            while (frameIndex2 < this.frameCount) {
                                rawYMinValue = Math.min(rawYMinValue, this.rawObservations[frameIndex2][roiIndex]);
                                ++frameIndex2;
                            }
                        } else {
                            rawYMinValue = this.rawObservations[yMinFrame - 1][roiIndex];
                        }
                        yScale = rawYMaxValue == rawYMinValue ? 1.0 : (yMaxValue - yMinValue) / (rawYMaxValue - rawYMinValue);
                        frameIndex2 = 0;
                        while (frameIndex2 < this.frameCount) {
                            this.processedObservations[frameIndex2][roiIndex] = (this.rawObservations[frameIndex2][roiIndex] - rawYMaxValue) * yScale + yMaxValue;
                            ++frameIndex2;
                        }
                    } else {
                        frameIndex = 0;
                        while (frameIndex < this.frameCount) {
                            this.processedObservations[frameIndex][roiIndex] = this.rawObservations[frameIndex][roiIndex] - rawYMaxValue + yMaxValue;
                            ++frameIndex;
                        }
                    }
                } else {
                    int frameIndex = 0;
                    while (frameIndex < this.frameCount) {
                        this.processedObservations[frameIndex][roiIndex] = this.rawObservations[frameIndex][roiIndex];
                        ++frameIndex;
                    }
                }
                ++roiIndex;
            }
            this.updateTracesPlot(highlightedRoiIndex, hideNonHighlightedTraces);
            this.calculateMeans();
            this.updateMeanPlot(varianceType);
        }

        private void updateMeanPlot(VARIANCE_TYPE varianceType) {
            this.meanPlotData = new XYIntervalSeriesCollection();
            if (this.isRoiSelected()) {
                double[] errors = varianceType == VARIANCE_TYPE.STDDEV ? this.standardDeviations : this.standardErrors;
                XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)"Mean"));
                int frameIndex = 0;
                while (frameIndex < this.processedObservations.length) {
                    double time = this.times[frameIndex];
                    double mean = this.means[frameIndex];
                    double error = errors[frameIndex];
                    series.add(time, time, time, mean, mean - error, mean + error);
                    ++frameIndex;
                }
                this.meanPlotData.addSeries(series);
            }
            this.meanPlot.setDataset((XYDataset)this.meanPlotData);
        }

        private void updateTracesPlot(int highlightedRoiIndex, boolean hideNonHighlightedTraces) {
            this.tracesPlotData = new XYSeriesCollection();
            XYItemRenderer renderer = this.tracesPlot.getRenderer();
            int rendererIndex = 0;
            if (highlightedRoiIndex > -1 && highlightedRoiIndex < this.roiSelected.length) {
                this.addTraceToPlot(renderer, highlightedRoiIndex, rendererIndex++, COLOUR_HIGHLIGHTED_TRACE);
            }
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                if (roiIndex != highlightedRoiIndex && !hideNonHighlightedTraces) {
                    this.addTraceToPlot(renderer, roiIndex, rendererIndex++, this.roiSelected[roiIndex] ? COLOUR_SELECTED_TRACE : COLOUR_NONSELECTED_TRACE);
                }
                ++roiIndex;
            }
            this.tracesPlot.setDataset((XYDataset)this.tracesPlotData);
        }

        private void addTraceToPlot(XYItemRenderer renderer, int roiIndex, int rendererIndex, Color seriesColour) {
            XYSeries series = new XYSeries((Comparable)((Object)this.roiNames[roiIndex]));
            int frameIndex = 0;
            while (frameIndex < this.processedObservations.length) {
                series.add(this.times[frameIndex], this.processedObservations[frameIndex][roiIndex]);
                ++frameIndex;
            }
            this.tracesPlotData.addSeries(series);
            renderer.setSeriesPaint(rendererIndex, (Paint)seriesColour);
        }

        public boolean hasWarnings() {
            return this.warnings != null;
        }

        public String getWarnings() {
            return this.warnings;
        }

        public synchronized void updatePercentChangeAutoRoiSelection(JCheckBox[] roiChoices, int startFrameIndex, int endFrameIndex, double minimumChange) {
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                boolean selected;
                double scaledChange = this.scaledObservations[endFrameIndex][roiIndex] - this.scaledObservations[startFrameIndex][roiIndex];
                this.roiSelected[roiIndex] = selected = minimumChange >= 0.0 ? scaledChange >= minimumChange : scaledChange <= minimumChange;
                roiChoices[roiIndex].setSelected(selected);
                ++roiIndex;
            }
            if (this.hasTimes) {
                this.traceSelectionMarker.setStartValue(this.times[startFrameIndex]);
                this.traceSelectionMarker.setEndValue(this.times[endFrameIndex]);
            } else {
                this.traceSelectionMarker.setStartValue((double)(startFrameIndex + 1));
                this.traceSelectionMarker.setEndValue((double)(endFrameIndex + 1));
            }
            Collection existingMarkers = this.tracesPlot.getDomainMarkers(Layer.FOREGROUND);
            if (existingMarkers == null || !existingMarkers.contains(this.traceSelectionMarker)) {
                this.tracesPlot.addDomainMarker((Marker)this.traceSelectionMarker);
            }
        }

        public synchronized void updateDeviationAutoRoiSelection(JCheckBox[] roiChoices, int startBaselineFrameIndex, int endBaselineFrameIndex, int startDetectionFrameIndex, int endDetectionFrameIndex, double minimumFactor) {
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                if (startBaselineFrameIndex >= endBaselineFrameIndex || startDetectionFrameIndex > endDetectionFrameIndex) {
                    this.roiSelected[roiIndex] = false;
                    roiChoices[roiIndex].setSelected(false);
                } else {
                    double mean = this.calculateRawMean(roiIndex, startBaselineFrameIndex, endBaselineFrameIndex);
                    double standardDeviation = this.calculateRawStandardDeviation(mean, roiIndex, startBaselineFrameIndex, endBaselineFrameIndex);
                    double tolerance = standardDeviation * minimumFactor;
                    boolean selected = false;
                    int frameIndex = startDetectionFrameIndex;
                    while (frameIndex <= endDetectionFrameIndex) {
                        if (Math.abs(this.rawObservations[frameIndex][roiIndex] - mean) > tolerance) {
                            selected = true;
                        }
                        ++frameIndex;
                    }
                    this.roiSelected[roiIndex] = selected;
                    roiChoices[roiIndex].setSelected(selected);
                }
                ++roiIndex;
            }
            this.traceBaselineMarker.setStartValue((double)(startBaselineFrameIndex + 1));
            this.traceBaselineMarker.setEndValue((double)(endBaselineFrameIndex + 1));
            this.traceDetectionMarker.setStartValue((double)(startDetectionFrameIndex + 1));
            this.traceDetectionMarker.setEndValue((double)(endDetectionFrameIndex + 1));
            Collection existingMarkers = this.tracesPlot.getDomainMarkers(Layer.FOREGROUND);
            if (existingMarkers == null || !existingMarkers.contains(this.traceBaselineMarker)) {
                this.tracesPlot.addDomainMarker((Marker)this.traceBaselineMarker);
            }
            if (existingMarkers == null || !existingMarkers.contains(this.traceDetectionMarker)) {
                this.tracesPlot.addDomainMarker((Marker)this.traceDetectionMarker);
            }
        }

        public void updateMaximumTotalDeviationAutoRoiSelection(JCheckBox[] roiChoices, int targetRoiCount) {
            int selectedRoiCount = this.roiCount;
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                this.roiSelected[roiIndex] = true;
                ++roiIndex;
            }
            long startTime = Calendar.getInstance().getTimeInMillis();
            while (selectedRoiCount > targetRoiCount) {
                this.removeRoiAndReduceDeviation();
                --selectedRoiCount;
            }
            long endTime = Calendar.getInstance().getTimeInMillis();
            System.out.println("Time (ms): " + (endTime - startTime) + ", ROIs skipped: " + (this.roiCount - selectedRoiCount));
            int roiIndex2 = 0;
            while (roiIndex2 < this.roiCount) {
                roiChoices[roiIndex2].setSelected(this.roiSelected[roiIndex2]);
                ++roiIndex2;
            }
        }

        private void removeRoiAndReduceDeviation() {
            int candidateIndex = -1;
            double candidateStdev = Double.MAX_VALUE;
            boolean[] candidateSelections = new boolean[this.roiSelected.length];
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                if (this.roiSelected[roiIndex]) {
                    System.arraycopy(this.roiSelected, 0, candidateSelections, 0, this.roiSelected.length);
                    candidateSelections[roiIndex] = false;
                    double currentStdev = this.calculateMeanStdev(candidateSelections);
                    if (currentStdev < candidateStdev) {
                        candidateStdev = currentStdev;
                        candidateIndex = roiIndex;
                    }
                }
                ++roiIndex;
            }
            this.roiSelected[candidateIndex] = false;
        }

        private double calculateMeanStdev(boolean[] selectedRois) {
            int selectedRoiCount = 0;
            boolean[] blArray = selectedRois;
            int n = selectedRois.length;
            int n2 = 0;
            while (n2 < n) {
                boolean current = blArray[n2];
                if (current) {
                    ++selectedRoiCount;
                }
                ++n2;
            }
            if (selectedRoiCount < 2) {
                return 0.0;
            }
            double[] means = new double[this.frameCount];
            int frameIndex = 0;
            while (frameIndex < this.frameCount) {
                double sum = 0.0;
                int roiIndex = 0;
                while (roiIndex < this.roiCount) {
                    if (selectedRois[roiIndex]) {
                        sum += this.processedObservations[frameIndex][roiIndex];
                    }
                    ++roiIndex;
                }
                means[frameIndex] = sum / (double)selectedRoiCount;
                ++frameIndex;
            }
            double[] variance = new double[means.length];
            int frameIndex2 = 0;
            while (frameIndex2 < this.frameCount) {
                double sum = 0.0;
                int roiIndex = 0;
                while (roiIndex < this.roiCount) {
                    if (selectedRois[roiIndex]) {
                        sum += (this.processedObservations[frameIndex2][roiIndex] - means[frameIndex2]) * (this.processedObservations[frameIndex2][roiIndex] - means[frameIndex2]);
                    }
                    ++roiIndex;
                }
                variance[frameIndex2] = Math.sqrt(sum / (double)(selectedRoiCount - 1));
                ++frameIndex2;
            }
            double sum = 0.0;
            double[] dArray = variance;
            int n3 = variance.length;
            int n4 = 0;
            while (n4 < n3) {
                double current = dArray[n4];
                sum += current;
                ++n4;
            }
            return sum / (double)this.frameCount;
        }

        public double getMeanStdev() {
            return this.calculateMeanStdev(this.roiSelected);
        }

        double calculateRawMean(int roiIndex, int startFrameIndex, int endFrameIndex) {
            if (roiIndex < 0 || roiIndex >= this.roiCount) {
                throw new IllegalArgumentException("" + roiIndex);
            }
            if (startFrameIndex < 0 || startFrameIndex >= this.frameCount) {
                throw new IllegalArgumentException("" + startFrameIndex);
            }
            if (endFrameIndex < 0 || endFrameIndex >= this.frameCount) {
                throw new IllegalArgumentException("" + endFrameIndex);
            }
            if (startFrameIndex >= endFrameIndex) {
                return 0.0;
            }
            double sum = 0.0;
            int frameIndex = startFrameIndex;
            while (frameIndex <= endFrameIndex) {
                sum += this.rawObservations[frameIndex][roiIndex];
                ++frameIndex;
            }
            return sum / (double)(endFrameIndex - startFrameIndex + 1);
        }

        double calculateRawStandardDeviation(double mean, int roiIndex, int startFrameIndex, int endFrameIndex) {
            if (roiIndex < 0 || roiIndex >= this.roiCount) {
                throw new IllegalArgumentException("" + roiIndex);
            }
            if (startFrameIndex < 0 || startFrameIndex >= this.frameCount) {
                throw new IllegalArgumentException("" + startFrameIndex);
            }
            if (endFrameIndex < 0 || endFrameIndex >= this.frameCount) {
                throw new IllegalArgumentException("" + endFrameIndex);
            }
            if (startFrameIndex >= endFrameIndex) {
                return 0.0;
            }
            double variance = 0.0;
            int frameIndex = startFrameIndex;
            while (frameIndex <= endFrameIndex) {
                double intensity = this.rawObservations[frameIndex][roiIndex];
                variance += (intensity - mean) * (intensity - mean);
                ++frameIndex;
            }
            return Math.sqrt(variance / (double)(endFrameIndex - startFrameIndex));
        }

        public synchronized void updateManualRoiSelection(JCheckBox[] roiChoices) {
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                this.roiSelected[roiIndex] = roiChoices[roiIndex].isSelected();
                ++roiIndex;
            }
        }

        public void save(File outputFile) throws IOException {
            CSVWriter writer = new CSVWriter((Writer)new FileWriter(outputFile), ',', '\u0000');
            int observableCount = 0;
            boolean[] blArray = this.roiSelected;
            int n = this.roiSelected.length;
            int n2 = 0;
            while (n2 < n) {
                boolean current = blArray[n2];
                if (current) {
                    ++observableCount;
                }
                ++n2;
            }
            String[] line = new String[observableCount + 1];
            int outIndex = 0;
            line[outIndex++] = "";
            int roiIndex = 0;
            while (roiIndex < this.roiCount) {
                if (this.roiSelected[roiIndex]) {
                    line[outIndex++] = this.roiNames[roiIndex];
                }
                ++roiIndex;
            }
            writer.writeNext(line);
            int frameIndex = 0;
            while (frameIndex < this.processedObservations.length) {
                outIndex = 0;
                line[outIndex++] = "" + (frameIndex + 1);
                int roiIndex2 = 0;
                while (roiIndex2 < this.roiCount) {
                    if (this.roiSelected[roiIndex2]) {
                        line[outIndex++] = NUMBER_FORMAT.format(this.processedObservations[frameIndex][roiIndex2]);
                    }
                    ++roiIndex2;
                }
                writer.writeNext(line);
                ++frameIndex;
            }
            writer.close();
        }

        public void updateDeviationMarker(int roiIndex, int startBaselineFrameIndex, int endBaselineFrameIndex, double minimumFactor) {
            this.tracesPlot.removeRangeMarker((Marker)this.deviationMarker);
            if (roiIndex > -1) {
                double mean = this.calculateProcessedMean(roiIndex, startBaselineFrameIndex, endBaselineFrameIndex);
                double standardDeviation = this.calculateProcessedStandardDeviation(mean, roiIndex, startBaselineFrameIndex, endBaselineFrameIndex);
                double tolerance = standardDeviation * minimumFactor;
                this.deviationMarker.setStartValue(mean - tolerance);
                this.deviationMarker.setEndValue(mean + tolerance);
                this.tracesPlot.addRangeMarker((Marker)this.deviationMarker);
            }
        }

        private double calculateProcessedMean(int roiIndex, int startFrameIndex, int endFrameIndex) {
            if (startFrameIndex >= endFrameIndex) {
                return 0.0;
            }
            double sum = 0.0;
            int frameIndex = startFrameIndex;
            while (frameIndex <= endFrameIndex) {
                sum += this.processedObservations[frameIndex][roiIndex];
                ++frameIndex;
            }
            return sum / (double)(endFrameIndex - startFrameIndex + 1);
        }

        private double calculateProcessedStandardDeviation(double mean, int roiIndex, int startFrameIndex, int endFrameIndex) {
            if (startFrameIndex >= endFrameIndex) {
                return 0.0;
            }
            double variance = 0.0;
            int frameIndex = startFrameIndex;
            while (frameIndex <= endFrameIndex) {
                double intensity = this.processedObservations[frameIndex][roiIndex];
                variance += (intensity - mean) * (intensity - mean);
                ++frameIndex;
            }
            return Math.sqrt(variance / (double)(endFrameIndex - startFrameIndex));
        }

        void removeMarkers() {
            this.tracesPlot.removeDomainMarker((Marker)this.traceBaselineMarker);
            this.tracesPlot.removeDomainMarker((Marker)this.traceDetectionMarker);
            this.tracesPlot.removeDomainMarker((Marker)this.traceSelectionMarker);
            this.tracesPlot.removeRangeMarker((Marker)this.deviationMarker);
        }

        public void clearMarkers() {
            this.tracesPlot.clearDomainMarkers();
            this.tracesPlot.clearRangeMarkers();
        }

        public int getSelectedRoiCount() {
            int selectedRoiCount = 0;
            boolean[] blArray = this.roiSelected;
            int n = this.roiSelected.length;
            int n2 = 0;
            while (n2 < n) {
                boolean current = blArray[n2];
                if (current) {
                    ++selectedRoiCount;
                }
                ++n2;
            }
            return selectedRoiCount;
        }

        public boolean isRoiSelected() {
            boolean[] blArray = this.roiSelected;
            int n = this.roiSelected.length;
            int n2 = 0;
            while (n2 < n) {
                boolean current = blArray[n2];
                if (current) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class TraceAlignmentParameters {
        public final boolean alignYMax;
        public final boolean findYMax;
        public final int yMaxFrame;
        public final double yMaxValue;
        public final boolean alignYMin;
        public final boolean findYMin;
        public final int yMinFrame;
        public final double yMinValue;

        public TraceAlignmentParameters(boolean alignYMax, boolean findYMax, int yMaxFrame, double yMaxValue, boolean alignYMin, boolean findYMin, int yMinFrame, double yMinValue) {
            this.alignYMax = alignYMax;
            this.findYMax = findYMax;
            this.yMaxFrame = yMaxFrame;
            this.yMaxValue = yMaxValue;
            this.alignYMin = alignYMin;
            this.findYMin = findYMin;
            this.yMinFrame = yMinFrame;
            this.yMinValue = yMinValue;
        }
    }

    public static enum VARIANCE_TYPE {
        STDDEV,
        SEM;

    }
}

