/*
 * Decompiled with CFR 0.152.
 */
package imagetools;

import imagetools.RoiTraceSelectionModel;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CrosshairLabelGenerator;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.Plot;
import org.jfree.experimental.chart.plot.CombinedXYPlot;

public class RoiTraceSelectionGui {
    private static final String SAVE_AS_SINGLE_CHANNEL = "Save As...";
    private static final String SAVE_AS_DUAL_CHANNEL = "Save Channel 1 As...";
    private static final String VERSION = "v0.11";
    protected static final String WINDOW_TITLE = "ROI Trace Selection v0.11 - ";
    private static final double F = -1.0;
    private static final double P = -2.0;
    private static final Font CONTROL_TITLE_FONT = new Font("SansSerif", 1, 16);
    static final Color COLOUR_CONTROL_BG = new Color(0xCCDDFF);
    JFrame frame = new JFrame("ROI Trace Selection v0.11 - [No file]");
    private ChartPanel combinedChartPanel;
    RoiTraceSelectionModel model;
    private JButton openChannel2Button;
    private JButton saveChannel1Button;
    private JButton saveChannel2Button;
    File currentDirectory;
    private CrosshairOverlay frameMarkerOverlay;
    private TraceAlignmentPanel traceAlignmentPanel;
    private AutoRoiPercentChangeSelectionPanel autoRoiPercentChangeSelectionPanel;
    private AutoRoiDeviationSelectionPanel autoRoiDeviationSelectionPanel;
    private AutoRoiMinimumTotalDeviationSelectionPanel autoRoiMinimumTotalDeviationSelectionPanel;
    private ManualRoiSelectionPanel manualRoiSelectionPanel;
    private MeanDisplayOptionsPanel meanDisplayOptionsPanel;
    private FrameMarkerPanel frameMarkerPanel;
    private RoiChoicePanel roiChoicePanel;
    private TraceDisplayOptionsPanel traceDisplayOptionsPanel;
    private ChannelViewPanel channelViewPanel;

    public RoiTraceSelectionGui() throws Exception {
        this(null);
    }

    public RoiTraceSelectionGui(File inputFile) throws Exception {
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.getChartsPanel(), "Center");
        this.frame.getContentPane().add((Component)this.getControlPanel(), "West");
        this.frame.getContentPane().add((Component)this.getRoiChoicePanel(), "East");
        this.frame.setMinimumSize(new Dimension(800, 650));
        this.frame.pack();
        this.frame.setVisible(true);
        this.openChannel1(inputFile);
    }

    private JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(COLOUR_CONTROL_BG);
        controlPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -1.0, 5.0, -1.0, 10.0}, {10.0, -2.0, 10.0, -1.0, 10.0}}));
        controlPanel.add((Component)this.getInputPanel(), "1,1");
        controlPanel.add((Component)this.getOutputPanel(), "3,1");
        JTabbedPane tabbedPane = new JTabbedPane();
        JScrollPane scrollPane = new JScrollPane(this.getDisplayPanel(), 20, 31);
        scrollPane.setBorder(null);
        tabbedPane.add("Display Options", scrollPane);
        scrollPane = new JScrollPane(this.getSelectionPanel(), 20, 31);
        scrollPane.setBorder(null);
        tabbedPane.add("ROI Selection", scrollPane);
        controlPanel.add((Component)tabbedPane, "1,3,3,3");
        return controlPanel;
    }

    private JPanel getDisplayPanel() {
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{5.0, -1.0, 5.0}, {10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}}));
        displayPanel.setBackground(COLOUR_CONTROL_BG);
        displayPanel.add((Component)this.getTraceDisplayOptionsPanel(), "1,1");
        displayPanel.add((Component)this.getMeanDisplayOptionsPanel(), "1,3");
        displayPanel.add((Component)this.getFrameMarkerPanel(), "1,5");
        displayPanel.add((Component)this.getTraceAlignmentPanel(), "1,7");
        displayPanel.add((Component)this.getChannelViewPanel(), "1,9");
        return displayPanel;
    }

    private JPanel getSelectionPanel() {
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{5.0, -1.0, 5.0}, {10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}}));
        selectionPanel.setBackground(COLOUR_CONTROL_BG);
        selectionPanel.add((Component)this.getManualRoiSelectionPanel(), "1,1");
        selectionPanel.add((Component)this.getAutoRoiPercentChangeSelectionPanel(), "1,3");
        selectionPanel.add((Component)this.getAutoRoiDeviationSelectionPanel(), "1,5");
        selectionPanel.add((Component)this.getAutoRoiMinimumTotalDeviationSelectionPanel(), "1,7");
        return selectionPanel;
    }

    RoiChoicePanel getRoiChoicePanel() {
        if (this.roiChoicePanel == null) {
            this.roiChoicePanel = new RoiChoicePanel();
        }
        return this.roiChoicePanel;
    }

    private static JPanel getControlSubPanel(String title) {
        JPanel panel = new JPanel();
        RoiTraceSelectionGui.initControlSubPanel(panel, title);
        panel.setBackground(COLOUR_CONTROL_BG);
        return panel;
    }

    public static void initControlSubPanel(JPanel panel, String title) {
        panel.setBackground(COLOUR_CONTROL_BG);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        border.setTitleFont(CONTROL_TITLE_FONT);
        border.setTitleJustification(2);
        panel.setBorder(border);
    }

    void chooseCharts() {
        CombinedXYPlot combinedPlot;
        String xAxisLabel;
        String string = xAxisLabel = this.model != null && this.model.hasTimes() ? "Time (s)" : "Frame";
        if (this.model != null) {
            if (this.model.channel2 == null) {
                combinedPlot = new CombinedXYPlot((ValueAxis)new NumberAxis(xAxisLabel), (ValueAxis)new NumberAxis("Fluorescence Intensity"));
                combinedPlot.add(this.model.channel1.tracesPlot);
                combinedPlot.add(this.model.channel1.meanPlot);
            } else if (this.getChannelViewPanel().showIndividualTraces()) {
                combinedPlot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis(xAxisLabel));
                ((CombinedDomainXYPlot)combinedPlot).add(this.model.channel1.tracesPlot);
                ((CombinedDomainXYPlot)combinedPlot).add(this.model.channel2.tracesPlot);
            } else {
                combinedPlot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis(xAxisLabel));
                ((CombinedDomainXYPlot)combinedPlot).add(this.model.channel1.meanPlot);
                ((CombinedDomainXYPlot)combinedPlot).add(this.model.channel2.meanPlot);
            }
        } else {
            combinedPlot = new CombinedXYPlot((ValueAxis)new NumberAxis(xAxisLabel), (ValueAxis)new NumberAxis("Fluorescence Intensity"));
        }
        this.combinedChartPanel.setChart(new JFreeChart(null, null, (Plot)combinedPlot, false));
    }

    void redrawCharts() {
        if (this.model == null) {
            return;
        }
        RoiTraceSelectionModel.VARIANCE_TYPE varianceType = this.getMeanDisplayOptionsPanel().getVarianceType();
        int selectedRoiIndex = this.getRoiChoicePanel().getSelectedRoiIndex();
        boolean displaySelectedRoiOnly = this.getTraceDisplayOptionsPanel().isDisplaySelectedRoiOnly();
        this.model.updatePlots(this.getTraceAlignmentPanel().getParameters(), selectedRoiIndex, varianceType, displaySelectedRoiOnly);
        this.saveChannel1Button.setEnabled(this.model.isRoiSelected());
        this.saveChannel2Button.setEnabled(this.model.channel2 != null && this.model.isRoiSelected());
        this.getRoiChoicePanel().repaint();
    }

    ManualRoiSelectionPanel getManualRoiSelectionPanel() {
        if (this.manualRoiSelectionPanel == null) {
            this.manualRoiSelectionPanel = new ManualRoiSelectionPanel();
        }
        return this.manualRoiSelectionPanel;
    }

    FrameMarkerPanel getFrameMarkerPanel() {
        if (this.frameMarkerPanel == null) {
            this.frameMarkerPanel = new FrameMarkerPanel();
        }
        return this.frameMarkerPanel;
    }

    MeanDisplayOptionsPanel getMeanDisplayOptionsPanel() {
        if (this.meanDisplayOptionsPanel == null) {
            this.meanDisplayOptionsPanel = new MeanDisplayOptionsPanel();
        }
        return this.meanDisplayOptionsPanel;
    }

    AutoRoiPercentChangeSelectionPanel getAutoRoiPercentChangeSelectionPanel() {
        if (this.autoRoiPercentChangeSelectionPanel == null) {
            this.autoRoiPercentChangeSelectionPanel = new AutoRoiPercentChangeSelectionPanel();
        }
        return this.autoRoiPercentChangeSelectionPanel;
    }

    AutoRoiDeviationSelectionPanel getAutoRoiDeviationSelectionPanel() {
        if (this.autoRoiDeviationSelectionPanel == null) {
            this.autoRoiDeviationSelectionPanel = new AutoRoiDeviationSelectionPanel();
        }
        return this.autoRoiDeviationSelectionPanel;
    }

    AutoRoiMinimumTotalDeviationSelectionPanel getAutoRoiMinimumTotalDeviationSelectionPanel() {
        if (this.autoRoiMinimumTotalDeviationSelectionPanel == null) {
            this.autoRoiMinimumTotalDeviationSelectionPanel = new AutoRoiMinimumTotalDeviationSelectionPanel();
        }
        return this.autoRoiMinimumTotalDeviationSelectionPanel;
    }

    private TraceDisplayOptionsPanel getTraceDisplayOptionsPanel() {
        if (this.traceDisplayOptionsPanel == null) {
            this.traceDisplayOptionsPanel = new TraceDisplayOptionsPanel();
        }
        return this.traceDisplayOptionsPanel;
    }

    private TraceAlignmentPanel getTraceAlignmentPanel() {
        if (this.traceAlignmentPanel == null) {
            this.traceAlignmentPanel = new TraceAlignmentPanel();
        }
        return this.traceAlignmentPanel;
    }

    private ChannelViewPanel getChannelViewPanel() {
        if (this.channelViewPanel == null) {
            this.channelViewPanel = new ChannelViewPanel();
        }
        return this.channelViewPanel;
    }

    private JPanel getInputPanel() {
        JPanel inputPanel = RoiTraceSelectionGui.getControlSubPanel("Input");
        inputPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 5.0, -2.0, 10.0}}));
        JButton openChannel1Button = new JButton("Open...");
        openChannel1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fileChooser = new JFileChooser();
                if (RoiTraceSelectionGui.this.currentDirectory != null) {
                    fileChooser.setCurrentDirectory(RoiTraceSelectionGui.this.currentDirectory);
                }
                fileChooser.setFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
                if (fileChooser.showOpenDialog(RoiTraceSelectionGui.this.frame) == 0) {
                    RoiTraceSelectionGui.this.openChannel1(fileChooser.getSelectedFile());
                }
            }
        });
        inputPanel.add((Component)openChannel1Button, "2,1");
        this.openChannel2Button = new JButton("Open Channel 2...");
        this.openChannel2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fileChooser = new JFileChooser();
                if (RoiTraceSelectionGui.this.currentDirectory != null) {
                    fileChooser.setCurrentDirectory(RoiTraceSelectionGui.this.currentDirectory);
                }
                fileChooser.setFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
                if (fileChooser.showOpenDialog(RoiTraceSelectionGui.this.frame) == 0) {
                    RoiTraceSelectionGui.this.openChannel2(fileChooser.getSelectedFile());
                }
            }
        });
        this.openChannel2Button.setEnabled(false);
        inputPanel.add((Component)this.openChannel2Button, "2,3");
        return inputPanel;
    }

    private JPanel getOutputPanel() {
        JPanel outputPanel = RoiTraceSelectionGui.getControlSubPanel("Output");
        outputPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 5.0, -2.0, 10.0}}));
        this.saveChannel1Button = new JButton(SAVE_AS_SINGLE_CHANNEL);
        this.saveChannel1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fileChooser = new JFileChooser();
                if (RoiTraceSelectionGui.this.currentDirectory != null) {
                    fileChooser.setCurrentDirectory(RoiTraceSelectionGui.this.currentDirectory);
                }
                fileChooser.setFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
                if (fileChooser.showSaveDialog(RoiTraceSelectionGui.this.frame) == 0) {
                    RoiTraceSelectionGui.this.saveChannel1(fileChooser.getSelectedFile());
                }
            }
        });
        this.saveChannel1Button.setEnabled(false);
        outputPanel.add((Component)this.saveChannel1Button, "2,1");
        this.saveChannel2Button = new JButton("Save Channel 2 As...");
        this.saveChannel2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fileChooser = new JFileChooser();
                if (RoiTraceSelectionGui.this.currentDirectory != null) {
                    fileChooser.setCurrentDirectory(RoiTraceSelectionGui.this.currentDirectory);
                }
                fileChooser.setFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
                if (fileChooser.showSaveDialog(RoiTraceSelectionGui.this.frame) == 0) {
                    RoiTraceSelectionGui.this.saveChannel2(fileChooser.getSelectedFile());
                }
            }
        });
        this.saveChannel2Button.setEnabled(false);
        outputPanel.add((Component)this.saveChannel2Button, "2,3");
        return outputPanel;
    }

    protected void saveChannel2(File outputFile) {
        try {
            this.model.channel2.save(outputFile);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    void saveChannel1(File outputFile) {
        try {
            this.model.channel1.save(outputFile);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    void openChannel1(File inputFile) {
        if (this.model != null) {
            this.model.clearMarkers();
        }
        String inputName = "[No file]";
        if (inputFile == null) {
            this.model = null;
        } else {
            try {
                this.model = new RoiTraceSelectionModel(inputFile);
                inputName = inputFile.getPath();
                this.currentDirectory = inputFile.getParentFile();
            }
            catch (Exception ex) {
                this.handleException(ex);
                this.model = null;
            }
        }
        this.frame.setTitle(WINDOW_TITLE + inputName);
        boolean enabled = this.model != null;
        this.openChannel2Button.setEnabled(enabled);
        this.saveChannel1Button.setEnabled(enabled);
        this.saveChannel2Button.setEnabled(false);
        this.saveChannel1Button.setText(SAVE_AS_SINGLE_CHANNEL);
        this.getRoiChoicePanel().setModel();
        this.getTraceAlignmentPanel().setModel();
        this.getManualRoiSelectionPanel().setModel();
        this.getAutoRoiPercentChangeSelectionPanel().setModel();
        this.getAutoRoiDeviationSelectionPanel().setModel();
        this.getAutoRoiMinimumTotalDeviationSelectionPanel().setModel();
        this.getChannelViewPanel().setModel();
        this.getMeanDisplayOptionsPanel().setEnabled(enabled);
        this.getTraceDisplayOptionsPanel().setEnabled(enabled);
        this.getFrameMarkerPanel().setEnabled(enabled);
        this.getManualRoiSelectionPanel().setActive(this.model != null);
        this.chooseCharts();
        this.redrawCharts();
        if (this.model != null && this.model.channel1.hasWarnings()) {
            this.showWarning(this.model.channel1.warnings);
        }
    }

    void openChannel2(File inputFile) {
        if (this.model.channel2 != null) {
            this.model.channel2.clearMarkers();
        }
        String inputName = "[No file]";
        if (inputFile == null) {
            this.model.channel2 = null;
        } else {
            try {
                this.model.channel2 = new RoiTraceSelectionModel.ChannelData(this.model.channel1, inputFile);
                inputName = inputFile.getPath();
                this.currentDirectory = inputFile.getParentFile();
            }
            catch (Exception ex) {
                this.handleException(ex);
                this.model.channel2 = null;
            }
        }
        this.frame.setTitle(WINDOW_TITLE + inputName);
        boolean enabled = this.model.channel2 != null;
        this.saveChannel2Button.setEnabled(enabled);
        this.saveChannel1Button.setText(enabled ? SAVE_AS_DUAL_CHANNEL : SAVE_AS_SINGLE_CHANNEL);
        this.getChannelViewPanel().setEnabled(enabled);
        this.getTraceAlignmentPanel().setModel();
        this.getAutoRoiPercentChangeSelectionPanel().setModel();
        this.getAutoRoiDeviationSelectionPanel().setModel();
        this.getAutoRoiMinimumTotalDeviationSelectionPanel().setModel();
        this.getChannelViewPanel().setModel();
        this.chooseCharts();
        this.redrawCharts();
        if (this.model.channel2.hasWarnings()) {
            this.showWarning(this.model.channel2.warnings);
        }
    }

    private void handleException(Exception ex) {
        ex.printStackTrace();
        String message = "There was a problem: \n" + ex.getMessage();
        JOptionPane.showMessageDialog(this.frame, message, "Error", 0);
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this.frame, message, "Warning", 2);
    }

    private JPanel getChartsPanel() {
        JPanel chartsPanel = new JPanel();
        chartsPanel.setLayout(new BoxLayout(chartsPanel, 1));
        chartsPanel.setBorder(BorderFactory.createEtchedBorder());
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Frame"));
        this.combinedChartPanel = new ChartPanel(new JFreeChart(null, null, (Plot)combinedPlot, false));
        this.combinedChartPanel.addOverlay((Overlay)this.getFrameMarkerOverlay());
        chartsPanel.add((Component)this.combinedChartPanel);
        return chartsPanel;
    }

    CrosshairOverlay getFrameMarkerOverlay() {
        if (this.frameMarkerOverlay == null) {
            this.frameMarkerOverlay = new CrosshairOverlay();
        }
        return this.frameMarkerOverlay;
    }

    void updateRoiSelectionFromChoiceList(int index) {
        this.model.channel1.updateManualRoiSelection(this.getRoiChoicePanel().getRoiChoices());
        this.getAutoRoiDeviationSelectionPanel().updateSelectedRoi(index);
        this.redrawCharts();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            new RoiTraceSelectionGui(new File(args[0]));
        } else {
            new RoiTraceSelectionGui();
        }
    }

    private class AutoRoiDeviationSelectionPanel
    extends DualChannelSelectionPanel {
        private static final long serialVersionUID = 1L;
        private final SpinnerNumberModel startBaselineFrameText;
        private final SpinnerNumberModel endBaselineFrameText;
        private final SpinnerNumberModel startDetectionFrameText;
        private final SpinnerNumberModel endDetectionFrameText;
        private final SpinnerNumberModel minimumFactorText;
        private final JSpinner startBaselineFrameSpinner;
        private final JSpinner endBaselineFrameSpinner;
        private final JSpinner startDetectionFrameSpinner;
        private final JSpinner endDetectionFrameSpinner;
        private final JSpinner minimumFactorSpinner;
        private final JLabel startBaselineFrameLabel;
        private final JLabel endBaselineFrameLabel;
        private final JLabel startDetectionFrameLabel;
        private final JLabel endDetectionFrameLabel;
        private final JLabel minimumFactorLabel;

        public AutoRoiDeviationSelectionPanel() {
            super("STDEV Selection", "STDEV selection");
            this.contentPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -2.0, 5.0, -2.0, -1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0}}));
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AutoRoiDeviationSelectionPanel.this.updateSelectionParameters();
                }
            };
            this.startBaselineFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.endBaselineFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.startDetectionFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.endDetectionFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.minimumFactorText = new SpinnerNumberModel(1.0, 0.0, 9.0, 0.1);
            this.startBaselineFrameSpinner = new JSpinner(this.startBaselineFrameText);
            this.startBaselineFrameSpinner.addChangeListener(changeListener);
            this.endBaselineFrameSpinner = new JSpinner(this.endBaselineFrameText);
            this.endBaselineFrameSpinner.addChangeListener(changeListener);
            this.startDetectionFrameSpinner = new JSpinner(this.startDetectionFrameText);
            this.startDetectionFrameSpinner.addChangeListener(changeListener);
            this.endDetectionFrameSpinner = new JSpinner(this.endDetectionFrameText);
            this.endDetectionFrameSpinner.addChangeListener(changeListener);
            this.minimumFactorSpinner = new JSpinner(this.minimumFactorText);
            this.minimumFactorSpinner.addChangeListener(changeListener);
            this.startBaselineFrameLabel = new JLabel("Start baseline frame");
            this.endBaselineFrameLabel = new JLabel("End baseline frame");
            this.startDetectionFrameLabel = new JLabel("Start detection frame");
            this.endDetectionFrameLabel = new JLabel("End detection frame");
            this.minimumFactorLabel = new JLabel("STDEV minimum multiple");
            Dimension numberInputSize = new Dimension(50, this.startBaselineFrameSpinner.getPreferredSize().height);
            this.startBaselineFrameSpinner.setPreferredSize(numberInputSize);
            this.endBaselineFrameSpinner.setPreferredSize(numberInputSize);
            this.startDetectionFrameSpinner.setPreferredSize(numberInputSize);
            this.endDetectionFrameSpinner.setPreferredSize(numberInputSize);
            this.minimumFactorSpinner.setPreferredSize(numberInputSize);
            this.startBaselineFrameSpinner.setEnabled(false);
            this.endBaselineFrameSpinner.setEnabled(false);
            this.startDetectionFrameSpinner.setEnabled(false);
            this.endDetectionFrameSpinner.setEnabled(false);
            this.minimumFactorSpinner.setEnabled(false);
            this.startBaselineFrameLabel.setEnabled(false);
            this.endBaselineFrameLabel.setEnabled(false);
            this.startDetectionFrameLabel.setEnabled(false);
            this.endDetectionFrameLabel.setEnabled(false);
            this.minimumFactorLabel.setEnabled(false);
            JComponent[][] layoutEntries = new JComponent[][]{{this.startBaselineFrameLabel, this.startBaselineFrameSpinner}, {this.endBaselineFrameLabel, this.endBaselineFrameSpinner}, {this.startDetectionFrameLabel, this.startDetectionFrameSpinner}, {this.endDetectionFrameLabel, this.endDetectionFrameSpinner}, {this.minimumFactorLabel, this.minimumFactorSpinner}};
            int i = 0;
            while (i < layoutEntries.length) {
                ((JLabel)layoutEntries[i][0]).setLabelFor(layoutEntries[i][1]);
                this.contentPanel.add((Component)layoutEntries[i][0], "1," + i * 2);
                this.contentPanel.add((Component)layoutEntries[i][1], "3," + i * 2);
                ++i;
            }
        }

        @Override
        public void setModel() {
            super.setModel();
            if (RoiTraceSelectionGui.this.model == null) {
                this.startBaselineFrameText.setMaximum(Integer.valueOf(1));
                this.endBaselineFrameText.setMaximum(Integer.valueOf(1));
                this.endBaselineFrameText.setValue(1);
                this.startDetectionFrameText.setMaximum(Integer.valueOf(1));
                this.endDetectionFrameText.setMaximum(Integer.valueOf(1));
                this.endDetectionFrameText.setValue(1);
            } else {
                int frameCount = RoiTraceSelectionGui.this.model.getFrameCount();
                this.startBaselineFrameText.setMaximum(Integer.valueOf(frameCount));
                this.endBaselineFrameText.setMaximum(Integer.valueOf(frameCount));
                this.endBaselineFrameText.setValue(frameCount);
                this.startDetectionFrameText.setMaximum(Integer.valueOf(frameCount));
                this.endDetectionFrameText.setMaximum(Integer.valueOf(frameCount));
                this.endDetectionFrameText.setValue(frameCount);
            }
        }

        @Override
        public void setActive(boolean active, ChannelId channelId) {
            super.setActive(active, channelId);
            if (active) {
                RoiTraceSelectionGui.this.getAutoRoiPercentChangeSelectionPanel().setActive(false, null);
                RoiTraceSelectionGui.this.getManualRoiSelectionPanel().setActive(false);
                RoiTraceSelectionGui.this.getAutoRoiMinimumTotalDeviationSelectionPanel().setActive(false, null);
            }
            this.startBaselineFrameSpinner.setEnabled(active);
            this.endBaselineFrameSpinner.setEnabled(active);
            this.startDetectionFrameSpinner.setEnabled(active);
            this.endDetectionFrameSpinner.setEnabled(active);
            this.minimumFactorSpinner.setEnabled(active);
            this.startBaselineFrameLabel.setEnabled(active);
            this.endBaselineFrameLabel.setEnabled(active);
            this.startDetectionFrameLabel.setEnabled(active);
            this.endDetectionFrameLabel.setEnabled(active);
            this.minimumFactorLabel.setEnabled(active);
            if (active) {
                this.updateSelectionParameters();
            } else if (RoiTraceSelectionGui.this.model != null) {
                RoiTraceSelectionGui.this.model.removeMarkers();
            }
        }

        synchronized void updateSelectionParameters() {
            RoiTraceSelectionModel.ChannelData selectedChannel = this.getSelectedChannel();
            if (selectedChannel != null) {
                int startBaselineFrameIndex = this.startBaselineFrameText.getNumber().intValue() - 1;
                int endBaselineFrameIndex = this.endBaselineFrameText.getNumber().intValue() - 1;
                int startDetectionFrameIndex = this.startDetectionFrameText.getNumber().intValue() - 1;
                int endDetectionFrameIndex = this.endDetectionFrameText.getNumber().intValue() - 1;
                double minimumFactor = this.minimumFactorText.getNumber().doubleValue();
                int roiIndex = RoiTraceSelectionGui.this.getRoiChoicePanel().getSelectedRoiIndex();
                selectedChannel.updateDeviationAutoRoiSelection(RoiTraceSelectionGui.this.getRoiChoicePanel().getRoiChoices(), startBaselineFrameIndex, endBaselineFrameIndex, startDetectionFrameIndex, endDetectionFrameIndex, minimumFactor);
                selectedChannel.updateDeviationMarker(roiIndex, startBaselineFrameIndex, endBaselineFrameIndex, minimumFactor);
            }
            RoiTraceSelectionGui.this.redrawCharts();
        }

        public void updateSelectedRoi(int roiIndex) {
            RoiTraceSelectionModel.ChannelData selectedChannel = this.getSelectedChannel();
            if (selectedChannel != null) {
                int startBaselineFrameIndex = this.startBaselineFrameText.getNumber().intValue() - 1;
                int endBaselineFrameIndex = this.endBaselineFrameText.getNumber().intValue() - 1;
                double minimumFactor = this.minimumFactorText.getNumber().doubleValue();
                selectedChannel.updateDeviationMarker(roiIndex, startBaselineFrameIndex, endBaselineFrameIndex, minimumFactor);
            }
        }
    }

    private class AutoRoiMinimumTotalDeviationSelectionPanel
    extends DualChannelSelectionPanel {
        private static final long serialVersionUID = 1L;
        private final SpinnerNumberModel roiCountText;
        private final SpinnerNumberModel stdevText;
        private final JSpinner roiCountSpinner;
        private final JSpinner stdevSpinner;
        private final JLabel roiCountLabel;
        private final JLabel stdevLabel;

        public AutoRoiMinimumTotalDeviationSelectionPanel() {
            super("Minimum STDEV Selection", "min STDEV selection");
            this.contentPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -2.0, 5.0, -2.0, -1.0}, {-2.0, 5.0, -2.0}}));
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AutoRoiMinimumTotalDeviationSelectionPanel.this.updateSelectionParameters();
                }
            };
            this.roiCountText = new SpinnerNumberModel(0, 0, 1, 1);
            this.stdevText = new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1);
            this.roiCountSpinner = new JSpinner(this.roiCountText);
            this.roiCountSpinner.addChangeListener(changeListener);
            this.stdevSpinner = new JSpinner(this.stdevText);
            this.roiCountLabel = new JLabel("Selected ROI count");
            this.stdevLabel = new JLabel("Current selected STDEV");
            Dimension numberInputSize = new Dimension(50, this.roiCountSpinner.getPreferredSize().height);
            this.roiCountSpinner.setPreferredSize(numberInputSize);
            this.stdevSpinner.setPreferredSize(numberInputSize);
            this.roiCountSpinner.setEnabled(false);
            this.stdevSpinner.setEnabled(false);
            this.roiCountLabel.setEnabled(false);
            this.stdevLabel.setEnabled(false);
            JComponent[][] layoutEntries = new JComponent[][]{{this.roiCountLabel, this.roiCountSpinner}, {this.stdevLabel, this.stdevSpinner}};
            int i = 0;
            while (i < layoutEntries.length) {
                ((JLabel)layoutEntries[i][0]).setLabelFor(layoutEntries[i][1]);
                this.contentPanel.add((Component)layoutEntries[i][0], "1," + i * 2);
                this.contentPanel.add((Component)layoutEntries[i][1], "3," + i * 2);
                ++i;
            }
        }

        @Override
        public void setModel() {
            super.setModel();
            if (RoiTraceSelectionGui.this.model == null) {
                this.roiCountText.setMaximum(Integer.valueOf(0));
                this.roiCountText.setValue(0);
                this.stdevText.setMaximum(Integer.valueOf(0));
                this.stdevText.setValue(0);
            } else {
                this.roiCountText.setMaximum(Integer.valueOf(RoiTraceSelectionGui.this.model.getRoiCount()));
                this.roiCountText.setValue(RoiTraceSelectionGui.this.model.getRoiCount());
                double maximum = RoiTraceSelectionGui.this.model.channel1.getMeanStdev();
                this.stdevText.setMaximum(Double.valueOf(maximum));
                this.stdevText.setValue(maximum);
            }
        }

        @Override
        public void setActive(boolean active, ChannelId channelId) {
            super.setActive(active, channelId);
            if (active) {
                RoiTraceSelectionGui.this.getAutoRoiPercentChangeSelectionPanel().setActive(false, null);
                RoiTraceSelectionGui.this.getManualRoiSelectionPanel().setActive(false);
                RoiTraceSelectionGui.this.getAutoRoiDeviationSelectionPanel().setActive(false, null);
            }
            this.roiCountSpinner.setEnabled(active);
            this.stdevSpinner.setEnabled(active);
            this.roiCountLabel.setEnabled(active);
            this.stdevLabel.setEnabled(active);
            if (active) {
                this.updateSelectionParameters();
            }
        }

        synchronized void updateSelectionParameters() {
            RoiTraceSelectionModel.ChannelData selectedChannel = this.getSelectedChannel();
            if (selectedChannel != null) {
                int roiCount = this.roiCountText.getNumber().intValue();
                selectedChannel.updateMaximumTotalDeviationAutoRoiSelection(RoiTraceSelectionGui.this.getRoiChoicePanel().getRoiChoices(), roiCount);
                this.stdevText.setValue(selectedChannel.getMeanStdev());
            }
            RoiTraceSelectionGui.this.redrawCharts();
        }
    }

    private class AutoRoiPercentChangeSelectionPanel
    extends DualChannelSelectionPanel {
        private static final long serialVersionUID = 1L;
        private SpinnerNumberModel startFrameText;
        private SpinnerNumberModel endFrameText;
        private SpinnerNumberModel minimumDecreaseText;
        private JSpinner startFrameSpinner;
        private JSpinner endFrameSpinner;
        private JSpinner minimumDecreaseSpinner;
        private JLabel startFrameLabel;
        private JLabel minimumDecreaseLabel;
        private JLabel endFrameLabel;

        public AutoRoiPercentChangeSelectionPanel() {
            super("% Change Selection", "% change selection");
            this.contentPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -2.0, 5.0, -2.0, -1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0}}));
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AutoRoiPercentChangeSelectionPanel.this.updateSelectionParameters();
                }
            };
            this.startFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.endFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.minimumDecreaseText = new SpinnerNumberModel(0, -100, 100, 1);
            this.startFrameSpinner = new JSpinner(this.startFrameText);
            this.startFrameSpinner.addChangeListener(changeListener);
            this.endFrameSpinner = new JSpinner(this.endFrameText);
            this.endFrameSpinner.addChangeListener(changeListener);
            this.minimumDecreaseSpinner = new JSpinner(this.minimumDecreaseText);
            this.minimumDecreaseSpinner.addChangeListener(changeListener);
            this.startFrameLabel = new JLabel("Start value frame");
            this.endFrameLabel = new JLabel("End value frame");
            this.minimumDecreaseLabel = new JLabel("% of total change");
            Dimension numberInputSize = new Dimension(50, this.startFrameSpinner.getPreferredSize().height);
            this.startFrameSpinner.setPreferredSize(numberInputSize);
            this.endFrameSpinner.setPreferredSize(numberInputSize);
            this.minimumDecreaseSpinner.setPreferredSize(numberInputSize);
            this.startFrameSpinner.setEnabled(false);
            this.endFrameSpinner.setEnabled(false);
            this.minimumDecreaseSpinner.setEnabled(false);
            this.startFrameLabel.setEnabled(false);
            this.endFrameLabel.setEnabled(false);
            this.minimumDecreaseLabel.setEnabled(false);
            JComponent[][] layoutEntries = new JComponent[][]{{this.startFrameLabel, this.startFrameSpinner}, {this.endFrameLabel, this.endFrameSpinner}, {this.minimumDecreaseLabel, this.minimumDecreaseSpinner}};
            int i = 0;
            while (i < layoutEntries.length) {
                ((JLabel)layoutEntries[i][0]).setLabelFor(layoutEntries[i][1]);
                this.contentPanel.add((Component)layoutEntries[i][0], "1," + i * 2);
                this.contentPanel.add((Component)layoutEntries[i][1], "3," + i * 2);
                ++i;
            }
        }

        @Override
        public void setModel() {
            super.setModel();
            if (RoiTraceSelectionGui.this.model == null) {
                this.startFrameText.setMaximum(Integer.valueOf(1));
                this.endFrameText.setMaximum(Integer.valueOf(1));
                this.endFrameText.setValue(1);
            } else {
                this.startFrameText.setMaximum(Integer.valueOf(RoiTraceSelectionGui.this.model.getFrameCount()));
                this.endFrameText.setMaximum(Integer.valueOf(RoiTraceSelectionGui.this.model.getFrameCount()));
                this.endFrameText.setValue(RoiTraceSelectionGui.this.model.getFrameCount());
            }
        }

        @Override
        protected void setActive(boolean active, ChannelId channelId) {
            super.setActive(active, channelId);
            if (active) {
                RoiTraceSelectionGui.this.getAutoRoiDeviationSelectionPanel().setActive(false, null);
                RoiTraceSelectionGui.this.getManualRoiSelectionPanel().setActive(false);
                RoiTraceSelectionGui.this.getAutoRoiMinimumTotalDeviationSelectionPanel().setActive(false, null);
            }
            this.startFrameSpinner.setEnabled(active);
            this.endFrameSpinner.setEnabled(active);
            this.minimumDecreaseSpinner.setEnabled(active);
            this.startFrameLabel.setEnabled(active);
            this.endFrameLabel.setEnabled(active);
            this.minimumDecreaseLabel.setEnabled(active);
            if (active) {
                this.updateSelectionParameters();
            } else if (RoiTraceSelectionGui.this.model != null) {
                RoiTraceSelectionGui.this.model.removeMarkers();
            }
        }

        synchronized void updateSelectionParameters() {
            RoiTraceSelectionModel.ChannelData selectedChannel = this.getSelectedChannel();
            if (selectedChannel != null) {
                int startFrameIndex = this.startFrameText.getNumber().intValue() - 1;
                int endFrameIndex = this.endFrameText.getNumber().intValue() - 1;
                selectedChannel.updatePercentChangeAutoRoiSelection(RoiTraceSelectionGui.this.getRoiChoicePanel().getRoiChoices(), startFrameIndex, endFrameIndex, this.minimumDecreaseText.getNumber().doubleValue() / 100.0);
            }
            RoiTraceSelectionGui.this.redrawCharts();
        }
    }

    private static enum ChannelId {
        CHANNEL1,
        CHANNEL2;

    }

    private class ChannelViewPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        private JRadioButton showIndividualRadio;
        private JRadioButton showMeanRadio;

        public ChannelViewPanel() {
            super("Dual Channel View");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0}}));
            this.showIndividualRadio = new JRadioButton("Show individual traces");
            this.showMeanRadio = new JRadioButton("Show means");
            this.showIndividualRadio.setBackground(COLOUR_CONTROL_BG);
            this.showMeanRadio.setBackground(COLOUR_CONTROL_BG);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.showIndividualRadio);
            buttonGroup.add(this.showMeanRadio);
            this.showIndividualRadio.setSelected(true);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RoiTraceSelectionGui.this.chooseCharts();
                    RoiTraceSelectionGui.this.redrawCharts();
                }
            };
            this.showIndividualRadio.addActionListener(actionListener);
            this.showMeanRadio.addActionListener(actionListener);
            this.add((Component)this.showIndividualRadio, "2,1");
            this.add((Component)this.showMeanRadio, "4,1");
            this.showIndividualRadio.setEnabled(true);
            this.showMeanRadio.setEnabled(false);
        }

        public boolean showIndividualTraces() {
            return this.showIndividualRadio.isSelected();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.showIndividualRadio.setEnabled(enabled);
            this.showMeanRadio.setEnabled(enabled);
        }

        public void setModel() {
            this.setEnabled(RoiTraceSelectionGui.this.model != null && RoiTraceSelectionGui.this.model.channel2 != null);
            this.showIndividualRadio.setSelected(true);
        }
    }

    private class CheckBoxList
    extends JList {
        private static final long serialVersionUID = 1L;
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private boolean modifiable = true;

        void clickCheckbox(int index) {
            if (index != -1 && this.modifiable) {
                JCheckBox checkbox;
                checkbox.setSelected(!(checkbox = (JCheckBox)this.getModel().getElementAt(index)).isSelected());
                RoiTraceSelectionGui.this.updateRoiSelectionFromChoiceList(index);
            }
        }

        public CheckBoxList() {
            this.setCellRenderer(new CellRenderer());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = CheckBoxList.this.locationToIndex(e.getPoint());
                    CheckBoxList.this.clickCheckbox(index);
                }
            });
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                }

                @Override
                public void keyReleased(KeyEvent arg0) {
                }

                @Override
                public void keyPressed(KeyEvent event) {
                    if (32 == event.getKeyCode()) {
                        CheckBoxList.this.clickCheckbox(CheckBoxList.this.getSelectedIndex());
                    }
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        RoiTraceSelectionGui.this.updateRoiSelectionFromChoiceList(CheckBoxList.this.getSelectedIndex());
                    }
                }
            });
            this.setSelectionMode(0);
        }

        public void setModifiable(boolean modifiable) {
            this.modifiable = modifiable;
        }

        protected class CellRenderer
        implements ListCellRenderer {
            protected CellRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JCheckBox checkbox = (JCheckBox)value;
                checkbox.setBackground(isSelected ? CheckBoxList.this.getSelectionBackground() : CheckBoxList.this.getBackground());
                checkbox.setForeground(isSelected ? CheckBoxList.this.getSelectionForeground() : CheckBoxList.this.getForeground());
                checkbox.setEnabled(CheckBoxList.this.isEnabled());
                checkbox.setFont(CheckBoxList.this.getFont());
                checkbox.setFocusPainted(false);
                checkbox.setBorderPainted(true);
                checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : CheckBoxList.this.noFocusBorder);
                return checkbox;
            }
        }
    }

    private abstract class ControlSubPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ControlSubPanel(String title) {
            RoiTraceSelectionGui.initControlSubPanel(this, title);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            ((TitledBorder)this.getBorder()).setTitleColor(enabled ? Color.BLACK : Color.GRAY);
        }
    }

    private abstract class DualChannelSelectionPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        final JCheckBox enableChannel1SelectionCheckbox;
        final JCheckBox enableChannel2SelectionCheckbox;
        private final JLabel enableSelectionLabel;
        protected final JPanel contentPanel;

        public DualChannelSelectionPanel(String title, String enableTitle) {
            super(title);
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 10.0, -1.0}, {10.0, -2.0, -2.0, 5.0, -2.0, 10.0}}));
            this.enableSelectionLabel = new JLabel("Enable " + enableTitle);
            this.enableChannel1SelectionCheckbox = new JCheckBox(null, false);
            this.enableChannel1SelectionCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DualChannelSelectionPanel.this.setActive(DualChannelSelectionPanel.this.enableChannel1SelectionCheckbox.isSelected(), ChannelId.CHANNEL1);
                }
            });
            this.enableChannel1SelectionCheckbox.setBackground(COLOUR_CONTROL_BG);
            this.enableChannel2SelectionCheckbox = new JCheckBox("Channel 2", false);
            this.enableChannel2SelectionCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DualChannelSelectionPanel.this.setActive(DualChannelSelectionPanel.this.enableChannel2SelectionCheckbox.isSelected(), ChannelId.CHANNEL2);
                }
            });
            this.enableChannel2SelectionCheckbox.setBackground(COLOUR_CONTROL_BG);
            this.enableChannel2SelectionCheckbox.setVisible(false);
            this.contentPanel = new JPanel();
            this.contentPanel.setBackground(COLOUR_CONTROL_BG);
            this.enableSelectionLabel.setLabelFor(this.enableChannel1SelectionCheckbox);
            this.add((Component)this.enableSelectionLabel, "2,1");
            this.add((Component)this.enableChannel1SelectionCheckbox, "4,1");
            this.add((Component)this.enableChannel2SelectionCheckbox, "4,2");
            this.add((Component)this.enableChannel2SelectionCheckbox, "4,2");
            this.add((Component)this.contentPanel, "2,4,4,4");
        }

        public void setModel() {
            if (RoiTraceSelectionGui.this.model != null) {
                RoiTraceSelectionGui.this.model.removeMarkers();
            }
            this.enableChannel1SelectionCheckbox.setSelected(false);
            this.enableChannel2SelectionCheckbox.setSelected(false);
            if (RoiTraceSelectionGui.this.model == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                if (RoiTraceSelectionGui.this.model.channel2 != null) {
                    this.enableChannel1SelectionCheckbox.setText("Channel 1");
                    this.enableChannel2SelectionCheckbox.setVisible(true);
                } else {
                    this.enableChannel1SelectionCheckbox.setText(null);
                    this.enableChannel2SelectionCheckbox.setVisible(false);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.enableChannel1SelectionCheckbox.setEnabled(enabled);
            this.enableChannel2SelectionCheckbox.setEnabled(enabled);
            this.enableSelectionLabel.setEnabled(enabled);
        }

        protected void setActive(boolean active, ChannelId channelId) {
            if (active) {
                if (channelId == null || channelId == ChannelId.CHANNEL1) {
                    if (!this.enableChannel1SelectionCheckbox.isSelected()) {
                        this.enableChannel1SelectionCheckbox.setSelected(true);
                    }
                    if (this.enableChannel2SelectionCheckbox.isSelected()) {
                        this.enableChannel2SelectionCheckbox.setSelected(false);
                    }
                } else {
                    if (this.enableChannel1SelectionCheckbox.isSelected()) {
                        this.enableChannel1SelectionCheckbox.setSelected(false);
                    }
                    if (!this.enableChannel2SelectionCheckbox.isSelected()) {
                        this.enableChannel2SelectionCheckbox.setSelected(true);
                    }
                }
            } else {
                if (this.enableChannel1SelectionCheckbox.isSelected() && (channelId == null || channelId == ChannelId.CHANNEL1)) {
                    this.enableChannel1SelectionCheckbox.setSelected(false);
                }
                if (this.enableChannel2SelectionCheckbox.isSelected() && (channelId == null || channelId == ChannelId.CHANNEL2)) {
                    this.enableChannel2SelectionCheckbox.setSelected(false);
                }
            }
        }

        protected final RoiTraceSelectionModel.ChannelData getSelectedChannel() {
            if (RoiTraceSelectionGui.this.model == null) {
                return null;
            }
            if (this.enableChannel1SelectionCheckbox.isSelected()) {
                return RoiTraceSelectionGui.this.model.channel1;
            }
            if (this.enableChannel2SelectionCheckbox.isSelected()) {
                return RoiTraceSelectionGui.this.model.channel2;
            }
            return null;
        }
    }

    public static class FrameMarker
    extends Crosshair {
        private static final long serialVersionUID = 1L;
        private final String label;
        private final int value;

        public FrameMarker(final String label, int value) {
            super((double)value);
            this.label = label;
            this.value = value;
            this.setLabelGenerator(new CrosshairLabelGenerator(){

                public String generateLabel(Crosshair crosshair) {
                    return label;
                }
            });
            this.setLabelVisible(true);
        }

        public String toString() {
            return String.valueOf(this.value) + " : " + this.label;
        }
    }

    private static class FrameMarkerDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        int result;
        private SpinnerNumberModel frameNumberText;
        private JSpinner frameNumberSpinner;
        private JTextField labelText;

        public FrameMarkerDialog(JFrame parent) {
            super(parent, "Frame Marker", true);
            this.setDefaultCloseOperation(1);
            JPanel frameMarkerPanel = new JPanel();
            frameMarkerPanel.setBackground(COLOUR_CONTROL_BG);
            frameMarkerPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -2.0, 5.0, -2.0, -1.0, 10.0}, {10.0, -2.0, 5.0, -2.0, 10.0, -2.0, 10.0}}));
            this.labelText = new JTextField("Marker");
            frameMarkerPanel.add((Component)new JLabel("Label:"), "1,1");
            frameMarkerPanel.add((Component)this.labelText, "3,1,4,1");
            this.frameNumberText = new SpinnerNumberModel(5, 0, 9999, 1);
            this.frameNumberSpinner = new JSpinner(this.frameNumberText);
            frameMarkerPanel.add((Component)new JLabel("Frame:"), "1,3");
            frameMarkerPanel.add((Component)this.frameNumberSpinner, "3,3");
            JPanel optionsPanel = new JPanel();
            optionsPanel.setBackground(COLOUR_CONTROL_BG);
            optionsPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -1.0}, {-2.0}}));
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameMarkerDialog.this.result = 2;
                    FrameMarkerDialog.this.setVisible(false);
                }
            });
            optionsPanel.add((Component)cancelButton, "0,0");
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameMarkerDialog.this.result = 0;
                    FrameMarkerDialog.this.setVisible(false);
                }
            });
            optionsPanel.add((Component)okButton, "2,0");
            frameMarkerPanel.add((Component)optionsPanel, "1,5,4,5");
            this.getContentPane().add(frameMarkerPanel);
            this.pack();
            this.setLocationRelativeTo(parent);
        }

        public int getResult() {
            return this.result;
        }

        public FrameMarker getMarker() {
            int frameNumber = this.frameNumberText.getNumber().intValue();
            String label = this.labelText.getText().trim();
            return new FrameMarker(label, frameNumber);
        }
    }

    private class FrameMarkerPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        JList frameMarkerList;
        DefaultListModel frameMarkerListModel;
        private JButton addFrameMarkerButton;
        JButton removeFrameMarkerButton;
        private FrameMarkerDialog frameMarkerDialog;

        public FrameMarkerPanel() {
            super("Frame Markers");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0}, {-2.0, 5.0, -2.0, -1.0}}));
            this.frameMarkerListModel = new DefaultListModel();
            this.frameMarkerList = new JList(this.frameMarkerListModel);
            this.frameMarkerList.setSelectionMode(0);
            this.frameMarkerList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    FrameMarkerPanel.this.removeFrameMarkerButton.setEnabled(!FrameMarkerPanel.this.frameMarkerList.isSelectionEmpty());
                }
            });
            JScrollPane scrollPane = new JScrollPane(this.frameMarkerList);
            this.add((Component)scrollPane, "0,0,0,3");
            this.addFrameMarkerButton = new JButton("+");
            this.addFrameMarkerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FrameMarkerPanel.this.addFrameMarker();
                    FrameMarkerPanel.this.updateFrameMarkers();
                }
            });
            this.add((Component)this.addFrameMarkerButton, "2,0");
            this.removeFrameMarkerButton = new JButton("-");
            this.removeFrameMarkerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameMarker frameMarker = (FrameMarker)((Object)FrameMarkerPanel.this.frameMarkerList.getSelectedValue());
                    if (frameMarker != null) {
                        FrameMarkerPanel.this.frameMarkerListModel.removeElement((Object)frameMarker);
                    }
                    FrameMarkerPanel.this.updateFrameMarkers();
                }
            });
            this.add((Component)this.removeFrameMarkerButton, "2,2");
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.frameMarkerList.setEnabled(enabled);
            this.addFrameMarkerButton.setEnabled(enabled);
            this.removeFrameMarkerButton.setEnabled(enabled && !this.frameMarkerList.isSelectionEmpty());
        }

        void addFrameMarker() {
            this.getFrameMarkerDialog().setVisible(true);
            if (this.getFrameMarkerDialog().getResult() == 0) {
                this.frameMarkerListModel.addElement(this.getFrameMarkerDialog().getMarker());
            }
        }

        private FrameMarkerDialog getFrameMarkerDialog() {
            if (this.frameMarkerDialog == null) {
                this.frameMarkerDialog = new FrameMarkerDialog(RoiTraceSelectionGui.this.frame);
            }
            return this.frameMarkerDialog;
        }

        void updateFrameMarkers() {
            RoiTraceSelectionGui.this.getFrameMarkerOverlay().clearDomainCrosshairs();
            Object[] objectArray = this.frameMarkerListModel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object frameMarker = objectArray[n2];
                RoiTraceSelectionGui.this.getFrameMarkerOverlay().addDomainCrosshair((Crosshair)((FrameMarker)((Object)frameMarker)));
                ++n2;
            }
            RoiTraceSelectionGui.this.redrawCharts();
        }
    }

    private class ManualRoiSelectionPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        JCheckBox enableSelectionCheckbox;
        private JLabel enableSelectionLabel;
        private JCheckBox roiSelectAllCheckBox;
        private boolean updatingModel;

        public ManualRoiSelectionPanel() {
            super("Manual Selection");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 5.0, -2.0, 10.0}}));
            this.enableSelectionLabel = new JLabel("Enable manual selection");
            this.enableSelectionCheckbox = new JCheckBox(null, false);
            this.enableSelectionCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ManualRoiSelectionPanel.this.setActive(ManualRoiSelectionPanel.this.enableSelectionCheckbox.isSelected());
                }
            });
            this.enableSelectionCheckbox.setBackground(COLOUR_CONTROL_BG);
            this.enableSelectionLabel.setLabelFor(this.enableSelectionCheckbox);
            this.add((Component)this.enableSelectionLabel, "2,1");
            this.add((Component)this.enableSelectionCheckbox, "4,1");
            this.roiSelectAllCheckBox = new JCheckBox("Select All", true);
            this.roiSelectAllCheckBox.setBackground(COLOUR_CONTROL_BG);
            this.roiSelectAllCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ManualRoiSelectionPanel.this.selectAllRois();
                }
            });
            this.add((Component)this.roiSelectAllCheckBox, "2,3,4,3,c,f");
            this.roiSelectAllCheckBox.setEnabled(false);
        }

        public void setModel() {
            this.enableSelectionCheckbox.setSelected(true);
            this.setEnabled(RoiTraceSelectionGui.this.model != null);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.enableSelectionCheckbox.setEnabled(enabled);
            this.enableSelectionLabel.setEnabled(enabled);
        }

        public void setActive(boolean active) {
            if (active) {
                RoiTraceSelectionGui.this.getAutoRoiPercentChangeSelectionPanel().setActive(false, null);
                RoiTraceSelectionGui.this.getAutoRoiDeviationSelectionPanel().setActive(false, null);
                RoiTraceSelectionGui.this.getAutoRoiMinimumTotalDeviationSelectionPanel().setActive(false, null);
            }
            if (this.enableSelectionCheckbox.isSelected() != active) {
                this.enableSelectionCheckbox.setSelected(active);
            }
            this.roiSelectAllCheckBox.setEnabled(active);
            RoiTraceSelectionGui.this.getRoiChoicePanel().setModifiable(active);
        }

        void selectAllRois() {
            if (this.updatingModel) {
                return;
            }
            boolean selectAll = this.roiSelectAllCheckBox.isSelected();
            RoiTraceSelectionGui.this.getRoiChoicePanel().selectAllRois(selectAll);
        }
    }

    private class MeanDisplayOptionsPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        private JLabel errorLabel;
        private JRadioButton errorStddevRadio;
        private JRadioButton errorSemRadio;

        public MeanDisplayOptionsPanel() {
            super("Mean View");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 5.0, -2.0, 10.0}}));
            this.errorSemRadio = new JRadioButton("SEM");
            this.errorStddevRadio = new JRadioButton("Sample STDEV");
            this.errorSemRadio.setBackground(COLOUR_CONTROL_BG);
            this.errorStddevRadio.setBackground(COLOUR_CONTROL_BG);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.errorSemRadio);
            buttonGroup.add(this.errorStddevRadio);
            this.errorSemRadio.setSelected(true);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RoiTraceSelectionGui.this.redrawCharts();
                }
            };
            this.errorSemRadio.addActionListener(actionListener);
            this.errorStddevRadio.addActionListener(actionListener);
            this.errorLabel = new JLabel("Display error as:");
            this.add((Component)this.errorLabel, "2,1,4,1");
            this.add((Component)this.errorSemRadio, "2,3");
            this.add((Component)this.errorStddevRadio, "4,3");
            this.errorLabel.setEnabled(false);
            this.errorSemRadio.setEnabled(false);
            this.errorStddevRadio.setEnabled(false);
        }

        public RoiTraceSelectionModel.VARIANCE_TYPE getVarianceType() {
            return this.errorStddevRadio.isSelected() ? RoiTraceSelectionModel.VARIANCE_TYPE.STDDEV : RoiTraceSelectionModel.VARIANCE_TYPE.SEM;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.errorLabel.setEnabled(RoiTraceSelectionGui.this.model != null);
            this.errorSemRadio.setEnabled(RoiTraceSelectionGui.this.model != null);
            this.errorStddevRadio.setEnabled(RoiTraceSelectionGui.this.model != null);
        }
    }

    private class RoiChoicePanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        CheckBoxList roiChoiceList;
        JCheckBox[] roiChoices;
        JLabel roiSelectionCountLabel;

        public RoiChoicePanel() {
            super("ROI Selection");
            this.roiChoices = new JCheckBox[0];
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, 120.0, 10.0}, {10.0, -2.0, 10.0, -1.0, 10.0}}));
            this.roiSelectionCountLabel = new JLabel("0 of 0");
            this.add((Component)this.roiSelectionCountLabel, "1,1,1,1,C,F");
            this.roiChoiceList = new CheckBoxList();
            JScrollPane scrollPane = new JScrollPane(this.roiChoiceList);
            this.add((Component)scrollPane, "1,3");
        }

        public void selectFirstRoi() {
            this.roiChoiceList.setSelectedIndex(0);
        }

        public boolean isRoiSelected() {
            return !this.roiChoiceList.isSelectionEmpty();
        }

        public void selectAllRois(boolean selectAll) {
            JCheckBox[] jCheckBoxArray = this.roiChoices;
            int n = this.roiChoices.length;
            int n2 = 0;
            while (n2 < n) {
                JCheckBox roiChoice = jCheckBoxArray[n2];
                roiChoice.setSelected(selectAll);
                if (selectAll != roiChoice.isSelected()) {
                    System.out.println("Selection change not holding");
                }
                ++n2;
            }
            RoiTraceSelectionGui.this.updateRoiSelectionFromChoiceList(this.getSelectedRoiIndex());
        }

        public int getSelectedRoiIndex() {
            return this.roiChoiceList.getSelectedIndex();
        }

        public void setModifiable(boolean modifiable) {
            this.roiChoiceList.setModifiable(modifiable);
        }

        @Override
        public void repaint() {
            super.repaint();
            if (this.roiSelectionCountLabel != null && RoiTraceSelectionGui.this.model != null) {
                this.roiSelectionCountLabel.setText(String.valueOf(RoiTraceSelectionGui.this.model.getSelectedRoiCount()) + " of " + RoiTraceSelectionGui.this.model.getRoiCount());
            }
            if (this.roiChoiceList != null) {
                this.roiChoiceList.repaint();
            }
        }

        public void setModel() {
            this.setEnabled(RoiTraceSelectionGui.this.model != null);
            this.roiChoices = new JCheckBox[0];
            if (RoiTraceSelectionGui.this.model != null) {
                this.roiChoices = new JCheckBox[RoiTraceSelectionGui.this.model.getRoiCount()];
                String[] roiNames = RoiTraceSelectionGui.this.model.getRoiNames();
                int roiIndex = 0;
                while (roiIndex < this.roiChoices.length) {
                    this.roiChoices[roiIndex] = new JCheckBox(roiNames[roiIndex], true);
                    ++roiIndex;
                }
            }
            this.roiChoiceList.setListData(this.roiChoices);
        }

        public JCheckBox[] getRoiChoices() {
            return this.roiChoices;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.roiChoiceList.setEnabled(enabled);
            this.roiSelectionCountLabel.setEnabled(enabled);
        }
    }

    private class TraceAlignmentPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        private SpinnerNumberModel fluorescenceMaxText;
        private SpinnerNumberModel fluorescenceMaxFrameText;
        private JSpinner fluorescenceMaxSpinner;
        private JSpinner fluorescenceMaxFrameSpinner;
        private JCheckBox enableYMaxAlignmentCheckbox;
        private JCheckBox alignToYMaxCheckbox;
        private JLabel fluorescenceMaxFrameLabel;
        private JLabel fluorescenceMaxLabel;
        private JLabel alignToYMaxLabel;
        private SpinnerNumberModel fluorescenceMinText;
        private SpinnerNumberModel fluorescenceMinFrameText;
        private JSpinner fluorescenceMinSpinner;
        private JSpinner fluorescenceMinFrameSpinner;
        private JCheckBox enableYMinAlignmentCheckbox;
        private JLabel enableYMaxAlignmentLabel;
        private JLabel enableYMinAlignmentLabel;
        private JCheckBox alignToYMinCheckbox;
        private JLabel fluorescenceMinFrameLabel;
        private JLabel fluorescenceMinLabel;
        private JLabel alignToYMinLabel;

        public TraceAlignmentPanel() {
            super("Trace Alignment");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 20.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 10.0}}));
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TraceAlignmentPanel.this.updateAlignmentPanel();
                    RoiTraceSelectionGui.this.redrawCharts();
                }
            };
            this.enableYMaxAlignmentCheckbox = new JCheckBox(null, true);
            this.enableYMaxAlignmentCheckbox.addItemListener(itemListener);
            this.enableYMaxAlignmentCheckbox.setBackground(COLOUR_CONTROL_BG);
            this.alignToYMaxCheckbox = new JCheckBox(null, false);
            this.alignToYMaxCheckbox.addItemListener(itemListener);
            this.alignToYMaxCheckbox.setBackground(COLOUR_CONTROL_BG);
            this.enableYMinAlignmentCheckbox = new JCheckBox(null, false);
            this.enableYMinAlignmentCheckbox.addItemListener(itemListener);
            this.enableYMinAlignmentCheckbox.setBackground(COLOUR_CONTROL_BG);
            this.alignToYMinCheckbox = new JCheckBox(null, false);
            this.alignToYMinCheckbox.addItemListener(itemListener);
            this.alignToYMinCheckbox.setBackground(COLOUR_CONTROL_BG);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RoiTraceSelectionGui.this.redrawCharts();
                }
            };
            this.enableYMaxAlignmentLabel = new JLabel("Align trace fluorescence maxima");
            this.fluorescenceMaxFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.fluorescenceMaxText = new SpinnerNumberModel(200.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
            this.fluorescenceMaxFrameSpinner = new JSpinner(this.fluorescenceMaxFrameText);
            this.fluorescenceMaxFrameSpinner.addChangeListener(changeListener);
            this.fluorescenceMaxSpinner = new JSpinner(this.fluorescenceMaxText);
            this.fluorescenceMaxSpinner.addChangeListener(changeListener);
            this.fluorescenceMaxFrameLabel = new JLabel("Maximum fluorescence frame");
            this.fluorescenceMaxLabel = new JLabel("Maximum fluorescence value");
            this.alignToYMaxLabel = new JLabel("Align to maximum fluorescence");
            this.enableYMinAlignmentLabel = new JLabel("Align trace fluorescence minima");
            this.fluorescenceMinFrameText = new SpinnerNumberModel(1, 1, 1, 1);
            this.fluorescenceMinText = new SpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
            this.fluorescenceMinFrameSpinner = new JSpinner(this.fluorescenceMinFrameText);
            this.fluorescenceMinFrameSpinner.addChangeListener(changeListener);
            this.fluorescenceMinSpinner = new JSpinner(this.fluorescenceMinText);
            this.fluorescenceMinSpinner.addChangeListener(changeListener);
            this.fluorescenceMinFrameLabel = new JLabel("Minimum fluorescence frame");
            this.fluorescenceMinLabel = new JLabel("Minimum fluorescence value");
            this.alignToYMinLabel = new JLabel("Align to minimum fluorescence");
            JComponent[][] layoutEntries = new JComponent[][]{{this.enableYMaxAlignmentLabel, this.enableYMaxAlignmentCheckbox}, {this.alignToYMaxLabel, this.alignToYMaxCheckbox}, {this.fluorescenceMaxLabel, this.fluorescenceMaxSpinner}, {this.fluorescenceMaxFrameLabel, this.fluorescenceMaxFrameSpinner}, {this.enableYMinAlignmentLabel, this.enableYMinAlignmentCheckbox}, {this.alignToYMinLabel, this.alignToYMinCheckbox}, {this.fluorescenceMinLabel, this.fluorescenceMinSpinner}, {this.fluorescenceMinFrameLabel, this.fluorescenceMinFrameSpinner}};
            int i = 0;
            while (i < layoutEntries.length) {
                ((JLabel)layoutEntries[i][0]).setLabelFor(layoutEntries[i][1]);
                this.add((Component)layoutEntries[i][0], "2," + (i * 2 + 1));
                this.add((Component)layoutEntries[i][1], "4," + (i * 2 + 1));
                ++i;
            }
            this.updateAlignmentPanel();
        }

        public void setModel() {
            this.setEnabled(RoiTraceSelectionGui.this.model != null);
            if (RoiTraceSelectionGui.this.model == null) {
                this.enableYMaxAlignmentCheckbox.setSelected(false);
                this.enableYMinAlignmentCheckbox.setSelected(false);
                this.fluorescenceMaxFrameText.setMaximum(Integer.valueOf(1));
                this.fluorescenceMinFrameText.setMaximum(Integer.valueOf(1));
                this.fluorescenceMinFrameText.setValue(1);
            } else {
                this.fluorescenceMaxFrameText.setMaximum(Integer.valueOf(RoiTraceSelectionGui.this.model.getFrameCount()));
                this.fluorescenceMinFrameText.setMaximum(Integer.valueOf(RoiTraceSelectionGui.this.model.getFrameCount()));
                this.fluorescenceMinFrameText.setValue(RoiTraceSelectionGui.this.model.getFrameCount());
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.enableYMaxAlignmentCheckbox.setEnabled(enabled);
            this.enableYMaxAlignmentLabel.setEnabled(enabled);
            this.enableYMinAlignmentCheckbox.setEnabled(enabled);
            this.enableYMinAlignmentLabel.setEnabled(enabled);
        }

        void updateAlignmentPanel() {
            boolean enabled = this.enableYMaxAlignmentCheckbox.isSelected();
            this.alignToYMaxCheckbox.setEnabled(enabled);
            this.alignToYMaxLabel.setEnabled(enabled);
            this.fluorescenceMaxSpinner.setEnabled(enabled);
            this.fluorescenceMaxLabel.setEnabled(enabled);
            this.enableYMinAlignmentCheckbox.setEnabled(enabled);
            this.enableYMinAlignmentLabel.setEnabled(enabled);
            this.fluorescenceMaxFrameSpinner.setEnabled(enabled && !this.alignToYMaxCheckbox.isSelected());
            this.fluorescenceMaxFrameLabel.setEnabled(enabled && !this.alignToYMaxCheckbox.isSelected());
            enabled = enabled && this.enableYMinAlignmentCheckbox.isSelected();
            this.alignToYMinCheckbox.setEnabled(enabled);
            this.alignToYMinLabel.setEnabled(enabled);
            this.fluorescenceMinSpinner.setEnabled(enabled);
            this.fluorescenceMinLabel.setEnabled(enabled);
            this.fluorescenceMinFrameSpinner.setEnabled(enabled && !this.alignToYMinCheckbox.isSelected());
            this.fluorescenceMinFrameLabel.setEnabled(enabled && !this.alignToYMinCheckbox.isSelected());
        }

        public RoiTraceSelectionModel.TraceAlignmentParameters getParameters() {
            return new RoiTraceSelectionModel.TraceAlignmentParameters(this.enableYMaxAlignmentCheckbox.isSelected(), this.alignToYMaxCheckbox.isSelected(), this.fluorescenceMaxFrameText.getNumber().intValue(), this.fluorescenceMaxText.getNumber().doubleValue(), this.enableYMinAlignmentCheckbox.isSelected(), this.alignToYMinCheckbox.isSelected(), this.fluorescenceMinFrameText.getNumber().intValue(), this.fluorescenceMinText.getNumber().doubleValue());
        }
    }

    private class TraceDisplayOptionsPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        JCheckBox roiDisplayCurrentOnlyCheckBox;

        public TraceDisplayOptionsPanel() {
            super("Trace View");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0}}));
            this.roiDisplayCurrentOnlyCheckBox = new JCheckBox("Show only current ROI", false);
            this.roiDisplayCurrentOnlyCheckBox.setBackground(COLOUR_CONTROL_BG);
            this.roiDisplayCurrentOnlyCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (TraceDisplayOptionsPanel.this.roiDisplayCurrentOnlyCheckBox.isSelected() && !RoiTraceSelectionGui.this.getRoiChoicePanel().isRoiSelected()) {
                        RoiTraceSelectionGui.this.getRoiChoicePanel().selectFirstRoi();
                    }
                    RoiTraceSelectionGui.this.redrawCharts();
                }
            });
            this.add((Component)this.roiDisplayCurrentOnlyCheckBox, "2,1");
        }

        public boolean isDisplaySelectedRoiOnly() {
            return this.roiDisplayCurrentOnlyCheckBox.isSelected();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.roiDisplayCurrentOnlyCheckBox.setEnabled(enabled);
        }
    }
}

