/*
 * Decompiled with CFR 0.152.
 */
package fmsim.observations;

import fmsim.observations.Observations;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public class ObservationsModel {
    public static final ObservationsModel EMPTY_MODEL = new ObservationsModel();
    private final Observations observations;
    private Observations correctedObservations;
    public final XYPlot rawMeanPlot;
    public final XYPlot scaledMeanPlot;
    private XYIntervalSeriesCollection rawMeanPlotData = new XYIntervalSeriesCollection();
    private XYIntervalSeriesCollection scaledMeanPlotData = new XYIntervalSeriesCollection();
    private VARIANCE_TYPE varianceType = VARIANCE_TYPE.STDDEV;

    private ObservationsModel() {
        this.observations = Observations.EMPTY;
        this.rawMeanPlot = new XYPlot();
        this.rawMeanPlot.setOrientation(PlotOrientation.VERTICAL);
        this.scaledMeanPlot = new XYPlot();
        this.scaledMeanPlot.setOrientation(PlotOrientation.VERTICAL);
    }

    public ObservationsModel(File inputFile) throws Exception {
        this(new Observations(inputFile));
    }

    public ObservationsModel(Observations observations) throws Exception {
        this.observations = observations;
        DeviationRenderer meanRenderer = new DeviationRenderer(true, false);
        meanRenderer.setSeriesFillPaint(0, (Paint)Color.RED);
        meanRenderer.setSeriesPaint(0, (Paint)Color.RED);
        meanRenderer.setSeriesFillPaint(1, (Paint)Color.BLUE);
        meanRenderer.setSeriesPaint(1, (Paint)Color.BLUE);
        this.rawMeanPlot = new XYPlot((XYDataset)this.rawMeanPlotData, null, (ValueAxis)new NumberAxis("Raw Fluorescence Intensity"), (XYItemRenderer)meanRenderer);
        this.rawMeanPlot.setOrientation(PlotOrientation.VERTICAL);
        this.scaledMeanPlot = new XYPlot((XYDataset)this.scaledMeanPlotData, null, (ValueAxis)new NumberAxis("Scaled Fluorescence Intensity"), (XYItemRenderer)meanRenderer);
        this.scaledMeanPlot.setOrientation(PlotOrientation.VERTICAL);
        this.updatePlots(this.varianceType);
    }

    public void updatePlots(VARIANCE_TYPE varianceType) {
        double[] errors;
        if (varianceType == null) {
            throw new NullPointerException();
        }
        this.varianceType = varianceType;
        this.rawMeanPlotData = new XYIntervalSeriesCollection();
        if (this.observations.roiCount > 0) {
            errors = varianceType == VARIANCE_TYPE.STDDEV ? this.observations.rawStandardDeviations : this.observations.rawStandardErrors;
            this.rawMeanPlotData.addSeries(this.createIntervalSeries("Mean", this.observations.times, this.observations.rawMeans, errors));
            if (this.correctedObservations != null) {
                errors = varianceType == VARIANCE_TYPE.STDDEV ? this.correctedObservations.rawStandardDeviations : this.correctedObservations.rawStandardErrors;
                this.rawMeanPlotData.addSeries(this.createIntervalSeries("Corrected", this.correctedObservations.times, this.correctedObservations.rawMeans, errors));
            }
        }
        this.rawMeanPlot.setDataset((XYDataset)this.rawMeanPlotData);
        this.scaledMeanPlotData = new XYIntervalSeriesCollection();
        if (this.observations.roiCount > 0) {
            errors = varianceType == VARIANCE_TYPE.STDDEV ? this.observations.scaledStandardDeviations : this.observations.scaledStandardErrors;
            this.scaledMeanPlotData.addSeries(this.createIntervalSeries("Mean", this.observations.times, this.observations.scaledMeans, errors));
            if (this.correctedObservations != null) {
                errors = varianceType == VARIANCE_TYPE.STDDEV ? this.correctedObservations.scaledStandardDeviations : this.correctedObservations.scaledStandardErrors;
                this.scaledMeanPlotData.addSeries(this.createIntervalSeries("Corrected", this.correctedObservations.times, this.correctedObservations.scaledMeans, errors));
            }
        }
        this.scaledMeanPlot.setDataset((XYDataset)this.scaledMeanPlotData);
    }

    private XYIntervalSeries createIntervalSeries(String seriesName, double[] times, double[] means, double[] errors) {
        XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)seriesName));
        int frameIndex = 0;
        while (frameIndex < times.length) {
            double mean = means[frameIndex];
            double time = times[frameIndex];
            double error = errors[frameIndex];
            series.add(time, time, time, mean, mean - error, mean + error);
            ++frameIndex;
        }
        return series;
    }

    public Observations getObservations() {
        return this.observations;
    }

    public Observations getCorrectedObservations() {
        return this.correctedObservations;
    }

    public void resetCorrection() {
        this.correctedObservations = null;
        this.updatePlots(this.varianceType);
    }

    public void setCorrection(DECAY_CORRECTION_TYPE correctionType, double value) {
        double[] times = this.observations.times;
        double[][] rawObservations = new double[this.observations.frameCount][this.observations.roiCount];
        double startTime = times[0];
        int frameIndex = 0;
        while (frameIndex < this.observations.frameCount) {
            double correction = value * (times[frameIndex] - startTime);
            int roiIndex = 0;
            while (roiIndex < this.observations.roiCount) {
                rawObservations[frameIndex][roiIndex] = this.observations.rawObservations[frameIndex][roiIndex] + correction;
                ++roiIndex;
            }
            ++frameIndex;
        }
        this.correctedObservations = new Observations(times, rawObservations);
        this.updatePlots(this.varianceType);
    }

    public void setCorrection(DECAY_CORRECTION_TYPE correctionType, int startFrame, int frameCount) {
        double startMeanValue = this.observations.rawMeans[startFrame];
        double endMeanValue = this.observations.rawMeans[startFrame + frameCount - 1];
        double startTime = this.observations.times[startFrame];
        double endTime = this.observations.times[startFrame + frameCount - 1];
        this.setCorrection(correctionType, (endMeanValue - startMeanValue) / (endTime - startTime));
    }

    public static enum DECAY_CORRECTION_TYPE {
        NONE,
        LINEAR,
        EXPONENTIAL;

    }

    public static enum VARIANCE_TYPE {
        STDDEV,
        SEM;

    }
}

