/*
 * Decompiled with CFR 0.152.
 */
package fmsim.observations;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class Observations {
    public static final Observations EMPTY = new Observations();
    public final double[] times;
    final double[][] rawObservations;
    public final double[] rawMeans;
    public final double[] rawStandardDeviations;
    public final double[] rawStandardErrors;
    final double[][] scaledObservations;
    public final double[] scaledMeans;
    public final double[] scaledStandardDeviations;
    public final double[] scaledStandardErrors;
    public final int roiCount;
    public final int frameCount;

    Observations() {
        this.times = new double[0];
        this.rawObservations = new double[0][];
        this.rawMeans = new double[0];
        this.rawStandardDeviations = new double[0];
        this.rawStandardErrors = new double[0];
        this.scaledObservations = new double[0][];
        this.scaledMeans = new double[0];
        this.scaledStandardDeviations = new double[0];
        this.scaledStandardErrors = new double[0];
        this.roiCount = 0;
        this.frameCount = 0;
    }

    private Observations(double[] times, double[][] rawObservations, double[] rawMeans, double[] rawStandardDeviations, double[] rawStandardErrors, double[][] scaledObservations, double[] scaledMeans, double[] scaledStandardDeviations, double[] scaledStandardErrors, int roiCount, int frameCount) {
        this.times = times;
        this.rawObservations = rawObservations;
        this.rawMeans = rawMeans;
        this.rawStandardDeviations = rawStandardDeviations;
        this.rawStandardErrors = rawStandardErrors;
        this.scaledObservations = scaledObservations;
        this.scaledMeans = scaledMeans;
        this.scaledStandardDeviations = scaledStandardDeviations;
        this.scaledStandardErrors = scaledStandardErrors;
        this.roiCount = roiCount;
        this.frameCount = frameCount;
    }

    public Observations(File dataFile) throws IOException {
        this(new FileReader(dataFile));
    }

    public Observations(Reader reader) throws IOException {
        List data;
        try {
            data = new CSVReader(reader).readAll();
        }
        finally {
            reader.close();
        }
        data.remove(0);
        this.roiCount = data.size() == 0 ? 0 : ((String[])data.get(0)).length - 1;
        this.frameCount = this.roiCount == 0 ? 0 : data.size();
        this.rawObservations = new double[this.frameCount][this.roiCount];
        this.scaledObservations = new double[this.frameCount][this.roiCount];
        this.times = new double[this.frameCount];
        this.rawMeans = new double[this.frameCount];
        this.rawStandardDeviations = new double[this.frameCount];
        this.rawStandardErrors = new double[this.frameCount];
        this.scaledMeans = new double[this.frameCount];
        this.scaledStandardDeviations = new double[this.frameCount];
        this.scaledStandardErrors = new double[this.frameCount];
        int invalidRowCount = 0;
        int firstInvalidRow = 0;
        int frameIndex = 0;
        while (frameIndex < this.frameCount) {
            block10: {
                String[] frameData = (String[])data.get(frameIndex);
                boolean invalidRow = false;
                try {
                    this.times[frameIndex] = Float.parseFloat(frameData[0]);
                    int roiIndex = 0;
                    while (roiIndex < this.roiCount) {
                        this.rawObservations[frameIndex][roiIndex] = Float.parseFloat(frameData[roiIndex + 1]);
                        ++roiIndex;
                    }
                }
                catch (NumberFormatException ex) {
                    if (invalidRow) break block10;
                    ++invalidRowCount;
                    if (firstInvalidRow == 0) {
                        firstInvalidRow = frameIndex + 2;
                    }
                    invalidRow = true;
                }
            }
            ++frameIndex;
        }
        if (invalidRowCount > 0) {
            String warnings = "Input data missing values on " + invalidRowCount + " lines starting at line " + firstInvalidRow;
            throw new IllegalArgumentException(warnings);
        }
        this.scaleObservations();
        this.calculateMeans();
    }

    private void scaleObservations() {
        int frameIndex;
        double overallMaxFluorescence = this.rawObservations[0][0];
        double overallMinFluorescence = this.rawObservations[0][0];
        int roiIndex = 0;
        while (roiIndex < this.roiCount) {
            int frameIndex2 = 0;
            while (frameIndex2 < this.frameCount) {
                if (overallMaxFluorescence < this.rawObservations[frameIndex2][roiIndex]) {
                    overallMaxFluorescence = this.rawObservations[frameIndex2][roiIndex];
                }
                if (overallMinFluorescence > this.rawObservations[frameIndex2][roiIndex]) {
                    overallMinFluorescence = this.rawObservations[frameIndex2][roiIndex];
                }
                ++frameIndex2;
            }
            ++roiIndex;
        }
        roiIndex = 0;
        while (roiIndex < this.roiCount) {
            double yMax = this.rawObservations[0][roiIndex];
            int frameIndex3 = 0;
            while (frameIndex3 < this.frameCount) {
                if (yMax < this.rawObservations[frameIndex3][roiIndex]) {
                    yMax = this.rawObservations[frameIndex3][roiIndex];
                }
                ++frameIndex3;
            }
            double yOffset = overallMaxFluorescence - yMax;
            frameIndex = 0;
            while (frameIndex < this.frameCount) {
                this.scaledObservations[frameIndex][roiIndex] = this.rawObservations[frameIndex][roiIndex] + yOffset;
                ++frameIndex;
            }
            ++roiIndex;
        }
        roiIndex = 0;
        while (roiIndex < this.roiCount) {
            double yMin = this.scaledObservations[0][roiIndex];
            int frameIndex4 = 0;
            while (frameIndex4 < this.frameCount) {
                if (yMin > this.scaledObservations[frameIndex4][roiIndex]) {
                    yMin = this.scaledObservations[frameIndex4][roiIndex];
                }
                ++frameIndex4;
            }
            double yScale = 1.0 / (overallMaxFluorescence - yMin);
            if (Double.isInfinite(yScale)) {
                yScale = 1.0;
            }
            frameIndex = 0;
            while (frameIndex < this.frameCount) {
                this.scaledObservations[frameIndex][roiIndex] = (this.scaledObservations[frameIndex][roiIndex] - yMin) * yScale;
                ++frameIndex;
            }
            ++roiIndex;
        }
    }

    public Observations(double[] times, double[][] rawObservations) {
        this.rawObservations = rawObservations;
        this.times = times;
        this.roiCount = rawObservations.length == 0 ? 0 : rawObservations[0].length;
        this.frameCount = this.roiCount == 0 ? 0 : rawObservations.length;
        this.rawMeans = new double[this.frameCount];
        this.rawStandardDeviations = new double[this.frameCount];
        this.rawStandardErrors = new double[this.frameCount];
        this.scaledMeans = new double[this.frameCount];
        this.scaledStandardDeviations = new double[this.frameCount];
        this.scaledStandardErrors = new double[this.frameCount];
        this.scaledObservations = new double[this.frameCount][this.roiCount];
        this.scaleObservations();
        this.calculateMeans();
    }

    private void calculateMeans() {
        int frameIndex = 0;
        while (frameIndex < this.frameCount) {
            double intensity;
            int roiIndex;
            if (this.roiCount > 0) {
                double sum = 0.0;
                roiIndex = 0;
                while (roiIndex < this.roiCount) {
                    intensity = this.rawObservations[frameIndex][roiIndex];
                    sum += intensity;
                    ++roiIndex;
                }
                this.rawMeans[frameIndex] = (float)(sum / (double)this.roiCount);
                sum = 0.0;
                roiIndex = 0;
                while (roiIndex < this.roiCount) {
                    intensity = this.scaledObservations[frameIndex][roiIndex];
                    sum += intensity;
                    ++roiIndex;
                }
                this.scaledMeans[frameIndex] = (float)(sum / (double)this.roiCount);
            } else {
                this.rawMeans[frameIndex] = 0.0;
                this.scaledMeans[frameIndex] = 0.0;
            }
            if (this.roiCount > 1) {
                double variance = 0.0;
                roiIndex = 0;
                while (roiIndex < this.roiCount) {
                    intensity = this.rawObservations[frameIndex][roiIndex];
                    variance += (intensity - this.rawMeans[frameIndex]) * (intensity - this.rawMeans[frameIndex]);
                    ++roiIndex;
                }
                this.rawStandardDeviations[frameIndex] = (float)FastMath.sqrt((double)(variance / (double)(this.roiCount - 1)));
                this.rawStandardErrors[frameIndex] = this.rawStandardDeviations[frameIndex] / FastMath.sqrt((double)this.roiCount);
                variance = 0.0;
                roiIndex = 0;
                while (roiIndex < this.roiCount) {
                    intensity = this.scaledObservations[frameIndex][roiIndex];
                    variance += (intensity - this.scaledMeans[frameIndex]) * (intensity - this.scaledMeans[frameIndex]);
                    ++roiIndex;
                }
                this.scaledStandardDeviations[frameIndex] = (float)FastMath.sqrt((double)(variance / (double)(this.roiCount - 1)));
                this.scaledStandardErrors[frameIndex] = this.scaledStandardDeviations[frameIndex] / FastMath.sqrt((double)this.roiCount);
            } else {
                this.rawStandardDeviations[frameIndex] = 0.0;
                this.rawStandardErrors[frameIndex] = 0.0;
                this.scaledStandardDeviations[frameIndex] = 0.0;
                this.scaledStandardErrors[frameIndex] = 0.0;
            }
            ++frameIndex;
        }
    }

    public Observations getSubset(double startTime, double endTime) {
        int subsetFrameCount = 0;
        int subsetStartFrame = -1;
        int index = 0;
        while (index < this.times.length) {
            double time = this.times[index];
            if (time >= startTime) {
                if (!(time <= endTime)) break;
                ++subsetFrameCount;
                if (subsetStartFrame < 0) {
                    subsetStartFrame = index;
                }
            }
            ++index;
        }
        if (subsetFrameCount == 0) {
            return new Observations();
        }
        int subsetEndFrame = subsetStartFrame + subsetFrameCount;
        double[] subsetTimes = Arrays.copyOfRange(this.times, subsetStartFrame, subsetEndFrame);
        double[] subsetRawMeans = Arrays.copyOfRange(this.rawMeans, subsetStartFrame, subsetEndFrame);
        double[] subsetRawStdevs = Arrays.copyOfRange(this.rawStandardDeviations, subsetStartFrame, subsetEndFrame);
        double[] subsetRawSems = Arrays.copyOfRange(this.rawStandardErrors, subsetStartFrame, subsetEndFrame);
        double[] subsetScaledMeans = Arrays.copyOfRange(this.scaledMeans, subsetStartFrame, subsetEndFrame);
        double[] subsetScaledStdevs = Arrays.copyOfRange(this.scaledStandardDeviations, subsetStartFrame, subsetEndFrame);
        double[] subsetScaledSems = Arrays.copyOfRange(this.scaledStandardErrors, subsetStartFrame, subsetEndFrame);
        double[][] subsetRawObservations = (double[][])Arrays.copyOfRange(this.rawObservations, subsetStartFrame, subsetEndFrame);
        double[][] subsetScaledObservations = (double[][])Arrays.copyOfRange(this.scaledObservations, subsetStartFrame, subsetEndFrame);
        Observations result = new Observations(subsetTimes, subsetRawObservations, subsetRawMeans, subsetRawStdevs, subsetRawSems, subsetScaledObservations, subsetScaledMeans, subsetScaledStdevs, subsetScaledSems, this.roiCount, subsetFrameCount);
        return result;
    }
}

