/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.Calculations;
import fmsim.model.Rates;
import fmsim.model.Vesicle;
import fmsim.model.VesicleModel;
import fmsim.model.VesicleModelConfiguration;
import java.util.LinkedList;
import java.util.List;

public class VesicleModelState
implements Cloneable {
    public final List<Vesicle> plasmaMembranePreVesicles = new LinkedList<Vesicle>();
    public final List<Vesicle> plasmaMembraneVesicles = new LinkedList<Vesicle>();
    public final List<Vesicle> rrpPreVesicles = new LinkedList<Vesicle>();
    public final List<Vesicle> rrpVesicles = new LinkedList<Vesicle>();
    public final List<Vesicle> rpPreVesicles = new LinkedList<Vesicle>();
    public final List<Vesicle> rpVesicles = new LinkedList<Vesicle>();
    public final List<Vesicle> endosomePreVesicles = new LinkedList<Vesicle>();
    public final List<Vesicle> endosomeVesicles = new LinkedList<Vesicle>();
    int totalVesicleCount;
    public boolean acidPulsePresent = false;
    public boolean ammoniaPulsePresent = false;

    VesicleModelState() {
        this.totalVesicleCount = 1;
    }

    public VesicleModelState(VesicleModelConfiguration configuration) {
        int i = 0;
        while (i < configuration.rrpSpacesAvailable) {
            this.rrpVesicles.add(new Vesicle(Vesicle.VesicleType.CME, true, 0.0, 0.0));
            ++i;
        }
        i = configuration.rrpSpacesAvailable;
        while (i < configuration.totalVesicleCount) {
            this.rpVesicles.add(new Vesicle(Vesicle.VesicleType.CME, true, 0.0, 0.0));
            ++i;
        }
        this.totalVesicleCount = configuration.totalVesicleCount;
    }

    public VesicleModelState clone() {
        VesicleModelState result = new VesicleModelState();
        this.cloneList(this.plasmaMembranePreVesicles, result.plasmaMembranePreVesicles);
        this.cloneList(this.plasmaMembraneVesicles, result.plasmaMembraneVesicles);
        this.cloneList(this.rrpPreVesicles, result.rrpPreVesicles);
        this.cloneList(this.rrpVesicles, result.rrpVesicles);
        this.cloneList(this.rpPreVesicles, result.rpPreVesicles);
        this.cloneList(this.rpVesicles, result.rpVesicles);
        this.cloneList(this.endosomePreVesicles, result.endosomePreVesicles);
        this.cloneList(this.endosomeVesicles, result.endosomeVesicles);
        result.totalVesicleCount = this.totalVesicleCount;
        result.acidPulsePresent = this.acidPulsePresent;
        result.ammoniaPulsePresent = this.ammoniaPulsePresent;
        return result;
    }

    private void cloneList(List<Vesicle> source, List<Vesicle> target) {
        for (Vesicle vesicle : source) {
            target.add(vesicle.clone());
        }
    }

    public final double calculateWeight(double observationMean, double observationStdDev, Rates parameters, VesicleModel.FluorescenceType fluorescenceType) {
        return Calculations.calculateWeight(observationMean, observationStdDev, this.getFluorescence(fluorescenceType));
    }

    public double getFluorescence(VesicleModel.FluorescenceType fluorescenceType) {
        switch (fluorescenceType) {
            case FM143: {
                return this.getFluorescenceFM143();
            }
            case FM210: {
                return this.getFluorescenceFM210();
            }
            case PHLUORIN: {
                return this.getFluorescencePHluorin();
            }
        }
        throw new RuntimeException("Unknown fluorescence type");
    }

    public double getFluorescencePHluorin() {
        double vesicleCount = 0.0;
        if (this.ammoniaPulsePresent) {
            return 1.0;
        }
        vesicleCount += this.getFluorescencePHluorin(this.rrpPreVesicles);
        vesicleCount += this.getFluorescencePHluorin(this.rpPreVesicles);
        vesicleCount += this.getFluorescencePHluorin(this.endosomePreVesicles);
        if (!this.acidPulsePresent) {
            vesicleCount += this.getFluorescencePHluorin(this.plasmaMembranePreVesicles);
            vesicleCount += this.getFluorescencePHluorin(this.plasmaMembraneVesicles);
        }
        return vesicleCount / (double)this.totalVesicleCount;
    }

    private double getFluorescencePHluorin(List<Vesicle> vesicles) {
        double result = 0.0;
        for (Vesicle vesicle : vesicles) {
            result += vesicle.pH;
        }
        return result;
    }

    public float getFluorescenceFM143() {
        int vesicleCount = 0;
        for (Vesicle vesicle : this.rrpPreVesicles) {
            if (!vesicle.tagged) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rrpVesicles) {
            if (!vesicle.tagged) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rpPreVesicles) {
            if (!vesicle.tagged) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rpVesicles) {
            if (!vesicle.tagged) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.endosomePreVesicles) {
            if (!vesicle.tagged) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.endosomeVesicles) {
            if (!vesicle.tagged) continue;
            ++vesicleCount;
        }
        return (float)vesicleCount / (float)this.totalVesicleCount;
    }

    public float getFluorescenceFM210() {
        return this.getCMEVesicleCount() / (float)this.totalVesicleCount;
    }

    public float getCMEVesicleCount() {
        int vesicleCount = 0;
        for (Vesicle vesicle : this.rrpPreVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.CME) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rrpVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.CME) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rpPreVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.CME) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rpVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.CME) continue;
            ++vesicleCount;
        }
        return vesicleCount;
    }

    public float getADBEVesicleCount() {
        int vesicleCount = 0;
        for (Vesicle vesicle : this.rrpPreVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.ADBE) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rrpVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.ADBE) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rpPreVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.ADBE) continue;
            ++vesicleCount;
        }
        for (Vesicle vesicle : this.rpVesicles) {
            if (!vesicle.tagged || vesicle.type != Vesicle.VesicleType.ADBE) continue;
            ++vesicleCount;
        }
        return vesicleCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acidPulsePresent ? 1231 : 1237);
        result = 31 * result + (this.ammoniaPulsePresent ? 1231 : 1237);
        result = 31 * result + (this.endosomePreVesicles == null ? 0 : this.endosomePreVesicles.hashCode());
        result = 31 * result + (this.endosomeVesicles == null ? 0 : this.endosomeVesicles.hashCode());
        result = 31 * result + (this.plasmaMembranePreVesicles == null ? 0 : this.plasmaMembranePreVesicles.hashCode());
        result = 31 * result + (this.plasmaMembraneVesicles == null ? 0 : this.plasmaMembraneVesicles.hashCode());
        result = 31 * result + (this.rpPreVesicles == null ? 0 : this.rpPreVesicles.hashCode());
        result = 31 * result + (this.rpVesicles == null ? 0 : this.rpVesicles.hashCode());
        result = 31 * result + (this.rrpPreVesicles == null ? 0 : this.rrpPreVesicles.hashCode());
        result = 31 * result + (this.rrpVesicles == null ? 0 : this.rrpVesicles.hashCode());
        result = 31 * result + this.totalVesicleCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VesicleModelState other = (VesicleModelState)obj;
        if (this.acidPulsePresent != other.acidPulsePresent) {
            return false;
        }
        if (this.ammoniaPulsePresent != other.ammoniaPulsePresent) {
            return false;
        }
        if (this.endosomePreVesicles == null ? other.endosomePreVesicles != null : !this.endosomePreVesicles.equals(other.endosomePreVesicles)) {
            return false;
        }
        if (this.endosomeVesicles == null ? other.endosomeVesicles != null : !this.endosomeVesicles.equals(other.endosomeVesicles)) {
            return false;
        }
        if (this.plasmaMembranePreVesicles == null ? other.plasmaMembranePreVesicles != null : !this.plasmaMembranePreVesicles.equals(other.plasmaMembranePreVesicles)) {
            return false;
        }
        if (this.plasmaMembraneVesicles == null ? other.plasmaMembraneVesicles != null : !this.plasmaMembraneVesicles.equals(other.plasmaMembraneVesicles)) {
            return false;
        }
        if (this.rpPreVesicles == null ? other.rpPreVesicles != null : !this.rpPreVesicles.equals(other.rpPreVesicles)) {
            return false;
        }
        if (this.rpVesicles == null ? other.rpVesicles != null : !this.rpVesicles.equals(other.rpVesicles)) {
            return false;
        }
        if (this.rrpPreVesicles == null ? other.rrpPreVesicles != null : !this.rrpPreVesicles.equals(other.rrpPreVesicles)) {
            return false;
        }
        if (this.rrpVesicles == null ? other.rrpVesicles != null : !this.rrpVesicles.equals(other.rrpVesicles)) {
            return false;
        }
        return this.totalVesicleCount == other.totalVesicleCount;
    }
}

