/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.VesicleModel;

public class VesicleModelConfiguration {
    public static final int IMPORT_DATA_LENGTH = 6;
    public boolean cme;
    public boolean adbe;
    public double rrpCmeVesicleRatio;
    public int rrpSpacesAvailable;
    public int totalVesicleCount;
    public VesicleModel.FluorescenceType fluorescenceType;

    public VesicleModelConfiguration() {
        this(true, true, 0.3, 10, 100, VesicleModel.FluorescenceType.FM143);
    }

    public VesicleModelConfiguration(boolean cme, boolean adbe, double rrpCmeVesicleRatio, int rrpSpacesAvailable, int totalVesicleCount, VesicleModel.FluorescenceType fluorescenceType) {
        this.cme = cme;
        this.adbe = adbe;
        this.rrpCmeVesicleRatio = rrpCmeVesicleRatio;
        this.rrpSpacesAvailable = rrpSpacesAvailable;
        this.totalVesicleCount = totalVesicleCount;
        this.fluorescenceType = fluorescenceType;
    }

    public String toString() {
        return "[" + this.cme + ", " + this.adbe + ", " + (Object)((Object)this.fluorescenceType) + ", " + this.rrpCmeVesicleRatio + ", " + this.rrpSpacesAvailable + ", " + this.totalVesicleCount + "]";
    }

    public String[] exportData() {
        String[] result = new String[]{"" + this.cme, "" + this.adbe, "" + this.rrpCmeVesicleRatio, "" + this.rrpSpacesAvailable, "" + this.totalVesicleCount, this.fluorescenceType.name()};
        return result;
    }

    public static VesicleModelConfiguration importData(String[] data) {
        int totalVesicleCount;
        int rrpSpacesAvailable;
        double rrpCmeVesicleRatio;
        boolean adbe;
        boolean cme;
        if (data.length != 6) {
            throw new IllegalArgumentException();
        }
        try {
            cme = Boolean.parseBoolean(data[0]);
            adbe = Boolean.parseBoolean(data[1]);
            rrpCmeVesicleRatio = Double.parseDouble(data[2]);
            rrpSpacesAvailable = Integer.parseInt(data[3]);
            totalVesicleCount = Integer.parseInt(data[4]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
        VesicleModel.FluorescenceType fluorescenceType = VesicleModel.FluorescenceType.valueOf(data[5]);
        return new VesicleModelConfiguration(cme, adbe, rrpCmeVesicleRatio, rrpSpacesAvailable, totalVesicleCount, fluorescenceType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adbe ? 1231 : 1237);
        result = 31 * result + (this.cme ? 1231 : 1237);
        result = 31 * result + (this.fluorescenceType == null ? 0 : this.fluorescenceType.hashCode());
        long temp = Double.doubleToLongBits(this.rrpCmeVesicleRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.rrpSpacesAvailable;
        result = 31 * result + this.totalVesicleCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VesicleModelConfiguration other = (VesicleModelConfiguration)obj;
        if (this.adbe != other.adbe) {
            return false;
        }
        if (this.cme != other.cme) {
            return false;
        }
        if (this.fluorescenceType != other.fluorescenceType) {
            return false;
        }
        if (Double.doubleToLongBits(this.rrpCmeVesicleRatio) != Double.doubleToLongBits(other.rrpCmeVesicleRatio)) {
            return false;
        }
        if (this.rrpSpacesAvailable != other.rrpSpacesAvailable) {
            return false;
        }
        return this.totalVesicleCount == other.totalVesicleCount;
    }
}

