/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.Random;
import fmsim.model.Rates;
import fmsim.model.Vesicle;
import fmsim.model.VesicleModelConfiguration;
import fmsim.model.VesicleModelState;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.math3.util.FastMath;

public class VesicleModel {
    private static final double PH_UNIT_CHANGE = 0.25;
    Random random = new Random(){
        java.util.Random impl = new java.util.Random();

        @Override
        public int nextInt(int size) {
            return this.impl.nextInt(size);
        }

        @Override
        public double nextDouble() {
            return this.impl.nextDouble();
        }
    };
    Rates currentRates;
    double time;
    VesicleModelState state;
    final VesicleModelConfiguration configuration;
    Rule exocytosisRule = new Rule(){

        @Override
        public double getPropensity() {
            return VesicleModel.this.currentRates.values[0].value * (double)VesicleModel.this.state.rrpVesicles.size();
        }

        @Override
        public void apply() {
            Vesicle vesicle = VesicleModel.this.state.rrpVesicles.remove(VesicleModel.this.random.nextInt(VesicleModel.this.state.rrpVesicles.size()));
            vesicle.setValues(null, false, VesicleModel.this.time + VesicleModel.this.currentRates.values[5].value, 1.0);
            VesicleModel.this.state.plasmaMembranePreVesicles.add(vesicle);
        }
    };
    Rule cmeRule = new Rule(){

        @Override
        public double getPropensity() {
            return VesicleModel.this.currentRates.values[1].value * (double)VesicleModel.this.state.plasmaMembraneVesicles.size();
        }

        @Override
        public void apply() {
            Vesicle vesicle = VesicleModel.this.state.plasmaMembraneVesicles.remove(VesicleModel.this.random.nextInt(VesicleModel.this.state.plasmaMembraneVesicles.size()));
            vesicle.setValues(Vesicle.VesicleType.CME, VesicleModel.this.currentRates.tagging, VesicleModel.this.time + VesicleModel.this.currentRates.values[6].value, 1.0);
            int rrpSpaces = Math.max(0, VesicleModel.this.configuration.rrpSpacesAvailable - VesicleModel.this.state.rrpVesicles.size() - VesicleModel.this.state.rrpPreVesicles.size());
            if (VesicleModel.this.random.nextDouble() < VesicleModel.this.configuration.rrpCmeVesicleRatio && rrpSpaces > 0) {
                VesicleModel.this.state.rrpPreVesicles.add(vesicle);
            } else {
                VesicleModel.this.state.rpPreVesicles.add(vesicle);
            }
        }
    };
    Rule adbeRule = new Rule(){

        @Override
        public double getPropensity() {
            return VesicleModel.this.currentRates.values[2].value * FastMath.floor((double)(VesicleModel.this.state.plasmaMembraneVesicles.size() / 20));
        }

        @Override
        public void apply() {
            int i = 0;
            while (i < 20) {
                Vesicle vesicle = VesicleModel.this.state.plasmaMembraneVesicles.remove(VesicleModel.this.random.nextInt(VesicleModel.this.state.plasmaMembraneVesicles.size()));
                vesicle.setValues(null, VesicleModel.this.currentRates.tagging, VesicleModel.this.time + VesicleModel.this.currentRates.values[7].value, 1.0);
                VesicleModel.this.state.endosomePreVesicles.add(vesicle);
                ++i;
            }
        }
    };
    Rule buddingRule = new Rule(){

        @Override
        public double getPropensity() {
            return VesicleModel.this.currentRates.values[3].value * (double)VesicleModel.this.state.endosomeVesicles.size();
        }

        @Override
        public void apply() {
            Vesicle vesicle = VesicleModel.this.state.endosomeVesicles.remove(VesicleModel.this.random.nextInt(VesicleModel.this.state.endosomeVesicles.size()));
            vesicle.setValues(Vesicle.VesicleType.ADBE, vesicle.tagged, VesicleModel.this.time + VesicleModel.this.currentRates.values[8].value, vesicle.pH);
            VesicleModel.this.state.rpPreVesicles.add(vesicle);
        }
    };
    Rule poolChangeRule = new Rule(){

        @Override
        public double getPropensity() {
            int spaces = Math.max(0, VesicleModel.this.configuration.rrpSpacesAvailable - VesicleModel.this.state.rrpVesicles.size() - VesicleModel.this.state.rrpPreVesicles.size());
            return VesicleModel.this.currentRates.values[4].value * (double)VesicleModel.this.state.rpVesicles.size() * (double)spaces;
        }

        @Override
        public void apply() {
            Vesicle vesicle = VesicleModel.this.state.rpVesicles.remove(VesicleModel.this.random.nextInt(VesicleModel.this.state.rpVesicles.size()));
            vesicle.setValues(vesicle.type, vesicle.tagged, VesicleModel.this.time + VesicleModel.this.currentRates.values[9].value, vesicle.pH);
            VesicleModel.this.state.rrpPreVesicles.add(vesicle);
        }
    };
    private final Rule[] rules = new Rule[]{this.exocytosisRule, this.cmeRule, this.adbeRule, this.buddingRule, this.poolChangeRule};

    public VesicleModel(VesicleModelConfiguration configuration) {
        this.configuration = configuration;
    }

    public VesicleModelState[] getInitialSampleStates(int n) {
        VesicleModelState[] result = new VesicleModelState[n];
        int i = 0;
        while (i < n) {
            result[i] = this.getInitialSampleState();
            ++i;
        }
        return result;
    }

    public void updateDelays() {
        this.updateDelays(this.state.plasmaMembranePreVesicles, this.state.plasmaMembraneVesicles);
        this.updateDelays(this.state.rrpPreVesicles, this.state.rrpVesicles);
        this.updateDelays(this.state.rpPreVesicles, this.state.rpVesicles);
        this.updateDelays(this.state.endosomePreVesicles, this.state.endosomeVesicles);
    }

    private void updateDelays(List<Vesicle> delayQueue, List<Vesicle> targetQueue) {
        ListIterator<Vesicle> vesicles = delayQueue.listIterator();
        while (vesicles.hasNext()) {
            Vesicle vesicle = vesicles.next();
            if (!(this.time >= vesicle.time)) continue;
            vesicles.remove();
            vesicle.setValues(vesicle.type, vesicle.tagged, this.time, vesicle.pH);
            targetQueue.add(vesicle);
        }
    }

    public void setRates(Rates rates) {
        this.currentRates = rates;
        if (rates != null && this.state != null) {
            this.state.acidPulsePresent = rates.acidPulsePresent;
            this.state.ammoniaPulsePresent = rates.ammoniaPulsePresent;
        }
    }

    public double getTime() {
        return this.time;
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public void resetState(VesicleModelState state, double time) {
        this.state = state.clone();
        this.time = time;
    }

    public VesicleModelState getState() {
        return this.state;
    }

    public VesicleModelState getInitialSampleState() {
        return new VesicleModelState(this.configuration);
    }

    public void setTime(double time) {
        this.time = time;
    }

    public void updatePh(double timeDelta) {
        double phChange = 0.25 * timeDelta;
        this.updatePh(this.state.rrpPreVesicles, phChange);
        this.updatePh(this.state.rrpVesicles, phChange);
        this.updatePh(this.state.rpPreVesicles, phChange);
        this.updatePh(this.state.rpVesicles, phChange);
        this.updatePh(this.state.endosomePreVesicles, phChange);
        this.updatePh(this.state.endosomeVesicles, phChange);
    }

    private void updatePh(List<Vesicle> vesicles, double phChange) {
        for (Vesicle vesicle : vesicles) {
            vesicle.pH = Math.max(0.0, vesicle.pH - phChange);
        }
    }

    public static enum FluorescenceType {
        FM143,
        FM210,
        PHLUORIN;

    }

    public static abstract class Rule {
        public abstract double getPropensity();

        public abstract void apply();
    }
}

