/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.VesicleModel;
import fmsim.model.VesicleModelState;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;

public class StepSimulator {
    private final Map<VesicleModel.Rule, Double> activityMap = new HashMap<VesicleModel.Rule, Double>();
    public boolean noRulesPossible;
    private final VesicleModel model;

    public StepSimulator(VesicleModel model) {
        this.model = model;
    }

    public VesicleModelState runSimulation(double startTime, double endTime, VesicleModelState initialState) {
        this.noRulesPossible = false;
        this.model.resetState(initialState, startTime);
        this.updateActivityMap();
        do {
            int clashes = 0;
            while (!this.runSingleEvent() && clashes < 1000 && !this.noRulesPossible) {
                ++clashes;
                Thread.yield();
            }
            if (clashes < 1000) continue;
            System.out.println("Aborted timepoint");
        } while (!this.noRulesPossible && this.model.getTime() < endTime);
        return this.model.getState();
    }

    private void updateActivityMap() {
        this.model.updateDelays();
        VesicleModel.Rule[] ruleArray = this.model.getRules();
        int n = ruleArray.length;
        int n2 = 0;
        while (n2 < n) {
            VesicleModel.Rule rule = ruleArray[n2];
            double activity = rule.getPropensity();
            this.activityMap.put(rule, activity);
            ++n2;
        }
    }

    private boolean runSingleEvent() {
        VesicleModel.Rule rule = this.pickRule();
        if (rule == null) {
            this.noRulesPossible = true;
            return false;
        }
        this.applyRule(rule);
        return true;
    }

    private void applyRule(VesicleModel.Rule rule) {
        rule.apply();
        double timeDelta = this.getTimeDelta();
        this.model.updatePh(timeDelta);
        this.model.setTime(this.model.getTime() + timeDelta);
        this.updateActivityMap();
    }

    private double getTimeDelta() {
        double totalQuantity = 0.0;
        for (Double current : this.activityMap.values()) {
            totalQuantity += current.doubleValue();
        }
        return -FastMath.log((double)FastMath.random()) / totalQuantity;
    }

    private VesicleModel.Rule pickRule() {
        double totalQuantity = 0.0;
        if (this.activityMap.size() == 0) {
            return null;
        }
        for (Map.Entry<VesicleModel.Rule, Double> entry : this.activityMap.entrySet()) {
            totalQuantity += entry.getValue().doubleValue();
        }
        VesicleModel.Rule lastRule = null;
        double item = (float)(totalQuantity * FastMath.random());
        for (Map.Entry<VesicleModel.Rule, Double> entry : this.activityMap.entrySet()) {
            if (!(entry.getValue() > 0.0)) continue;
            lastRule = entry.getKey();
            if (item <= entry.getValue()) {
                return entry.getKey();
            }
            item -= entry.getValue().doubleValue();
        }
        return lastRule;
    }
}

