/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.Calculations;
import java.util.Arrays;

public class Rates
implements Cloneable {
    public static final int IMPORT_DATA_LENGTH = 13;
    public static final int VALUES_LENGTH = 10;
    public static final int RATE_EXOCYTOSIS = 0;
    public static final int RATE_CME = 1;
    public static final int RATE_ADBE = 2;
    public static final int RATE_BUDDING = 3;
    public static final int RATE_POOL_CHANGE = 4;
    public static final int DELTA_TIME_EXOCYTOSIS = 5;
    public static final int DELTA_TIME_CME = 6;
    public static final int DELTA_TIME_ADBE = 7;
    public static final int DELTA_TIME_BUDDING = 8;
    public static final int DELTA_TIME_POOL_CHANGE = 9;
    public RateValue[] values = new RateValue[10];
    public boolean tagging = false;
    public boolean acidPulsePresent = false;
    public boolean ammoniaPulsePresent = false;

    public static Rates getDefaultRates() {
        Rates rates = new Rates();
        rates.values[0] = new RateValue(2.0);
        rates.values[3] = new RateValue(8.0E-5);
        rates.values[1] = new RateValue(2.0);
        rates.values[2] = new RateValue(0.0);
        rates.values[4] = new RateValue(1.0);
        rates.values[5] = new RateValue(0.0);
        rates.values[8] = new RateValue(15.0);
        rates.values[6] = new RateValue(2.0);
        rates.values[7] = new RateValue(15.0);
        rates.values[9] = new RateValue(0.0);
        return rates;
    }

    public Rates() {
        int index = 0;
        while (index < 10) {
            this.values[index] = RateValue.INHERITED_RATE;
            ++index;
        }
    }

    public Rates(double exocytosisRate, double cmeRate, double adbeRate, double buddingRate, double poolChangeRate, double deltaTimeExocytosis, double deltaTimeCME, double deltaTimeADBE, double deltaTimeBudding, double deltaTimePoolChange, boolean tagging, boolean acidPulsePresent, boolean ammoniaPulsePresent) {
        this.values[0] = new RateValue(exocytosisRate);
        this.values[3] = new RateValue(buddingRate);
        this.values[1] = new RateValue(cmeRate);
        this.values[2] = new RateValue(adbeRate);
        this.values[4] = new RateValue(poolChangeRate);
        this.values[5] = new RateValue(deltaTimeExocytosis);
        this.values[6] = new RateValue(deltaTimeCME);
        this.values[7] = new RateValue(deltaTimeADBE);
        this.values[8] = new RateValue(deltaTimeBudding);
        this.values[9] = new RateValue(deltaTimePoolChange);
        this.tagging = tagging;
        this.acidPulsePresent = acidPulsePresent;
        this.ammoniaPulsePresent = ammoniaPulsePresent;
    }

    public Rates(Rates rates, Rates defaultRates) {
        int index = 0;
        while (index < 10) {
            this.values[index] = this.getValidRate(rates.values[index], defaultRates.values[index]);
            ++index;
        }
        this.tagging = rates.tagging;
        this.acidPulsePresent = rates.acidPulsePresent;
        this.ammoniaPulsePresent = rates.ammoniaPulsePresent;
    }

    private Rates(RateValue[] values, boolean tagging, boolean acidPulsePresent, boolean ammoniaPulsePresent) {
        this.values = values;
        this.tagging = tagging;
        this.acidPulsePresent = acidPulsePresent;
        this.ammoniaPulsePresent = ammoniaPulsePresent;
    }

    private RateValue getValidRate(RateValue rate, RateValue defaultRate) {
        return rate != RateValue.INHERITED_RATE ? rate : defaultRate;
    }

    public Rates clone() {
        RateValue[] cloneValues = Arrays.copyOf(this.values, 10);
        return new Rates(cloneValues, this.tagging, this.acidPulsePresent, this.ammoniaPulsePresent);
    }

    public String toString() {
        return String.valueOf(Arrays.toString(this.values)) + ", " + this.tagging + ", " + this.acidPulsePresent + ", " + this.ammoniaPulsePresent;
    }

    public Rates getProposalParameters() {
        Rates result = this.clone();
        int index = 0;
        while (index < 10) {
            result.values[index] = Calculations.getProposalParameter(this.values[index]);
            ++index;
        }
        return result;
    }

    public Rates getArbitraryParameters() {
        return this.getProposalParameters();
    }

    public String[] exportData() {
        String[] result = new String[13];
        int index = 0;
        while (index < 10) {
            result[index] = this.values[index].exportData();
            ++index;
        }
        result[10] = Boolean.toString(this.tagging);
        result[11] = Boolean.toString(this.acidPulsePresent);
        result[12] = Boolean.toString(this.ammoniaPulsePresent);
        return result;
    }

    public static Rates importData(String[] importData) {
        if (importData.length != 13) {
            throw new IllegalArgumentException();
        }
        Rates result = new Rates();
        int index = 0;
        while (index < 10) {
            result.values[index] = RateValue.importData(importData[index]);
            ++index;
        }
        result.tagging = Boolean.parseBoolean(importData[10]);
        result.acidPulsePresent = Boolean.parseBoolean(importData[11]);
        result.ammoniaPulsePresent = Boolean.parseBoolean(importData[12]);
        return result;
    }

    public boolean isFixedRates() {
        int index = 0;
        while (index < 10) {
            if (this.values[index].type != RateValue.Type.FIXED) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acidPulsePresent ? 1231 : 1237);
        result = 31 * result + (this.ammoniaPulsePresent ? 1231 : 1237);
        result = 31 * result + (this.tagging ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rates other = (Rates)obj;
        if (this.acidPulsePresent != other.acidPulsePresent) {
            return false;
        }
        if (this.ammoniaPulsePresent != other.ammoniaPulsePresent) {
            return false;
        }
        if (this.tagging != other.tagging) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public static class RateValue {
        public static final RateValue INHERITED_RATE = new RateValue(Type.INHERITED, 0.0);
        public final Type type;
        public final double value;

        public static RateValue getInferredRate() {
            return new RateValue(Type.INFERRED, 0.0);
        }

        public RateValue(Type type, double value) {
            this.type = type;
            this.value = value;
        }

        public RateValue(double value) {
            this(Type.FIXED, value);
        }

        public RateValue(int value) {
            this(Type.FIXED, value);
        }

        public String toString() {
            switch (this.type) {
                case FIXED: {
                    return Double.toString(this.value);
                }
                case INFERRED: {
                    return "Inferred:" + Double.toString(this.value);
                }
                case INHERITED: {
                    return "Inherited";
                }
            }
            return "Unknown rate type";
        }

        public String exportData() {
            switch (this.type) {
                case FIXED: {
                    return Double.toString(this.value);
                }
                case INFERRED: {
                    return "I:" + Double.toString(this.value);
                }
                case INHERITED: {
                    return "P";
                }
            }
            throw new RuntimeException("Unknown rate type");
        }

        public static RateValue importData(String importData) {
            if (importData == null) {
                throw new NullPointerException();
            }
            String trimmed = importData.trim();
            if ("P".equals(trimmed)) {
                return INHERITED_RATE;
            }
            if (trimmed.startsWith("I:")) {
                if ("I:0.0".equals(trimmed)) {
                    return RateValue.getInferredRate();
                }
                try {
                    return new RateValue(Type.INFERRED, Double.parseDouble(trimmed.substring(2)));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            return new RateValue(Double.parseDouble(trimmed));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RateValue other = (RateValue)obj;
            if (this.type != other.type) {
                return false;
            }
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }

        public static enum Type {
            FIXED,
            INHERITED,
            INFERRED;

        }
    }
}

