/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.ProtocolEvent;
import fmsim.model.Rates;
import java.util.List;

public class RateChangeEvent {
    public final double time;
    public final Rates rates;
    public final List<ProtocolEvent> sourceEvents;

    public RateChangeEvent(double time, List<ProtocolEvent> sourceEvents, Rates defaultRates) {
        this.time = time;
        this.sourceEvents = sourceEvents;
        this.rates = this.flattenRateInheritance(defaultRates);
    }

    private Rates flattenRateInheritance(Rates defaultRates) {
        Rates result = defaultRates.clone();
        if (this.sourceEvents.size() == 0) {
            return result;
        }
        int index = 0;
        while (index < 10) {
            for (ProtocolEvent event : this.sourceEvents) {
                if (event.getRates().values[index].type == Rates.RateValue.Type.INHERITED) continue;
                result.values[index] = event.getRates().values[index];
                break;
            }
            ++index;
        }
        Rates sourceRates = this.sourceEvents.get(0).getRates();
        result.tagging = sourceRates.tagging;
        result.acidPulsePresent = sourceRates.acidPulsePresent;
        result.ammoniaPulsePresent = sourceRates.ammoniaPulsePresent;
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rates == null ? 0 : this.rates.hashCode());
        result = 31 * result + (this.sourceEvents == null ? 0 : this.sourceEvents.hashCode());
        long temp = Double.doubleToLongBits(this.time);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RateChangeEvent other = (RateChangeEvent)obj;
        if (this.rates == null ? other.rates != null : !this.rates.equals(other.rates)) {
            return false;
        }
        if (this.sourceEvents == null ? other.sourceEvents != null : !this.sourceEvents.equals(other.sourceEvents)) {
            return false;
        }
        return Double.doubleToLongBits(this.time) == Double.doubleToLongBits(other.time);
    }

    public String toString() {
        return String.valueOf(this.time) + " : " + (this.sourceEvents.size() == 0 ? "BASE" : this.sourceEvents.get(0).getDescription()) + "=" + this.rates;
    }
}

