/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.Rates;
import java.util.Arrays;

public class ProtocolEvent
implements Cloneable {
    double startTime;
    double duration;
    EventType type;
    String frequency;
    String chemical;
    String concentration;
    String description;
    Rates rates;

    public static ProtocolEvent getNullEvent(double startTime, double duration, String description) {
        return new ProtocolEvent(startTime, duration, description, EventType.NONE, null, null, null, new Rates());
    }

    public static ProtocolEvent getChemicalStimulusEvent(double startTime, double duration, String description, String chemical, String concentration) {
        return new ProtocolEvent(startTime, duration, description, EventType.CHEMICAL_STIMULUS, null, chemical, concentration, new Rates());
    }

    public static ProtocolEvent getChemicalModifierEvent(double startTime, double duration, String description, String chemical, String concentration) {
        return new ProtocolEvent(startTime, duration, description, EventType.CHEMICAL_MODIFIER, null, chemical, concentration, new Rates());
    }

    public static ProtocolEvent getElectricalEvent(double startTime, double duration, String description, String frequency) {
        return new ProtocolEvent(startTime, duration, description, EventType.ELECTRICAL, frequency, null, null, new Rates());
    }

    public ProtocolEvent(double startTime, double duration, String description, EventType type, String frequency, String chemical, String concentration, Rates rates) {
        this.startTime = startTime;
        this.duration = duration;
        this.type = type;
        this.frequency = frequency;
        this.chemical = chemical;
        this.concentration = concentration;
        this.description = description;
        this.rates = rates;
    }

    public Rates getRates() {
        return this.rates;
    }

    public void setRates(Rates rates) {
        this.rates = rates;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getDuration() {
        return this.duration;
    }

    public String toString() {
        switch (this.type) {
            case ELECTRICAL: {
                return (Object)((Object)this.type) + " (" + this.frequency + ")";
            }
            case CHEMICAL_STIMULUS: 
            case CHEMICAL_MODIFIER: {
                return (Object)((Object)this.type) + " (" + this.chemical + ", " + this.concentration + ")";
            }
        }
        return this.type.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getChemical() {
        return this.chemical;
    }

    public void setChemical(String chemical) {
        this.chemical = chemical;
    }

    public String getConcentration() {
        return this.concentration;
    }

    public void setConcentration(String concentration) {
        this.concentration = concentration;
    }

    public String[] exportData() {
        String[] ratesData = this.rates.exportData();
        String[] result = new String[7 + ratesData.length];
        System.arraycopy(ratesData, 0, result, 7, ratesData.length);
        result[0] = "" + this.startTime;
        result[1] = "" + this.duration;
        result[2] = this.type.name();
        result[3] = this.frequency;
        result[4] = this.chemical;
        result[5] = this.concentration;
        result[6] = this.description;
        return result;
    }

    public static ProtocolEvent importData(String[] data) {
        double duration;
        double startTime;
        if (data.length != 20) {
            throw new IllegalArgumentException();
        }
        String frequency = null;
        String chemical = null;
        String concentration = null;
        try {
            startTime = Double.parseDouble(data[0]);
            duration = Double.parseDouble(data[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
        EventType type = EventType.valueOf(data[2]);
        switch (type) {
            case ELECTRICAL: {
                frequency = data[3];
                break;
            }
            case CHEMICAL_STIMULUS: 
            case CHEMICAL_MODIFIER: {
                chemical = data[4];
                concentration = data[5];
            }
        }
        String description = data[6];
        String[] ratesData = Arrays.copyOfRange(data, 7, 20);
        Rates rates = Rates.importData(ratesData);
        return new ProtocolEvent(startTime, duration, description, type, frequency, chemical, concentration, rates);
    }

    public ProtocolEvent clone() {
        return new ProtocolEvent(this.startTime, this.duration, this.description, this.type, this.frequency, this.chemical, this.concentration, this.rates.clone());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chemical == null ? 0 : this.chemical.hashCode());
        result = 31 * result + (this.concentration == null ? 0 : this.concentration.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        long temp = Double.doubleToLongBits(this.duration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = 31 * result + (this.rates == null ? 0 : this.rates.hashCode());
        temp = Double.doubleToLongBits(this.startTime);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolEvent other = (ProtocolEvent)obj;
        if (this.chemical == null ? other.chemical != null : !this.chemical.equals(other.chemical)) {
            return false;
        }
        if (this.concentration == null ? other.concentration != null : !this.concentration.equals(other.concentration)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (Double.doubleToLongBits(this.duration) != Double.doubleToLongBits(other.duration)) {
            return false;
        }
        if (this.frequency == null ? other.frequency != null : !this.frequency.equals(other.frequency)) {
            return false;
        }
        if (this.rates == null ? other.rates != null : !this.rates.equals(other.rates)) {
            return false;
        }
        if (Double.doubleToLongBits(this.startTime) != Double.doubleToLongBits(other.startTime)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum EventType {
        NONE("No stimulus"),
        ELECTRICAL("Electrical stimulus"),
        CHEMICAL_STIMULUS("Chemical stimulus"),
        CHEMICAL_MODIFIER("Chemical modifier");

        private final String description;

        private EventType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

