/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import fmsim.model.ProtocolEvent;
import fmsim.model.ProtocolListener;
import fmsim.model.RateChangeEvent;
import fmsim.model.Rates;
import fmsim.model.VesicleModelConfiguration;
import fmsim.observations.Observations;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Protocol
implements Cloneable {
    public static final int OBSERVATION_TIME = 0;
    public static final int OBSERVATION_KEY = 1;
    public final List<ProtocolEvent> events = new ArrayList<ProtocolEvent>();
    private String experimentName = "";
    private String experimentNotes = "";
    public ProtocolEvent defaultEvent = new ProtocolEvent(0.0, 0.0, "Default rates", ProtocolEvent.EventType.NONE, null, null, null, Rates.getDefaultRates());
    public File file;
    public boolean modified = true;
    private final List<ProtocolListener> protocolListeners = new ArrayList<ProtocolListener>();
    private Observations observations;
    private VesicleModelConfiguration configuration = new VesicleModelConfiguration();
    private static final int START_TIME = 0;
    private static final int END_TIME = 1;

    public String getExperimentName() {
        return this.experimentName;
    }

    public void setExperimentName(String experimentName) {
        if (experimentName == null) {
            throw new NullPointerException();
        }
        if (!this.experimentName.equals(experimentName)) {
            this.modified = true;
        }
        this.experimentName = experimentName;
        this.fireProtocolModified();
    }

    public String getExperimentNotes() {
        return this.experimentNotes;
    }

    public void setExperimentNotes(String experimentNotes) {
        if (experimentNotes == null) {
            throw new NullPointerException();
        }
        if (!this.experimentNotes.equals(experimentNotes)) {
            this.modified = true;
        }
        this.experimentNotes = experimentNotes;
        this.fireProtocolModified();
    }

    public Rates getDefaultRates() {
        return this.defaultEvent.rates;
    }

    public void setDefaultRates(Rates rates) {
        this.defaultEvent.rates = rates;
    }

    public List<String[]> exportData() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        result.add(new String[]{"Experiment name", this.experimentName});
        result.add(new String[]{"Experiment notes", this.experimentNotes});
        String[] configurationData = this.configuration.exportData();
        String[] output = new String[configurationData.length + 1];
        System.arraycopy(configurationData, 0, output, 1, configurationData.length);
        output[0] = "Configuration";
        result.add(output);
        String[] ratesData = this.getDefaultRates().exportData();
        String[] defaultRates = new String[1 + ratesData.length];
        System.arraycopy(ratesData, 0, defaultRates, 1, ratesData.length);
        defaultRates[0] = "Default rates";
        result.add(defaultRates);
        for (ProtocolEvent event : this.events) {
            result.add(event.exportData());
        }
        return result;
    }

    public void save(File outputFile) throws IOException {
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(outputFile));
        try {
            writer.writeAll(this.exportData());
        }
        finally {
            writer.close();
        }
        this.file = outputFile;
        this.modified = false;
    }

    public static Protocol load(File inputFile) throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(inputFile));
        try {
            List importData = reader.readAll();
            Protocol protocol = Protocol.importData(importData);
            protocol.file = inputFile;
            protocol.modified = false;
            Protocol protocol2 = protocol;
            return protocol2;
        }
        finally {
            reader.close();
        }
    }

    public static Protocol importData(List<String[]> importData) {
        if (importData.size() < 3) {
            throw new IllegalArgumentException();
        }
        Protocol protocol = new Protocol();
        if (importData.get(0).length != 2 || !"Experiment name".equals(importData.get(0)[0])) {
            throw new IllegalArgumentException();
        }
        protocol.experimentName = importData.get(0)[1];
        if (importData.get(1).length != 2 || !"Experiment notes".equals(importData.get(1)[0])) {
            throw new IllegalArgumentException();
        }
        protocol.experimentNotes = importData.get(1)[1];
        if (importData.get(2).length != 7 || !"Configuration".equals(importData.get(2)[0])) {
            throw new IllegalArgumentException();
        }
        String[] configurationData = Arrays.copyOfRange(importData.get(2), 1, 7);
        protocol.configuration = VesicleModelConfiguration.importData(configurationData);
        if (importData.get(3).length != 14 || !"Default rates".equals(importData.get(3)[0])) {
            throw new IllegalArgumentException();
        }
        String[] ratesData = Arrays.copyOfRange(importData.get(3), 1, 14);
        protocol.setDefaultRates(Rates.importData(ratesData));
        int index = 4;
        while (index < importData.size()) {
            protocol.events.add(ProtocolEvent.importData(importData.get(index)));
            ++index;
        }
        return protocol;
    }

    public void addEvent(ProtocolEvent protocolEvent) {
        this.events.add(protocolEvent);
        this.sortEvents();
    }

    public void setEvents(ProtocolEvent ... protocolEvents) {
        this.events.clear();
        ProtocolEvent[] protocolEventArray = protocolEvents;
        int n = protocolEvents.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolEvent event = protocolEventArray[n2];
            this.events.add(event);
            ++n2;
        }
        this.sortEvents();
    }

    public void removeEvent(ProtocolEvent protocolEvent) {
        this.events.remove(protocolEvent);
        this.sortEvents();
    }

    public void sortEvents() {
        Collections.sort(this.events, new Comparator<ProtocolEvent>(){

            @Override
            public int compare(ProtocolEvent o1, ProtocolEvent o2) {
                return Double.compare(o1.getStartTime(), o2.getStartTime());
            }
        });
    }

    public boolean isOverlappingTime(int index) {
        ProtocolEvent chosenEvent = this.events.get(index);
        for (ProtocolEvent event : this.events) {
            if (event == chosenEvent || !Protocol.isOverlappingTime(event.getStartTime(), event.getStartTime() + event.getDuration(), chosenEvent.getStartTime(), chosenEvent.getStartTime() + chosenEvent.getDuration())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverlappingTime(double start1, double end1, double start2, double end2) {
        return start1 < start2 && end1 > start2 || start1 >= start2 && end2 > start1;
    }

    public Protocol duplicate() {
        Protocol duplicate = this.clone();
        duplicate.experimentName = String.valueOf(this.experimentName) + " copy";
        duplicate.modified = true;
        return duplicate;
    }

    public Protocol clone() {
        Protocol clone = new Protocol();
        clone.experimentName = this.experimentName;
        clone.experimentNotes = this.experimentNotes;
        clone.defaultEvent = this.defaultEvent.clone();
        clone.file = this.file;
        clone.modified = this.modified;
        clone.observations = this.observations;
        clone.configuration = this.configuration;
        for (ProtocolEvent event : this.events) {
            clone.events.add(event.clone());
        }
        return clone;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("Protocol(" + this.experimentName + "):\n");
        output.append(String.valueOf(this.experimentNotes) + "\n");
        output.append(this.events);
        return output.toString();
    }

    public List<RateChangeEvent> getRateChangeEvents() {
        HashMap<Double, List[]> timedEvents = new HashMap<Double, List[]>();
        for (ProtocolEvent event : this.events) {
            List[] currentEvents = (List[])timedEvents.get(event.getStartTime());
            if (currentEvents == null) {
                currentEvents = new List[]{new ArrayList(), new ArrayList()};
                timedEvents.put(event.getStartTime(), currentEvents);
            }
            currentEvents[0].add(event);
            double endTime = event.getStartTime() + event.getDuration();
            currentEvents = (List[])timedEvents.get(endTime);
            if (currentEvents == null) {
                currentEvents = new List[]{new ArrayList(), new ArrayList()};
                timedEvents.put(endTime, currentEvents);
            }
            currentEvents[1].add(event);
        }
        ArrayList sortedEventTimes = new ArrayList(timedEvents.keySet());
        Collections.sort(sortedEventTimes);
        ArrayList<RateChangeEvent> result = new ArrayList<RateChangeEvent>();
        ArrayList eventStack = new ArrayList();
        Iterator iterator = sortedEventTimes.iterator();
        while (iterator.hasNext()) {
            double eventTime = (Double)iterator.next();
            List[] currentEvents = (List[])timedEvents.get(eventTime);
            eventStack.removeAll(currentEvents[1]);
            eventStack.addAll(currentEvents[0]);
            ArrayList<ProtocolEvent> eventStackSnapshot = new ArrayList<ProtocolEvent>(eventStack);
            Collections.reverse(eventStackSnapshot);
            RateChangeEvent rateChangeEvent = new RateChangeEvent(eventTime, eventStackSnapshot, this.getDefaultRates());
            result.add(rateChangeEvent);
        }
        return result;
    }

    Rates getCurrentStackRates(Deque<ProtocolEvent> eventStack, Rates baseRates) {
        Rates result = baseRates;
        Iterator<ProtocolEvent> iter = eventStack.descendingIterator();
        while (iter.hasNext()) {
            ProtocolEvent event = iter.next();
            result = new Rates(event.getRates(), result);
        }
        return result;
    }

    public double getStartTime() {
        double result = 0.0;
        for (ProtocolEvent event : this.events) {
            if (!(result > event.getStartTime())) continue;
            result = event.getStartTime();
        }
        return result;
    }

    public double getEndTime() {
        double result = 0.0;
        for (ProtocolEvent event : this.events) {
            double endTime = event.getStartTime() + event.getDuration();
            if (!(result < endTime)) continue;
            result = endTime;
        }
        return result;
    }

    public void fireProtocolModified() {
        for (ProtocolListener listener : this.protocolListeners) {
            listener.protocolUpdated();
        }
    }

    public void addProtocolListener(ProtocolListener listener) {
        this.protocolListeners.add(listener);
    }

    public void removeProtocolListener(ProtocolListener listener) {
        this.protocolListeners.remove(listener);
    }

    public void setObservations(Observations observations) {
        this.observations = observations;
        this.fireProtocolModified();
    }

    public Observations getObservations() {
        return this.observations;
    }

    public VesicleModelConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VesicleModelConfiguration configuration) {
        this.configuration = configuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
        result = 31 * result + (this.defaultEvent == null ? 0 : this.defaultEvent.hashCode());
        result = 31 * result + (this.events == null ? 0 : this.events.hashCode());
        result = 31 * result + (this.experimentName == null ? 0 : this.experimentName.hashCode());
        result = 31 * result + (this.experimentNotes == null ? 0 : this.experimentNotes.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.modified ? 1231 : 1237);
        result = 31 * result + (this.observations == null ? 0 : this.observations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Protocol other = (Protocol)obj;
        if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
            return false;
        }
        if (this.defaultEvent == null ? other.defaultEvent != null : !this.defaultEvent.equals(other.defaultEvent)) {
            return false;
        }
        if (this.events == null ? other.events != null : !this.events.equals(other.events)) {
            return false;
        }
        if (this.experimentName == null ? other.experimentName != null : !this.experimentName.equals(other.experimentName)) {
            return false;
        }
        if (this.experimentNotes == null ? other.experimentNotes != null : !this.experimentNotes.equals(other.experimentNotes)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.modified != other.modified) {
            return false;
        }
        return !(this.observations == null ? other.observations != null : !this.observations.equals(other.observations));
    }

    public Set<ProtocolEvent> getAncestorEventsForRate(ProtocolEvent event, int rateIndex) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (!this.events.contains(event)) {
            throw new IllegalArgumentException("Unknown event: " + event);
        }
        if (rateIndex < 0 || rateIndex >= 10) {
            throw new IllegalArgumentException("Unknown rate index: " + rateIndex);
        }
        HashSet<ProtocolEvent> result = new HashSet<ProtocolEvent>();
        if (event.rates.values[rateIndex].type != Rates.RateValue.Type.INHERITED) {
            result.add(event);
            return result;
        }
        ArrayList<ProtocolEvent> candidates = new ArrayList<ProtocolEvent>();
        for (ProtocolEvent current : this.events) {
            if (current == event) break;
            if (current.rates.values[rateIndex].type == Rates.RateValue.Type.INHERITED || !(current.getStartTime() + current.getDuration() > event.getStartTime())) continue;
            candidates.add(current);
        }
        Collections.reverse(candidates);
        HashSet<Object> unaccountedForTimes = new HashSet<Object>();
        HashSet<double[]> accountedForTimes = new HashSet<double[]>();
        HashSet<double[]> partialTimes = new HashSet<double[]>();
        unaccountedForTimes.add(new double[]{event.startTime, event.startTime + event.duration});
        for (ProtocolEvent candidate : candidates) {
            double candidateStartTime = candidate.startTime;
            double candidateEndTime = candidate.startTime + candidate.duration;
            for (double[] dArray : unaccountedForTimes) {
                if (Protocol.isOverlappingTime(dArray[0], dArray[1], candidateStartTime, candidateEndTime)) {
                    accountedForTimes.add(dArray);
                    result.add(candidate);
                }
                if (dArray[0] < candidateStartTime) {
                    partialTimes.add(new double[]{dArray[0], candidateStartTime});
                }
                if (!(dArray[1] > candidateEndTime)) continue;
                partialTimes.add(new double[]{candidateEndTime, dArray[1]});
            }
            unaccountedForTimes.removeAll(accountedForTimes);
            unaccountedForTimes.addAll(partialTimes);
            accountedForTimes.clear();
            partialTimes.clear();
            if (unaccountedForTimes.isEmpty()) break;
        }
        if (!unaccountedForTimes.isEmpty()) {
            result.add(this.defaultEvent);
        }
        return result;
    }
}

