/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.ObservationListener;
import fmsim.model.Protocol;
import fmsim.model.RateChangeEvent;
import fmsim.model.StepSimulator;
import fmsim.model.VesicleModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class PathSimulator {
    private StepSimulator stepSimulator;
    private Protocol protocol;
    private final VesicleModel model;
    private List<RateChangeEvent> rateChangeEvents = new ArrayList<RateChangeEvent>();
    private int eventIndex = -1;
    private final List<ObservationListener> observationListeners = new ArrayList<ObservationListener>();

    public PathSimulator(Protocol protocol) {
        this.protocol = protocol;
        this.model = new VesicleModel(protocol.getConfiguration());
        this.stepSimulator = new StepSimulator(this.model);
    }

    public void runSimulation(float startTime, float endTime, float timePerStep) {
        this.model.time = startTime;
        this.model.setRates(this.protocol.getDefaultRates());
        this.reset();
        if (!this.hasNextRateChangeEvent()) {
            return;
        }
        if (this.isTimeForNextRateChangeEvent(this.model.time)) {
            this.model.setRates(this.nextRateChangeEvent().rates);
        }
        this.model.state = this.model.getInitialSampleState();
        this.notifyObservationListeners(false);
        while (true) {
            if (this.isTimeForNextRateChangeEvent(this.model.time)) {
                this.model.setRates(this.nextRateChangeEvent().rates);
                continue;
            }
            double stepEndTime = this.getNextEndTime(this.model.time, timePerStep);
            this.model.state = this.stepSimulator.runSimulation(this.model.time, stepEndTime, this.model.state);
            if (this.stepSimulator.noRulesPossible && this.hasNextRateChangeEvent()) {
                RateChangeEvent rateChangeEvent = this.nextRateChangeEvent();
                this.model.setRates(rateChangeEvent.rates);
                this.model.time = rateChangeEvent.time;
                this.stepSimulator.noRulesPossible = false;
            }
            this.notifyObservationListeners(false);
            if (this.stepSimulator.noRulesPossible || !(this.model.time < (double)endTime)) break;
        }
        this.notifyObservationListeners(true);
    }

    public void runSimulation(float endTime, float timePerStep) {
        this.runSimulation(0.0f, endTime, timePerStep);
    }

    private double getNextEndTime(double currentTime, double timePerStep) {
        int eventsSoFar = (int)FastMath.round((double)(currentTime / timePerStep));
        double result = timePerStep * (double)(eventsSoFar + 1);
        if (!this.hasNextRateChangeEvent()) {
            return result;
        }
        return Math.min(result, this.getNextRateChangeEventTime());
    }

    private void updateRateChangeEvents() {
        this.rateChangeEvents = this.protocol.getRateChangeEvents();
    }

    private void reset() {
        this.eventIndex = -1;
        this.updateRateChangeEvents();
    }

    private boolean hasNextRateChangeEvent() {
        return this.eventIndex + 1 < this.rateChangeEvents.size();
    }

    private RateChangeEvent nextRateChangeEvent() {
        return this.rateChangeEvents.get(++this.eventIndex);
    }

    private boolean isTimeForNextRateChangeEvent(double time) {
        return this.hasNextRateChangeEvent() && time >= this.rateChangeEvents.get((int)(this.eventIndex + 1)).time;
    }

    private double getNextRateChangeEventTime() {
        return this.rateChangeEvents.get((int)(this.eventIndex + 1)).time;
    }

    public void addObservationListener(ObservationListener listener) {
        this.observationListeners.add(listener);
    }

    public void removeObservationListener(ObservationListener listener) {
        this.observationListeners.remove(listener);
    }

    private void notifyObservationListeners(boolean finalEvent) {
        for (ObservationListener listener : this.observationListeners) {
            listener.observation(this.model.state, this.model.time, finalEvent);
        }
    }
}

