/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.ObservationListener;
import fmsim.model.PathSimulator;
import fmsim.model.Protocol;
import fmsim.model.VesicleModelState;
import java.util.ArrayList;
import java.util.List;

public class MultipleSimulator
implements ObservationListener {
    private static final float SIMULATION_STEP_TIME = 0.1f;
    public static final int OBS_TIME = 0;
    private final int repeatCount;
    private final Protocol protocol;
    private boolean runComplete;
    private List<float[]>[] interimObservations;
    private int currentRunIndex;
    private float[][][] interpolatedObservations;
    private int startTime;
    private int endTime;

    public MultipleSimulator(Protocol protocol, int repeatCount) {
        this.protocol = protocol;
        this.repeatCount = repeatCount;
        this.startTime = (int)protocol.getStartTime();
        this.endTime = (int)protocol.getEndTime();
    }

    public void run() {
        if (this.runComplete) {
            throw new IllegalStateException("already run");
        }
        this.interimObservations = new List[this.repeatCount];
        this.interpolatedObservations = new float[this.repeatCount][][];
        this.currentRunIndex = 0;
        while (this.currentRunIndex < this.repeatCount) {
            this.interimObservations[this.currentRunIndex] = new ArrayList<float[]>();
            PathSimulator simulator = new PathSimulator(this.protocol);
            simulator.addObservationListener(this);
            simulator.runSimulation(this.startTime, this.endTime, 0.1f);
            simulator.removeObservationListener(this);
            ++this.currentRunIndex;
        }
        this.runComplete = true;
    }

    public float[][][] getObservations() {
        if (!this.runComplete) {
            throw new IllegalStateException("call run() first");
        }
        return this.interpolatedObservations;
    }

    public static String[] getObservableNames() {
        return new String[]{"ADBE Vesicles", "CME Vesicles", "Endosomes", "RP Vesicles", "RRP Vesicles", "PM Vesicles", "Pre Endosomes", "RP Pre Vesicles", "RRP Pre Vesicles", "PM Pre Vesicles"};
    }

    @Override
    public void observation(VesicleModelState state, double time, boolean finalEvent) {
        float[] observation = new float[]{(float)time, (float)state.getFluorescence(this.protocol.getConfiguration().fluorescenceType), state.getADBEVesicleCount(), state.getCMEVesicleCount(), state.endosomeVesicles.size(), state.rpVesicles.size(), state.rrpVesicles.size(), state.plasmaMembraneVesicles.size(), state.endosomePreVesicles.size(), state.rpPreVesicles.size(), state.rrpPreVesicles.size(), state.plasmaMembranePreVesicles.size()};
        this.interimObservations[this.currentRunIndex].add(observation);
        if (finalEvent) {
            this.interpolatedObservations[this.currentRunIndex] = MultipleSimulator.interpolateObservations(this.interimObservations[this.currentRunIndex], this.endTime - this.startTime, 0.1f);
        }
    }

    static float[][] interpolateObservations(List<float[]> observations, float totalTime, float stepTime) {
        int steps = (int)(totalTime / stepTime) + 1;
        float firstObservationTime = observations.get(0)[0];
        int observableCount = observations.get(0).length - 1;
        float[][] result = new float[steps][];
        int firstStep = 0;
        while ((float)firstStep * stepTime < firstObservationTime && firstStep < steps) {
            result[firstStep] = new float[observableCount + 1];
            result[firstStep][0] = (float)firstStep * stepTime;
            ++firstStep;
        }
        if (firstStep >= steps) {
            return result;
        }
        int observationIndex = 0;
        int step = firstStep;
        while (step < steps) {
            float currentStepTime = (float)step * stepTime;
            if (observationIndex + 1 < observations.size()) {
                float nextObservationTime = observations.get(observationIndex + 1)[0];
                while (nextObservationTime <= currentStepTime) {
                    if (++observationIndex + 1 >= observations.size()) break;
                    nextObservationTime = observations.get(observationIndex + 1)[0];
                }
            }
            float[] currentObservation = observations.get(observationIndex);
            result[step] = new float[currentObservation.length];
            System.arraycopy(currentObservation, 0, result[step], 0, currentObservation.length);
            result[step][0] = currentStepTime;
            ++step;
        }
        return result;
    }
}

