/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import au.com.bytecode.opencsv.CSVWriter;
import fmsim.model.Calculations;
import fmsim.model.MultipleSimulator;
import fmsim.observations.Observations;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.math3.util.FastMath;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public class ChartDataModel {
    private static final int OBSERVABLE_INDEX_OFFSET = 2;
    public float[][][] simulatedData;
    public double[][] simulatedDataMean;
    public double[][] simulatedDataStdev;
    public double[][] simulatedDataSem;
    private Observations observations;
    public double distance;
    private XYIntervalSeriesCollection modelViewChartData = new XYIntervalSeriesCollection();
    private XYIntervalSeriesCollection comparisonChartData = new XYIntervalSeriesCollection();
    private VarianceType varianceType = VarianceType.STDDEV;
    private double[][] simulatedFluorescence;
    private boolean[] modelViewObservablesVisible;

    public void loadObservations(File inputFile) throws IOException {
        this.observations = null;
        if (inputFile != null) {
            this.setObservations(new Observations(inputFile));
        }
    }

    public XYIntervalSeriesCollection getComparisonChartData() {
        return this.comparisonChartData;
    }

    public XYIntervalSeriesCollection getModelViewChartData() {
        return this.modelViewChartData;
    }

    private double getDistance() {
        if (this.observations == null || this.simulatedFluorescence == null) {
            return 0.0;
        }
        int simIndex = 0;
        double result = 0.0;
        int obsIndex = 0;
        while (obsIndex < this.observations.frameCount) {
            double time = this.observations.times[obsIndex];
            while (simIndex < this.simulatedFluorescence.length - 1 && this.simulatedFluorescence[simIndex + 1][0] < time) {
                ++simIndex;
            }
            double observationStdDev = this.observations.scaledStandardDeviations[obsIndex];
            if (observationStdDev == 0.0) {
                observationStdDev = 0.1;
            }
            if (simIndex < this.simulatedFluorescence.length) {
                result += FastMath.log((double)Calculations.calculateWeight(this.observations.scaledMeans[obsIndex], observationStdDev, this.simulatedFluorescence[simIndex][1]));
            }
            ++obsIndex;
        }
        return result;
    }

    private double[][] getSimulatedFluorescence() {
        if (this.simulatedData == null || this.simulatedData.length == 0) {
            return null;
        }
        double[][] result = new double[this.simulatedData[0].length][];
        double overallMaxFluorescence = Double.MIN_VALUE;
        double overallMinFluorescence = Double.MAX_VALUE;
        int frameIndex = 0;
        while (frameIndex < result.length) {
            double time = this.simulatedData[0][frameIndex][0];
            double meanFluorescence = 0.0;
            double stdevFluorescence = 0.0;
            double semFluorescence = 0.0;
            int simulationRunIndex = 0;
            while (simulationRunIndex < this.simulatedData.length) {
                double fluorescence = this.simulatedData[simulationRunIndex][frameIndex][1];
                meanFluorescence += fluorescence;
                if (fluorescence > overallMaxFluorescence) {
                    overallMaxFluorescence = fluorescence;
                }
                if (fluorescence < overallMinFluorescence) {
                    overallMinFluorescence = fluorescence;
                }
                ++simulationRunIndex;
            }
            meanFluorescence /= (double)this.simulatedData.length;
            double varianceSum = 0.0;
            int simulationRunIndex2 = 0;
            while (simulationRunIndex2 < this.simulatedData.length) {
                varianceSum += FastMath.pow((double)((double)this.simulatedData[simulationRunIndex2][frameIndex][1] - meanFluorescence), (int)2);
                ++simulationRunIndex2;
            }
            stdevFluorescence = FastMath.sqrt((double)(varianceSum / (double)(this.simulatedData.length - 1)));
            semFluorescence = stdevFluorescence / FastMath.sqrt((double)this.simulatedData.length);
            result[frameIndex] = new double[]{time, meanFluorescence, stdevFluorescence, semFluorescence};
            ++frameIndex;
        }
        double scale = overallMaxFluorescence - overallMinFluorescence;
        if (scale > 0.0) {
            double[][] dArrayArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                double[] entry = dArrayArray[n2];
                entry[1] = (entry[1] - overallMinFluorescence) / scale;
                entry[2] = entry[2] / (scale * scale);
                entry[3] = entry[3] / (scale * scale);
                ++n2;
            }
        }
        return result;
    }

    public void setSimulatedData(float[][][] simulatedData) {
        this.simulatedData = simulatedData;
        this.updateSimulatedMeans();
        this.updateChartData();
    }

    private void updateSimulatedMeans() {
        if (this.simulatedData == null || this.simulatedData.length == 0 || this.simulatedData[0].length == 0) {
            this.simulatedDataMean = null;
            this.simulatedDataStdev = null;
            this.simulatedDataSem = null;
            return;
        }
        int frameCount = this.simulatedData[0].length;
        int observablesCount = this.simulatedData[0][0].length;
        this.simulatedDataMean = new double[frameCount][];
        this.simulatedDataStdev = new double[frameCount][];
        this.simulatedDataSem = new double[frameCount][];
        int frameIndex = 0;
        while (frameIndex < frameCount) {
            float time = this.simulatedData[0][frameIndex][0];
            double[] observablesMean = new double[observablesCount];
            observablesMean[0] = time;
            int simulationRunIndex = 0;
            while (simulationRunIndex < this.simulatedData.length) {
                int observableIndex = 1;
                while (observableIndex < observablesCount) {
                    int n = observableIndex;
                    observablesMean[n] = observablesMean[n] + (double)this.simulatedData[simulationRunIndex][frameIndex][observableIndex];
                    ++observableIndex;
                }
                ++simulationRunIndex;
            }
            int observableIndex = 1;
            while (observableIndex < observablesCount) {
                int n = observableIndex++;
                observablesMean[n] = observablesMean[n] / (double)this.simulatedData.length;
            }
            double[] observablesVarianceSum = new double[observablesCount];
            int simulationRunIndex2 = 0;
            while (simulationRunIndex2 < this.simulatedData.length) {
                int observableIndex2 = 1;
                while (observableIndex2 < observablesCount) {
                    int n = observableIndex2;
                    observablesVarianceSum[n] = observablesVarianceSum[n] + FastMath.pow((double)((double)this.simulatedData[simulationRunIndex2][frameIndex][observableIndex2] - observablesMean[observableIndex2]), (int)2);
                    ++observableIndex2;
                }
                ++simulationRunIndex2;
            }
            double[] observablesStdev = new double[observablesCount];
            double[] observablesSem = new double[observablesCount];
            observablesStdev[0] = time;
            observablesSem[0] = time;
            int observableIndex3 = 1;
            while (observableIndex3 < observablesCount) {
                observablesStdev[observableIndex3] = FastMath.sqrt((double)(observablesVarianceSum[observableIndex3] / (double)(this.simulatedData.length - 1)));
                observablesSem[observableIndex3] = observablesStdev[observableIndex3] / FastMath.sqrt((double)this.simulatedData.length);
                ++observableIndex3;
            }
            this.simulatedDataMean[frameIndex] = observablesMean;
            this.simulatedDataStdev[frameIndex] = observablesStdev;
            this.simulatedDataSem[frameIndex] = observablesSem;
            ++frameIndex;
        }
    }

    public void setChartVarianceType(VarianceType varianceType) {
        this.varianceType = varianceType;
        this.updateChartData();
    }

    private void updateChartData() {
        this.updateComparison();
        this.updateModelView();
        this.distance = this.getDistance();
    }

    private void updateComparison() {
        double error;
        int frameIndex;
        this.comparisonChartData = new XYIntervalSeriesCollection();
        this.simulatedFluorescence = this.getSimulatedFluorescence();
        ArrayList<String[]> exportData = new ArrayList<String[]>();
        if (this.observations != null && this.observations.roiCount > 0) {
            double[] errors = this.varianceType == VarianceType.STDDEV ? this.observations.scaledStandardDeviations : this.observations.scaledStandardErrors;
            XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)"Observed"));
            exportData.add(new String[]{"Observed"});
            frameIndex = 0;
            while (frameIndex < this.observations.frameCount) {
                double mean = this.observations.scaledMeans[frameIndex];
                double time = this.observations.times[frameIndex];
                error = errors[frameIndex];
                series.add(time, time, time, mean, mean - error, mean + error);
                exportData.add(new String[]{"" + time, "" + mean, "" + error});
                ++frameIndex;
            }
            this.comparisonChartData.addSeries(series);
        }
        if (this.simulatedFluorescence != null && this.simulatedFluorescence.length > 0) {
            XYIntervalSeries simulatedSeries = new XYIntervalSeries((Comparable)((Object)"Simulated"));
            int errorIndex = this.varianceType == VarianceType.STDDEV ? 2 : 3;
            frameIndex = 0;
            while (frameIndex < this.simulatedFluorescence.length) {
                double time = this.simulatedFluorescence[frameIndex][0];
                double mean = this.simulatedFluorescence[frameIndex][1];
                error = this.simulatedFluorescence[frameIndex][errorIndex];
                simulatedSeries.add(time, time, time, mean, mean - error, mean + error);
                exportData.add(new String[]{"" + time, "" + mean, "" + error});
                ++frameIndex;
            }
            this.comparisonChartData.addSeries(simulatedSeries);
        }
        try {
            CSVWriter writer = new CSVWriter((Writer)new FileWriter("rawdata.csv"));
            try {
                writer.writeAll(exportData);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateModelView() {
        this.modelViewChartData = new XYIntervalSeriesCollection();
        if (this.modelViewObservablesVisible == null || this.simulatedDataMean == null) {
            return;
        }
        double[][] errors = this.varianceType == VarianceType.STDDEV ? this.simulatedDataStdev : this.simulatedDataSem;
        String[] observableNames = MultipleSimulator.getObservableNames();
        int visibleIndex = 0;
        while (visibleIndex < this.modelViewObservablesVisible.length) {
            if (this.modelViewObservablesVisible[visibleIndex]) {
                int observableIndex = visibleIndex + 2;
                XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)observableNames[visibleIndex]));
                int frameIndex = 0;
                while (frameIndex < this.simulatedDataMean.length) {
                    double mean = this.simulatedDataMean[frameIndex][observableIndex];
                    double time = this.simulatedDataMean[frameIndex][0];
                    double error = errors[frameIndex][observableIndex];
                    series.add(time, time, time, mean, mean - error, mean + error);
                    ++frameIndex;
                }
                this.modelViewChartData.addSeries(series);
            }
            ++visibleIndex;
        }
    }

    public void setObservations(Observations observations) {
        this.observations = observations;
        this.updateChartData();
    }

    public Observations getObservations() {
        return this.observations;
    }

    public void setModelViewObservablesVisible(boolean[] observablesVisible) {
        this.modelViewObservablesVisible = observablesVisible;
        this.updateModelView();
    }

    public void clear() {
        this.observations = null;
        this.simulatedData = null;
        this.simulatedDataMean = null;
        this.simulatedDataStdev = null;
        this.simulatedDataSem = null;
        this.updateChartData();
    }

    public static enum VarianceType {
        STDDEV,
        SEM;

    }
}

