/*
 * Decompiled with CFR 0.152.
 */
package fmsim.model;

import fmsim.model.Rates;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.util.FastMath;

public class Calculations {
    public static final double calculateWeight(double observationMean, double observationStdDev, double simulatedValue) {
        double x0 = simulatedValue - observationMean;
        double x1 = x0 / observationStdDev;
        return FastMath.exp((double)(-0.5 * x1 * x1));
    }

    public static final Rates.RateValue getProposalParameter(Rates.RateValue rateValue) {
        if (rateValue.type != Rates.RateValue.Type.INFERRED) {
            return rateValue;
        }
        NormalDistribution dist = new NormalDistribution(rateValue.value, 1.0);
        double val = dist.inverseCumulativeProbability(FastMath.random());
        return new Rates.RateValue(Rates.RateValue.Type.INFERRED, Math.max(0.0, val));
    }
}

