/*
 * Decompiled with CFR 0.152.
 */
package fmsim.inference;

import fmsim.model.Rates;
import fmsim.model.StepSimulator;
import fmsim.model.VesicleModel;
import fmsim.model.VesicleModelConfiguration;
import fmsim.model.VesicleModelState;
import fmsim.observations.Observations;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;

public class SMCScheme {
    public double marginalLikelihood;
    public VesicleModelState[] sampleStates;
    public VesicleModelState[][] sampleStatesHistory;
    private static final ExecutorService service = Executors.newFixedThreadPool(4);
    final Observations observations;
    final int particleCount;
    final double startTime;
    final double endTime;
    final VesicleModelConfiguration configuration;
    int startIndex = -1;
    int endIndex = -1;
    final boolean runInSegment;
    final boolean runOutSegment;

    public SMCScheme(Observations observations, int particleCount, double startTime, double endTime, VesicleModelConfiguration configuration) {
        this.observations = observations;
        this.particleCount = particleCount;
        this.startTime = startTime;
        this.endTime = endTime;
        this.configuration = configuration;
        if (observations.frameCount == 0) {
            this.runInSegment = false;
            this.runOutSegment = false;
        } else {
            this.startIndex = 0;
            while (this.startIndex < observations.frameCount - 1 && observations.times[this.startIndex] < startTime) {
                ++this.startIndex;
            }
            this.runInSegment = startTime != observations.times[this.startIndex];
            this.endIndex = observations.frameCount - 1;
            while (this.endIndex > this.startIndex && observations.times[this.endIndex] > endTime) {
                --this.endIndex;
            }
            this.runOutSegment = endTime != observations.times[this.endIndex];
        }
    }

    public void run(Rates parameters, VesicleModelState[] initialStates) {
        double[] weights;
        double meanWeight;
        if (initialStates.length != this.particleCount) {
            throw new IllegalArgumentException("Invalid number of initial states");
        }
        if (this.observations.frameCount == 0) {
            this.runNoObservations(parameters, initialStates);
            return;
        }
        int totalHistoryFrames = this.observations.frameCount + (this.runInSegment ? 1 : 0) + (this.runOutSegment ? 1 : 0);
        int indexHistoryFrame = 0;
        this.marginalLikelihood = 0.0;
        this.sampleStates = initialStates;
        this.sampleStatesHistory = new VesicleModelState[totalHistoryFrames][];
        if (this.runInSegment) {
            this.sampleStatesHistory[indexHistoryFrame++] = this.sampleStates;
            this.sampleStates = this.simulateForward(this.startTime, this.observations.times[this.startIndex], this.sampleStates, parameters);
        }
        this.marginalLikelihood += (meanWeight = this.getMeanWeight(weights = this.calculateWeights(this.sampleStates, parameters, this.startIndex))) == 0.0 ? -100.0 : FastMath.log((double)meanWeight);
        this.sampleStates = this.resampleStates(this.sampleStates, weights);
        this.sampleStatesHistory[indexHistoryFrame++] = this.sampleStates;
        int timeIndex = this.startIndex;
        while (timeIndex < this.endIndex) {
            double stepStartTime = this.observations.times[timeIndex];
            double stepEndTime = this.observations.times[timeIndex + 1];
            this.sampleStates = this.simulateForward(stepStartTime, stepEndTime, this.sampleStates, parameters);
            weights = this.calculateWeights(this.sampleStates, parameters, timeIndex + 1);
            meanWeight = this.getMeanWeight(weights);
            this.marginalLikelihood += meanWeight == 0.0 ? -100.0 : FastMath.log((double)meanWeight);
            this.sampleStates = this.resampleStates(this.sampleStates, weights);
            this.sampleStatesHistory[indexHistoryFrame++] = this.sampleStates;
            ++timeIndex;
        }
        if (this.runOutSegment) {
            this.sampleStates = this.simulateForward(this.observations.times[this.endIndex], this.endTime, this.sampleStates, parameters);
            this.sampleStatesHistory[indexHistoryFrame++] = this.sampleStates;
        }
    }

    private void runNoObservations(Rates parameters, VesicleModelState[] initialStates) {
        this.sampleStates = initialStates;
        this.sampleStatesHistory = new VesicleModelState[2][];
        this.marginalLikelihood = 0.0;
        this.sampleStatesHistory[0] = this.sampleStates;
        this.sampleStates = this.simulateForward(this.startTime, this.endTime, this.sampleStates, parameters);
        this.sampleStatesHistory[1] = this.sampleStates;
    }

    private double getMeanWeight(double[] weights) {
        double result = 0.0;
        double[] dArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            double current = dArray[n2];
            if (current < 0.0 || current > 1.0) {
                throw new RuntimeException("Weight invalid: " + current);
            }
            result += current;
            ++n2;
        }
        return result / (double)weights.length;
    }

    private double[] calculateWeights(VesicleModelState[] states, Rates parameters, int timeIndex) {
        double[] result = new double[states.length];
        double observationMean = this.observations.scaledMeans[timeIndex];
        double observationStdDev = this.observations.scaledStandardDeviations[timeIndex];
        if (observationStdDev == 0.0) {
            observationStdDev = 0.1;
        }
        int i = 0;
        while (i < states.length) {
            result[i] = states[i].calculateWeight(observationMean, observationStdDev, parameters, this.configuration.fluorescenceType);
            ++i;
        }
        return result;
    }

    private VesicleModelState[] resampleStates(VesicleModelState[] states, double[] weights) {
        double totalWeight = 0.0;
        double[] dArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            double current = dArray[n2];
            totalWeight += current;
            ++n2;
        }
        VesicleModelState[] result = new VesicleModelState[states.length];
        int i = 0;
        while (i < states.length) {
            double point = FastMath.random() * totalWeight;
            result[i] = this.resampleState(states, weights, point);
            ++i;
        }
        return result;
    }

    private VesicleModelState resampleState(VesicleModelState[] states, double[] weights, double point) {
        double current = 0.0;
        int i = 0;
        while (i < weights.length) {
            if (point <= (current += weights[i])) {
                return states[i];
            }
            ++i;
        }
        return states[states.length - 1];
    }

    VesicleModelState[] simulateForward(double stepStartTime, double stepEndTime, VesicleModelState[] initialStates, Rates parameters) {
        ArrayList<Future<VesicleModelState>> futuresList = new ArrayList<Future<VesicleModelState>>();
        VesicleModelState[] vesicleModelStateArray = initialStates;
        int n = initialStates.length;
        int n2 = 0;
        while (n2 < n) {
            VesicleModelState state = vesicleModelStateArray[n2];
            futuresList.add(service.submit(new SimThread(parameters, stepStartTime, stepEndTime, state, this.configuration)));
            ++n2;
        }
        VesicleModelState[] result = new VesicleModelState[initialStates.length];
        int i = 0;
        while (i < result.length) {
            try {
                result[i] = (VesicleModelState)((Future)futuresList.get(i)).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    static class SimThread
    implements Callable<VesicleModelState> {
        private final VesicleModelState initialState;
        private final double startTime;
        private final double endTime;
        private final StepSimulator simulator;

        public SimThread(Rates parameters, double startTime, double endTime, VesicleModelState initialState, VesicleModelConfiguration configuration) {
            this.initialState = initialState;
            this.startTime = startTime;
            this.endTime = endTime;
            VesicleModel model = new VesicleModel(configuration);
            model.setRates(parameters);
            this.simulator = new StepSimulator(model);
        }

        @Override
        public VesicleModelState call() throws Exception {
            return this.simulator.runSimulation(this.startTime, this.endTime, this.initialState);
        }
    }
}

