/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.FMSim;
import fmsim.model.ChartDataModel;
import fmsim.model.MultipleSimulator;
import fmsim.model.Protocol;
import fmsim.model.ProtocolListener;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public class SimulatorPanel
extends JPanel
implements ProtocolListener {
    private static final long serialVersionUID = 1L;
    private final NumberFormat distanceFormat = new DecimalFormat("0.00");
    private static final double F = -1.0;
    private static final double P = -2.0;
    private static final Font CONTROL_TITLE_FONT = new Font("SansSerif", 1, 18);
    private ChartPanel simulationChartPanel;
    private ChartPanel comparisonChartPanel;
    private ChartDataModel chartDataModel = new ChartDataModel();
    private SpinnerNumberModel repeatCountText;
    private JCheckBox[] observableChecks;
    private JButton runButton;
    private JLabel distanceText;
    private Protocol protocol = new Protocol();

    public SimulatorPanel() {
        this.setLayout(new BorderLayout());
        this.setName("Simulation");
        this.add((Component)this.getChartsPanel(), "Center");
        this.add((Component)this.getControlPanel(), "West");
        this.actionChartItemsChanged();
    }

    private JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        controlPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -1.0, 10.0}, {10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}}));
        controlPanel.add((Component)this.getActionPanel(), "1,1");
        controlPanel.add(this.getObservablePanel(), "1,3");
        controlPanel.add((Component)this.getDistancePanel(), "1,5");
        return controlPanel;
    }

    private JPanel getDistancePanel() {
        JPanel distancePanel = this.getControlSubPanel("Distance");
        distancePanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0}}));
        this.distanceText = new JLabel("Unknown");
        JLabel distanceLabel = new JLabel("Distance from observations");
        distancePanel.add((Component)distanceLabel, "2,1");
        distancePanel.add((Component)this.distanceText, "4,1");
        return distancePanel;
    }

    private Component getObservablePanel() {
        JPanel observablePanel = this.getControlSubPanel("Chart items");
        observablePanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -2.0, -1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0}}));
        String[] observableNames = MultipleSimulator.getObservableNames();
        this.observableChecks = new JCheckBox[observableNames.length];
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SimulatorPanel.this.actionChartItemsChanged();
            }
        };
        int i = 0;
        while (i < observableNames.length) {
            this.observableChecks[i] = new JCheckBox(observableNames[i], true);
            this.observableChecks[i].setBackground(FMSim.COLOUR_CONTROL_BG);
            this.observableChecks[i].addActionListener(listener);
            observablePanel.add((Component)this.observableChecks[i], "1," + i * 2);
            ++i;
        }
        return observablePanel;
    }

    private JPanel getControlSubPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBackground(FMSim.COLOUR_CONTROL_BG);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        border.setTitleFont(CONTROL_TITLE_FONT);
        border.setTitleJustification(2);
        panel.setBorder(border);
        return panel;
    }

    protected void actionChartItemsChanged() {
        this.chartDataModel.setModelViewObservablesVisible(this.getObservablesVisible());
        this.redrawCharts();
    }

    private void redrawCharts() {
        this.simulationChartPanel.setChart(this.createModelViewChart());
        this.comparisonChartPanel.setChart(this.createComparisonChart());
        this.distanceText.setText(this.distanceFormat.format(this.chartDataModel.distance));
    }

    private JComponent getActionPanel() {
        JPanel actionPanel = this.getControlSubPanel("Run Simulation");
        actionPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 30.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0}}));
        this.repeatCountText = new SpinnerNumberModel(10, 1, 100000, 1);
        JSpinner repeatCountSpinner = new JSpinner(this.repeatCountText);
        JLabel repeatCountLabel = new JLabel("Repeat Count");
        repeatCountLabel.setLabelFor(repeatCountSpinner);
        actionPanel.add((Component)repeatCountLabel, "2,5");
        actionPanel.add((Component)repeatCountSpinner, "4,5");
        this.runButton = new JButton("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimulatorPanel.this.actionRun();
            }
        });
        actionPanel.add((Component)this.runButton, "6,5");
        return actionPanel;
    }

    private JPanel getChartsPanel() {
        JPanel chartsPanel = new JPanel();
        chartsPanel.setLayout(new BoxLayout(chartsPanel, 1));
        this.simulationChartPanel = new ChartPanel(ChartFactory.createXYLineChart(null, (String)"Time", (String)"Quantity", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false));
        this.comparisonChartPanel = new ChartPanel(ChartFactory.createXYLineChart(null, (String)"Time", (String)"Normalised fluorescence", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false));
        chartsPanel.setBorder(BorderFactory.createEtchedBorder());
        chartsPanel.add((Component)this.simulationChartPanel);
        chartsPanel.add((Component)this.comparisonChartPanel);
        return chartsPanel;
    }

    private Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (this.protocol != null) {
            this.protocol.removeProtocolListener(this);
        }
        this.protocol = protocol;
        if (this.protocol != null) {
            this.protocol.addProtocolListener(this);
        }
        this.chartDataModel.clear();
        this.chartDataModel.setObservations(protocol != null ? protocol.getObservations() : null);
        this.runButton.setEnabled(protocol != null);
        this.redrawCharts();
    }

    protected void actionRun() {
        int repeatCount = this.repeatCountText.getNumber().intValue();
        MultipleSimulator simulator = new MultipleSimulator(this.getProtocol(), repeatCount);
        simulator.run();
        this.chartDataModel.setSimulatedData(simulator.getObservations());
        this.redrawCharts();
    }

    private boolean[] getObservablesVisible() {
        boolean[] result = new boolean[this.observableChecks.length];
        int i = 0;
        while (i < this.observableChecks.length) {
            result[i] = this.observableChecks[i].isSelected();
            ++i;
        }
        return result;
    }

    private JFreeChart createModelViewChart() {
        XYIntervalSeriesCollection chartData = this.chartDataModel.getModelViewChartData();
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Time", (String)"Quantity", (XYDataset)chartData, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        renderer.setSeriesFillPaint(1, (Paint)Color.GREEN);
        renderer.setSeriesFillPaint(2, (Paint)Color.BLUE);
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.GREEN);
        renderer.setSeriesPaint(2, (Paint)Color.BLUE);
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    private JFreeChart createComparisonChart() {
        XYIntervalSeriesCollection chartData = this.chartDataModel.getComparisonChartData();
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Time", (String)"Fluorescence", (XYDataset)chartData, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        renderer.setSeriesFillPaint(1, (Paint)Color.GREEN);
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.GREEN);
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    @Override
    public void protocolUpdated() {
        this.runButton.setEnabled(this.protocol != null);
        this.chartDataModel.setObservations(this.protocol.getObservations());
        this.redrawCharts();
    }
}

