/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.model.Protocol;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ProtocolsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final int COLINDEX_EXP_NAME = 0;
    private static final int COLINDEX_FILENAME = 1;
    private static final String[] COLUMN_NAMES = new String[]{"Experiment name", "File"};
    static final Color COLOUR_SAVED_BG = new Color(0xCCFFDD);
    static final Color COLOUR_UNSAVED_BG = new Color(0xFFCCDD);
    static final Color COLOUR_SELECTED_BG = new Color(0xDDDDFF);
    private final List<Protocol> protocols;

    public ProtocolsTableModel(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.protocols.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.protocols.get(row).getExperimentName();
            }
            case 1: {
                return this.protocols.get(row);
            }
        }
        return null;
    }

    public void setTableProperties(JTable protocolsTable) {
        int index = 0;
        while (index < COLUMN_NAMES.length) {
            protocolsTable.getColumnModel().getColumn(index).setHeaderValue(COLUMN_NAMES[index]);
            ++index;
        }
        TableCellRenderer fileRenderer = new TableCellRenderer(){
            private JLabel label = new JLabel();
            {
                this.label.setOpaque(true);
                this.label.setFont(new Font("SansSerif", 0, 12));
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    this.label.setBackground(COLOUR_SELECTED_BG);
                } else {
                    this.label.setBackground(((Protocol)value).modified ? COLOUR_UNSAVED_BG : COLOUR_SAVED_BG);
                }
                if (((Protocol)value).file == null) {
                    this.label.setText("");
                } else {
                    this.label.setText(((Protocol)value).file.getName());
                }
                return this.label;
            }
        };
        protocolsTable.getColumnModel().getColumn(1).setCellRenderer(fileRenderer);
    }
}

