/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.model.Protocol;
import fmsim.model.ProtocolEvent;
import fmsim.model.ProtocolListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;

public class ProtocolSchematicPanel
extends JPanel
implements ProtocolListener {
    private static final long serialVersionUID = 1L;
    private static final int HEIGHT_OFFSET = 30;
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 18);
    private static final Font BOLD_FONT = new Font("SansSerif", 1, 14);
    private static final Font PLAIN_FONT = new Font("SansSerif", 0, 14);
    private static final Font ITALIC_FONT = new Font("SansSerif", 2, 14);
    private static final Font BOLD_ITALIC_FONT = new Font("SansSerif", 3, 14);
    private Protocol protocol;
    private final List<List<ProtocolEvent>> modifierLines = new ArrayList<List<ProtocolEvent>>();

    public ProtocolSchematicPanel(Protocol protocol) {
        this();
        this.setProtocol(protocol);
    }

    public ProtocolSchematicPanel() {
        Dimension minimumSize = new Dimension(100, 120);
        this.setMinimumSize(minimumSize);
        this.setPreferredSize(minimumSize);
        this.setSize(minimumSize);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.protocol != null) {
            ProtocolEvent.EventType eventType;
            g2.setColor(Color.BLACK);
            g2.setFont(TITLE_FONT);
            g2.drawString(this.protocol.getExperimentName(), 10, 30);
            int x = 10;
            HashMap<ProtocolEvent, Integer> startXMap = new HashMap<ProtocolEvent, Integer>();
            HashMap<ProtocolEvent, Integer> endXMap = new HashMap<ProtocolEvent, Integer>();
            for (ProtocolEvent event : this.protocol.events) {
                eventType = event.getType();
                if (eventType != ProtocolEvent.EventType.CHEMICAL_MODIFIER) {
                    startXMap.put(event, x);
                }
                switch (eventType) {
                    case NONE: {
                        if (event.getDescription().length() > 0) {
                            x = this.drawArrow(g2, event.getDescription(), "(" + event.getDuration() + " s)", x) + 10;
                        }
                        endXMap.put(event, x);
                        break;
                    }
                    case ELECTRICAL: {
                        x = this.drawBox(g2, event.getDescription(), "", String.valueOf(event.getFrequency()) + " " + event.getDuration() + "s", x) + 10;
                        break;
                    }
                    case CHEMICAL_STIMULUS: {
                        x = this.drawBox(g2, event.getDescription(), event.getChemical(), String.valueOf(event.getDuration()) + "s", x) + 10;
                        break;
                    }
                    case CHEMICAL_MODIFIER: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown stimulus");
                    }
                }
                if (eventType == ProtocolEvent.EventType.CHEMICAL_MODIFIER) continue;
                endXMap.put(event, x - 10);
            }
            for (ProtocolEvent event : this.protocol.events) {
                int otherLength;
                int otherEndX;
                int otherStartX;
                double otherEndTime;
                double otherStartTime;
                eventType = event.getType();
                if (eventType != ProtocolEvent.EventType.CHEMICAL_MODIFIER) continue;
                double startTime = event.getStartTime();
                double endTime = event.getStartTime() + event.getDuration();
                int modifierStartX = 0;
                int modifierEndX = 100;
                for (ProtocolEvent otherEvent : startXMap.keySet()) {
                    otherStartTime = otherEvent.getStartTime();
                    otherEndTime = otherStartTime + otherEvent.getDuration();
                    if (!(startTime >= otherStartTime) || !(startTime <= otherEndTime)) continue;
                    otherStartX = (Integer)startXMap.get(otherEvent);
                    otherEndX = (Integer)endXMap.get(otherEvent);
                    otherLength = otherEndX - otherStartX;
                    modifierStartX = (int)((double)otherStartX + (startTime - otherStartTime) * (double)otherLength / otherEvent.getDuration());
                    break;
                }
                for (ProtocolEvent otherEvent : endXMap.keySet()) {
                    otherStartTime = otherEvent.getStartTime();
                    otherEndTime = otherStartTime + otherEvent.getDuration();
                    if (!(endTime >= otherStartTime) || !(endTime <= otherEndTime)) continue;
                    otherStartX = (Integer)startXMap.get(otherEvent);
                    otherEndX = (Integer)endXMap.get(otherEvent);
                    otherLength = otherEndX - otherStartX;
                    modifierEndX = (int)((double)otherEndX - (otherEndTime - endTime) * (double)otherLength / otherEvent.getDuration());
                    break;
                }
                int modifierLine = 0;
                for (List<ProtocolEvent> lineEvents : this.modifierLines) {
                    if (lineEvents.contains(event)) break;
                    ++modifierLine;
                }
                this.drawModifierBox(g2, String.valueOf(event.getDescription()) + " " + event.getChemical() + " " + event.getDuration() + "s", modifierStartX, modifierEndX, modifierLine);
            }
        }
    }

    private int drawArrow(Graphics2D g2, String boldText, String plainText, int x) {
        g2.setColor(Color.BLACK);
        g2.fillRect(x, 68, 150, 5);
        g2.fillPolygon(new int[]{x + 150, x + 162, x + 150}, new int[]{64, 70, 76}, 3);
        g2.setFont(BOLD_ITALIC_FONT);
        FontMetrics fontMetrics = g2.getFontMetrics();
        int boldWidth = fontMetrics.stringWidth(String.valueOf(boldText) + " ");
        g2.setFont(ITALIC_FONT);
        fontMetrics = g2.getFontMetrics();
        int plainWidth = fontMetrics.stringWidth(plainText);
        int lineWidth = boldWidth + plainWidth;
        g2.setFont(BOLD_ITALIC_FONT);
        g2.drawString(String.valueOf(boldText) + " ", x + (162 - lineWidth) / 2, 66);
        g2.setFont(ITALIC_FONT);
        g2.drawString(plainText, x + (162 - lineWidth) / 2 + boldWidth, 66);
        return x + 162;
    }

    private int drawBox(Graphics2D g2, String line1, String line2, String line3, int x) {
        g2.setFont(BOLD_FONT);
        FontMetrics fontMetrics = g2.getFontMetrics();
        int line1Width = fontMetrics.stringWidth(line1);
        int line1Height = fontMetrics.getHeight();
        g2.setFont(PLAIN_FONT);
        fontMetrics = g2.getFontMetrics();
        int line2Width = fontMetrics.stringWidth(line2);
        g2.setFont(ITALIC_FONT);
        fontMetrics = g2.getFontMetrics();
        int line3Width = fontMetrics.stringWidth(line3);
        int line2Height = fontMetrics.getHeight();
        int maxLineWidth = Math.max(Math.max(line1Width, line2Width), line3Width);
        Rectangle boxSize = new Rectangle(x, 40, maxLineWidth + 40, 60);
        g2.setColor(Color.BLACK);
        g2.fillRect(boxSize.x, boxSize.y, boxSize.width, 20);
        g2.setColor(Color.GRAY);
        g2.fillRect(boxSize.x, 60, boxSize.width, 20);
        g2.setColor(Color.BLACK);
        g2.drawRect(boxSize.x, boxSize.y, boxSize.width, boxSize.height);
        g2.setColor(Color.WHITE);
        g2.setFont(BOLD_FONT);
        g2.drawString(line1, boxSize.x + (boxSize.width - line1Width) / 2, 50 + line1Height / 2);
        g2.setFont(PLAIN_FONT);
        g2.setColor(Color.BLACK);
        g2.drawString(line2, boxSize.x + (boxSize.width - line2Width) / 2, 70 + line2Height / 2);
        g2.setFont(ITALIC_FONT);
        g2.drawString(line3, boxSize.x + (boxSize.width - line3Width) / 2, 90 + line2Height / 2);
        return boxSize.x + boxSize.width;
    }

    private void drawModifierBox(Graphics2D g2, String text, int startX, int endX, int modifierLine) {
        g2.setFont(PLAIN_FONT);
        FontMetrics fontMetrics = g2.getFontMetrics();
        int lineWidth = fontMetrics.stringWidth(text);
        int lineHeight = fontMetrics.getHeight();
        Rectangle boxSize = new Rectangle(startX, 110 + modifierLine * 30, endX, 20);
        g2.setColor(Color.GRAY);
        g2.fillRect(boxSize.x, boxSize.y, boxSize.width, boxSize.height);
        g2.setColor(Color.BLACK);
        g2.drawRect(boxSize.x, boxSize.y, boxSize.width, boxSize.height);
        g2.setFont(PLAIN_FONT);
        g2.setColor(Color.BLACK);
        g2.drawString(text, boxSize.x + (boxSize.width - lineWidth) / 2, boxSize.y + lineHeight / 2);
    }

    public void setProtocol(Protocol protocol) {
        if (this.protocol != null) {
            this.protocol.removeProtocolListener(this);
        }
        this.protocol = protocol;
        if (this.protocol != null) {
            this.protocol.addProtocolListener(this);
        }
        this.protocolUpdated();
    }

    @Override
    public void protocolUpdated() {
        this.adjustModifierLines();
        this.repaint();
    }

    private void adjustModifierLines() {
        this.modifierLines.clear();
        if (this.protocol != null) {
            for (ProtocolEvent event : this.protocol.events) {
                List<ProtocolEvent> modifierLine2;
                if (ProtocolEvent.EventType.CHEMICAL_MODIFIER != event.getType()) continue;
                boolean placeFound = false;
                for (List<ProtocolEvent> modifierLine2 : this.modifierLines) {
                    ProtocolEvent previousEvent = modifierLine2.get(modifierLine2.size() - 1);
                    double previousEndTime = previousEvent.getStartTime() + previousEvent.getDuration();
                    if (!(event.getStartTime() >= previousEndTime)) continue;
                    modifierLine2.add(event);
                    placeFound = true;
                    break;
                }
                if (placeFound) continue;
                modifierLine2 = new ArrayList<ProtocolEvent>();
                modifierLine2.add(event);
                this.modifierLines.add(modifierLine2);
            }
        }
        Dimension minimumSize = new Dimension(100, 120 + this.modifierLines.size() * 30);
        this.setMinimumSize(minimumSize);
        this.setPreferredSize(minimumSize);
        this.setSize(minimumSize);
    }
}

