/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.FMSim;
import fmsim.gui.ProtocolSelectionListener;
import fmsim.gui.ProtocolsTableModel;
import fmsim.model.Protocol;
import fmsim.model.ProtocolEvent;
import fmsim.model.ProtocolListener;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ProtocolLibraryPanel
extends JPanel
implements ActionListener,
ProtocolListener {
    private static final long serialVersionUID = 1L;
    private static final double F = -1.0;
    private static final double P = -2.0;
    private static final String ACTION_NEW = "new";
    private static final String ACTION_DUPLICATE = "duplicate";
    private static final String ACTION_REMOVE = "remove";
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_SAVE = "save";
    private final List<ProtocolSelectionListener> protocolSelectionListeners = new ArrayList<ProtocolSelectionListener>();
    private final List<Protocol> protocols = new ArrayList<Protocol>();
    private Protocol currentProtocol;
    private JButton protocolNewButton;
    private JButton protocolDuplicateButton;
    private JButton protocolRemoveButton;
    private JButton protocolLoadButton;
    private JButton protocolSaveButton;
    private JTable protocolsTable;
    private ProtocolsTableModel protocolsTableModel;
    private JTextField experimentNameText;
    private JTextArea experimentNotesText;
    private JFileChooser fileChooser;

    public ProtocolLibraryPanel() {
        this.setName("Protocol library");
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -1.0, 10.0}, {10.0, -1.0, 10.0, -2.0, 10.0, -2.0, 10.0}}));
        this.setBackground(FMSim.COLOUR_CONTROL_BG);
        this.add((Component)this.getLibraryTablePanel(), "1,1");
        this.add(this.getExperimentPanel(), "1,3");
        this.changeSelectedProtocol();
    }

    public void addProtocolSelectionListener(ProtocolSelectionListener listener) {
        this.protocolSelectionListeners.add(listener);
    }

    private JPanel getLibraryTablePanel() {
        JPanel libraryTablePanel = new JPanel();
        libraryTablePanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        libraryTablePanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, 10.0, -2.0}}));
        libraryTablePanel.add((Component)this.getProtocolsTable(), "0,0");
        libraryTablePanel.add(this.getLibraryTableActionPanel(), "0,2");
        return libraryTablePanel;
    }

    private Component getLibraryTableActionPanel() {
        JPanel libraryTableActionPanel = new JPanel();
        libraryTableActionPanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        libraryTableActionPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, -1.0}, {-2.0}}));
        this.protocolNewButton = new JButton("New");
        this.protocolNewButton.setActionCommand(ACTION_NEW);
        this.protocolNewButton.addActionListener(this);
        libraryTableActionPanel.add((Component)this.protocolNewButton, "1,0");
        this.protocolDuplicateButton = new JButton("Duplicate");
        this.protocolDuplicateButton.setActionCommand(ACTION_DUPLICATE);
        this.protocolDuplicateButton.addActionListener(this);
        libraryTableActionPanel.add((Component)this.protocolDuplicateButton, "3,0");
        this.protocolRemoveButton = new JButton("Remove");
        this.protocolRemoveButton.setActionCommand(ACTION_REMOVE);
        this.protocolRemoveButton.addActionListener(this);
        libraryTableActionPanel.add((Component)this.protocolRemoveButton, "5,0");
        this.protocolLoadButton = new JButton("Load");
        this.protocolLoadButton.setActionCommand(ACTION_LOAD);
        this.protocolLoadButton.addActionListener(this);
        libraryTableActionPanel.add((Component)this.protocolLoadButton, "7,0");
        this.protocolSaveButton = new JButton("Save");
        this.protocolSaveButton.setActionCommand(ACTION_SAVE);
        this.protocolSaveButton.addActionListener(this);
        libraryTableActionPanel.add((Component)this.protocolSaveButton, "9,0");
        return libraryTableActionPanel;
    }

    private JScrollPane getProtocolsTable() {
        this.protocolsTable = new JTable(this.getProtocolsTableModel());
        this.protocolsTable.setSelectionMode(0);
        this.getProtocolsTableModel().setTableProperties(this.protocolsTable);
        this.getProtocolsTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                ProtocolLibraryPanel.this.changeSelectedProtocol();
            }
        });
        this.protocolsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    ProtocolLibraryPanel.this.changeSelectedProtocol();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.protocolsTable);
        this.protocolsTable.setFillsViewportHeight(true);
        return scrollPane;
    }

    private ProtocolsTableModel getProtocolsTableModel() {
        if (this.protocolsTableModel == null) {
            this.protocolsTableModel = new ProtocolsTableModel(this.protocols);
        }
        return this.protocolsTableModel;
    }

    private Component getExperimentPanel() {
        JPanel experimentPanel = new JPanel();
        experimentPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-2.0, 10.0, -2.0, -1.0}, {-2.0, 10.0, -2.0}}));
        experimentPanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        this.experimentNameText = new JTextField(this.currentProtocol == null ? "" : this.currentProtocol.getExperimentName(), 40);
        this.experimentNameText.setEditable(false);
        JLabel label = new JLabel("Experiment name:");
        label.setLabelFor(this.experimentNameText);
        experimentPanel.add((Component)label, "0,0");
        experimentPanel.add((Component)this.experimentNameText, "2,0");
        this.experimentNotesText = new JTextArea(this.currentProtocol == null ? "" : this.currentProtocol.getExperimentNotes(), 5, 60);
        this.experimentNotesText.setLineWrap(true);
        this.experimentNotesText.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.experimentNotesText);
        label = new JLabel("Experiment notes:");
        label.setLabelFor(this.experimentNotesText);
        experimentPanel.add((Component)label, "0,2,0,2,L,T");
        experimentPanel.add((Component)scrollPane, "2,2,3,2");
        return experimentPanel;
    }

    void changeSelectedProtocol() {
        if (this.currentProtocol != null) {
            this.currentProtocol.removeProtocolListener(this);
        }
        if (this.protocolsTable.getSelectedRowCount() == 1 && this.protocolsTable.getSelectedRow() < this.protocols.size()) {
            this.currentProtocol = this.protocols.get(this.protocolsTable.getSelectedRow());
            this.currentProtocol.addProtocolListener(this);
        } else {
            this.currentProtocol = null;
        }
        this.protocolUpdated();
        this.fireProtocolSelectionChanged();
        this.protocolRemoveButton.setEnabled(this.currentProtocol != null);
        this.protocolSaveButton.setEnabled(this.currentProtocol != null);
        this.protocolDuplicateButton.setEnabled(this.currentProtocol != null);
    }

    private void fireProtocolSelectionChanged() {
        System.out.println("ProtocolLibraryPanel.fireProtocolSelectionChanged");
        for (ProtocolSelectionListener listener : this.protocolSelectionListeners) {
            listener.selectedProtocolChanged(this.currentProtocol);
        }
    }

    public Protocol getSelectedProtocol() {
        return this.currentProtocol;
    }

    private Protocol createProtocol() {
        Protocol protocol = new Protocol();
        protocol.setExperimentName("Assay");
        protocol.setEvents(ProtocolEvent.getNullEvent(0.0, 45.0, "Initial"), ProtocolEvent.getElectricalEvent(60.0, 20.0, "RRP Unload", "20Hz"), ProtocolEvent.getChemicalStimulusEvent(120.0, 20.0, "RP Unload", "KCl", "0.5mM"));
        return protocol;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ACTION_NEW.equals(e.getActionCommand())) {
            this.actionNew();
        } else if (ACTION_DUPLICATE.equals(e.getActionCommand())) {
            this.actionDuplicateSelected();
        } else if (ACTION_REMOVE.equals(e.getActionCommand())) {
            this.actionRemoveSelected();
        } else if (ACTION_LOAD.equals(e.getActionCommand())) {
            this.actionLoad();
        } else if (ACTION_SAVE.equals(e.getActionCommand())) {
            this.actionSaveSelected();
        } else {
            throw new RuntimeException("Unknown event: " + e.toString());
        }
    }

    private void actionSaveSelected() {
        this.getFileChooser().setMultiSelectionEnabled(false);
        if (this.currentProtocol.file != null) {
            this.getFileChooser().setSelectedFile(this.currentProtocol.file);
        } else {
            this.getFileChooser().setSelectedFile(new File(String.valueOf(this.currentProtocol.getExperimentName()) + ".protocol"));
        }
        int response = this.getFileChooser().showSaveDialog(this);
        if (response == 0) {
            File file = this.getFileChooser().getSelectedFile();
            try {
                this.currentProtocol.save(file);
            }
            catch (IOException e) {
                this.handleException(e);
            }
            int rowIndex = this.protocols.indexOf(this.currentProtocol);
            this.getProtocolsTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    private void actionLoad() {
        this.getFileChooser().setMultiSelectionEnabled(true);
        int response = this.getFileChooser().showOpenDialog(this);
        if (response == 0) {
            File[] files;
            File[] fileArray = files = this.getFileChooser().getSelectedFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    Protocol protocol = Protocol.load(file);
                    this.protocols.add(protocol);
                }
                catch (IOException e) {
                    this.handleException(e);
                }
                ++n2;
            }
            this.getProtocolsTableModel().fireTableDataChanged();
            this.protocolsTable.getSelectionModel().setSelectionInterval(0, this.protocols.size() - 1);
        }
    }

    public void actionLoad(File file) {
        try {
            Protocol protocol = Protocol.load(file);
            this.protocols.add(protocol);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        this.getProtocolsTableModel().fireTableDataChanged();
        this.protocolsTable.getSelectionModel().setSelectionInterval(0, this.protocols.size() - 1);
    }

    private void handleException(IOException e) {
        e.printStackTrace();
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Protocol files", "protocol");
            this.fileChooser.setFileFilter(filter);
        }
        return this.fileChooser;
    }

    private void actionRemoveSelected() {
        int response = JOptionPane.showConfirmDialog(this, "Remove protocol '" + this.currentProtocol.getExperimentName() + "' ?\nUnsaved changes will be lost.", "Remove protocol ?", 0, 3);
        if (response == 0) {
            int rowIndex = this.protocols.indexOf(this.currentProtocol);
            this.protocols.remove(this.currentProtocol);
            this.currentProtocol.removeProtocolListener(this);
            this.protocolsTableModel.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    private void actionDuplicateSelected() {
        if (this.currentProtocol == null) {
            return;
        }
        Protocol duplicate = this.currentProtocol.duplicate();
        this.addProtocol(duplicate);
    }

    private void addProtocol(Protocol protocol) {
        this.protocols.add(protocol);
        this.getProtocolsTableModel().fireTableDataChanged();
        this.protocolsTable.getSelectionModel().setSelectionInterval(0, this.protocols.size() - 1);
    }

    private void actionNew() {
        Protocol protocol = this.createProtocol();
        this.addProtocol(protocol);
    }

    @Override
    public void protocolUpdated() {
        if (this.currentProtocol != null) {
            this.experimentNameText.setText(this.currentProtocol.getExperimentName());
            this.experimentNotesText.setText(this.currentProtocol.getExperimentNotes());
        } else {
            this.experimentNameText.setText("");
            this.experimentNotesText.setText("");
        }
    }
}

