/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.EventTypeCellEditor;
import fmsim.model.Protocol;
import fmsim.model.ProtocolEvent;
import fmsim.model.ProtocolListener;
import fmsim.model.Rates;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ProtocolEventsTableModel
extends AbstractTableModel
implements ProtocolListener {
    private static final long serialVersionUID = 1L;
    static final int COLINDEX_START_TIME = 0;
    static final int COLINDEX_DURATION = 1;
    static final int COLINDEX_SUMMARY = 2;
    static final int COLINDEX_DESCRIPTION = 3;
    static final int COLINDEX_EXOCYTOSIS = 4;
    static final int COLINDEX_CME = 5;
    static final int COLINDEX_ADBE = 6;
    static final int COLINDEX_BUDDING = 7;
    static final int COLINDEX_POOL_CHANGE = 8;
    static final int COLINDEX_DELTAT_EXOCYTOSIS = 9;
    static final int COLINDEX_DELTAT_CME = 10;
    static final int COLINDEX_DELTAT_ADBE = 11;
    static final int COLINDEX_DELTAT_BUDDING = 12;
    static final int COLINDEX_DELTAT_POOL_CHANGE = 13;
    static final int COLINDEX_TAGGING = 14;
    static final int COLINDEX_ACID_PULSE = 15;
    static final int COLINDEX_AMMONIA_PULSE = 16;
    public static final String[] COLUMN_NAMES = new String[]{"<html><center>Start<br/>Time</center></html>", "Duration", "Event", "Description", "<html><center>Exocytosis<br/>Rate</center></html>", "<html><center>CME<br/>Rate</center></html>", "<html><center>ADBE<br/>Rate</center></html>", "<html><center>E -&gt; V<br/>Rate</center></html>", "<html><center>RP -&gt; RRP<br/>Rate</center></html>", "<html><center>Exocytosis<br/>Delay</center></html>", "<html><center>CME<br/>Delay</center></html>", "<html><center>ADBE<br/>Delay</center></html>", "<html><center>E -&gt; V<br/>Delay</center></html>", "<html><center>RP -&gt; RRP<br/>Delay</center></html>", "<html><center>FM Dye<br/>Present</center></html>", "<html><center>Acid<br/>Pulse</center></html>", "<html><center>Ammonium<br/>Pulse</center></html>"};
    public static final Class<?>[] COLUMN_TYPES = new Class[]{Double.class, Double.class, ProtocolEvent.EventType.class, String.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Rates.RateValue.class, Boolean.class, Boolean.class, Boolean.class};
    private static final int FIRST_RATE_COLUMN = 4;
    static final Color COLOUR_SAFE_TIME_BG = new Color(0xCCFFDD);
    static final Color COLOUR_OVERLAP_TIME_BG = new Color(0xFFCCDD);
    static final Color COLOUR_INFERRED_RATE_BG = new Color(0xFFCCDD);
    static final Color COLOUR_INFERRED_RATE_FG = Color.GRAY;
    static final Color COLOUR_DEFAULT_RATE_BG = new Color(0xCCFFDD);
    static final Color COLOUR_DEFAULT_RATE_FG = Color.GRAY;
    static final Color COLOUR_OVERRIDE_RATE_BG = new Color(0xFFFFDD);
    static final Color COLOUR_OVERRIDE_RATE_FG = Color.BLACK;
    static final Color COLOUR_SELECTED_BG = new Color(0xDDDDFF);
    Protocol protocol;
    boolean[][] selectedRowAncestorRates;
    String[][] rateValueStrings;
    int selectedRow;
    boolean changingProtocolEvent;

    public static boolean isRateColumn(int columnIndex) {
        return columnIndex >= 4 && columnIndex < 14;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (this.protocol != null) {
            this.protocol.removeProtocolListener(this);
        }
        this.protocol = protocol;
        if (this.protocol != null) {
            this.protocol.addProtocolListener(this);
        }
        this.setSelectedRow(0);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= COLUMN_TYPES.length) {
            return Object.class;
        }
        return COLUMN_TYPES[columnIndex];
    }

    public void setSelectedRow(int rowIndex) {
        this.selectedRow = rowIndex;
        this.updateTableView();
    }

    private void updateTableView() {
        if (this.protocol == null) {
            this.selectedRowAncestorRates = new boolean[1][10];
            this.rateValueStrings = new String[1][10];
            return;
        }
        this.rateValueStrings = new String[this.protocol.events.size() + 1][10];
        int rowIndex = 0;
        while (rowIndex < this.rateValueStrings.length) {
            boolean[][] ancestorRates = this.getAncestorRates(rowIndex);
            if (rowIndex == this.selectedRow) {
                this.selectedRowAncestorRates = ancestorRates;
            }
            int columnIndex = 0;
            while (columnIndex < 10) {
                if (ancestorRates[rowIndex][columnIndex]) {
                    ProtocolEvent event = this.getProtocolEvent(rowIndex);
                    Rates.RateValue rateValue = event.getRates().values[columnIndex];
                    this.rateValueStrings[rowIndex][columnIndex] = Double.toString(rateValue.value);
                }
                boolean rateFound = false;
                int currentRow = 0;
                while (currentRow < ancestorRates.length) {
                    if (ancestorRates[currentRow][columnIndex]) {
                        if (rateFound) {
                            this.rateValueStrings[rowIndex][columnIndex] = "Mixed";
                            break;
                        }
                        ProtocolEvent event = this.getProtocolEvent(currentRow);
                        Rates.RateValue currentRateValue = event.getRates().values[columnIndex];
                        this.rateValueStrings[rowIndex][columnIndex] = "" + currentRateValue.value;
                        rateFound = true;
                    }
                    ++currentRow;
                }
                if (!rateFound) {
                    this.rateValueStrings[rowIndex][columnIndex] = "Error";
                }
                ++columnIndex;
            }
            ++rowIndex;
        }
        this.fireTableDataChanged();
    }

    private boolean[][] getAncestorRates(int rowIndex) {
        boolean[][] result = new boolean[this.protocol.events.size() + 1][10];
        if (rowIndex == 0) {
            Arrays.fill(result[0], true);
        } else {
            ProtocolEvent event = this.protocol.events.get(rowIndex - 1);
            int columnIndex = 0;
            while (columnIndex < 10) {
                Set<ProtocolEvent> ancestors = this.protocol.getAncestorEventsForRate(event, columnIndex);
                for (ProtocolEvent ancestor : ancestors) {
                    if (this.protocol.defaultEvent == ancestor) {
                        result[0][columnIndex] = true;
                        continue;
                    }
                    int ancestorRowIndex = this.protocol.events.indexOf(ancestor) + 1;
                    result[ancestorRowIndex][columnIndex] = true;
                }
                ++columnIndex;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        if (this.protocol == null) {
            return 0;
        }
        return this.protocol.events.size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.protocol == null) {
            return null;
        }
        if (rowIndex == 0) {
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return "Default rates";
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return this.protocol.getDefaultRates().values[columnIndex - 4];
                }
                case 14: {
                    return this.protocol.getDefaultRates().tagging;
                }
                case 15: {
                    return this.protocol.getDefaultRates().acidPulsePresent;
                }
                case 16: {
                    return this.protocol.getDefaultRates().ammoniaPulsePresent;
                }
            }
            return null;
        }
        ProtocolEvent event = this.protocol.events.get(rowIndex - 1);
        switch (columnIndex) {
            case 0: {
                return event.getStartTime();
            }
            case 1: {
                return event.getDuration();
            }
            case 2: {
                return event;
            }
            case 3: {
                return event.getDescription();
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return event.getRates().values[columnIndex - 4];
            }
            case 14: {
                return event.getRates().tagging;
            }
            case 15: {
                return event.getRates().acidPulsePresent;
            }
            case 16: {
                return event.getRates().ammoniaPulsePresent;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        if (columnIndex < 4) {
            this.setNonRateValue(aValue, rowIndex, columnIndex);
        } else {
            this.setRateValue(aValue, rowIndex, columnIndex);
        }
    }

    private void setRateValue(Object aValue, int rowIndex, int columnIndex) {
        Rates rates;
        if (rowIndex == 0) {
            rates = this.protocol.getDefaultRates();
        } else {
            ProtocolEvent event = this.protocol.events.get(rowIndex - 1);
            rates = event.getRates();
        }
        if (aValue instanceof Rates.RateValue) {
            switch (columnIndex) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    rates.values[columnIndex - 4] = (Rates.RateValue)aValue;
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
            }
            return;
        }
        Class<?> clazz = COLUMN_TYPES[columnIndex];
        Rates.RateValue doubleValue = null;
        boolean booleanValue = false;
        if (Rates.RateValue.class == clazz) {
            if (aValue == null || ((String)aValue).trim().length() == 0) {
                doubleValue = Rates.RateValue.INHERITED_RATE;
            } else {
                try {
                    double value = Math.max(0.0, Double.parseDouble((String)aValue));
                    doubleValue = new Rates.RateValue(value);
                }
                catch (NumberFormatException ex) {
                    doubleValue = new Rates.RateValue(0.0);
                }
            }
        } else if (Boolean.class == clazz) {
            try {
                booleanValue = (Boolean)aValue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        switch (columnIndex) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                rates.values[columnIndex - 4] = doubleValue;
                break;
            }
            case 14: {
                rates.tagging = booleanValue;
                if (rowIndex != 0 || this.protocol == null) break;
                for (ProtocolEvent event : this.protocol.events) {
                    event.getRates().tagging = booleanValue;
                }
                break;
            }
            case 15: {
                rates.acidPulsePresent = booleanValue;
                if (rowIndex != 0 || this.protocol == null) break;
                for (ProtocolEvent event : this.protocol.events) {
                    event.getRates().acidPulsePresent = booleanValue;
                }
                break;
            }
            case 16: {
                rates.ammoniaPulsePresent = booleanValue;
                if (rowIndex != 0 || this.protocol == null) break;
                for (ProtocolEvent event : this.protocol.events) {
                    event.getRates().ammoniaPulsePresent = booleanValue;
                }
                break;
            }
        }
        this.protocol.fireProtocolModified();
    }

    private void setNonRateValue(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            return;
        }
        ProtocolEvent event = this.protocol.events.get(rowIndex - 1);
        switch (columnIndex) {
            case 0: {
                try {
                    event.setStartTime(Double.parseDouble(((String)aValue).trim()));
                    this.protocol.sortEvents();
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 1: {
                try {
                    event.setDuration(Double.parseDouble(((String)aValue).trim()));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                event.setDescription(((String)aValue).trim());
                break;
            }
        }
        this.protocol.fireProtocolModified();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.protocol != null && rowIndex >= 0 && rowIndex <= this.protocol.events.size() && (rowIndex > 0 || columnIndex >= 4);
    }

    public void removeEvent(int rowIndex) {
        if (this.protocol == null) {
            return;
        }
        if (rowIndex > 0 && rowIndex <= this.protocol.events.size()) {
            this.protocol.removeEvent(this.protocol.events.get(rowIndex - 1));
            this.updateTableView();
        }
    }

    public ProtocolEvent addNewEvent() {
        if (this.protocol == null) {
            return null;
        }
        ProtocolEvent newEvent = ProtocolEvent.getNullEvent(0.0, 0.0, "New event");
        this.protocol.addEvent(newEvent);
        this.updateTableView();
        return newEvent;
    }

    public void setTableProperties(JTable eventsTable) {
        int index = 0;
        while (index < COLUMN_NAMES.length) {
            eventsTable.getColumnModel().getColumn(index).setHeaderValue(COLUMN_NAMES[index]);
            ++index;
        }
        DefaultCellEditor timeEditor = new DefaultCellEditor(new JTextField());
        TimeRenderer timeRenderer = new TimeRenderer();
        EventTypeCellEditor eventTypeEditor = new EventTypeCellEditor();
        TableCellRenderer textRenderer = new TableCellRenderer(){
            private JLabel label = new JLabel();
            {
                this.label.setOpaque(true);
                this.label.setFont(new Font("SansSerif", 0, 12));
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.label.setBackground(row == 0 ? Color.LIGHT_GRAY : (row == ProtocolEventsTableModel.this.selectedRow ? COLOUR_SELECTED_BG : Color.WHITE));
                this.label.setText("" + value);
                return this.label;
            }
        };
        eventsTable.getColumnModel().getColumn(0).setCellEditor(timeEditor);
        eventsTable.getColumnModel().getColumn(0).setCellRenderer(timeRenderer);
        eventsTable.getColumnModel().getColumn(1).setCellEditor(timeEditor);
        eventsTable.getColumnModel().getColumn(1).setCellRenderer(timeRenderer);
        eventsTable.getColumnModel().getColumn(2).setCellEditor(eventTypeEditor);
        eventsTable.getColumnModel().getColumn(2).setCellRenderer(textRenderer);
        eventsTable.getColumnModel().getColumn(3).setCellRenderer(textRenderer);
        RateValueEditor rateValueEditor = new RateValueEditor();
        DefaultCellEditor booleanEditor = new DefaultCellEditor(new JCheckBox());
        ((JCheckBox)booleanEditor.getComponent()).setHorizontalAlignment(0);
        BooleanRateRenderer booleanRenderer = new BooleanRateRenderer();
        RateValueRenderer rateValueRenderer = new RateValueRenderer();
        eventsTable.setDefaultRenderer(Rates.RateValue.class, rateValueRenderer);
        eventsTable.setDefaultRenderer(Boolean.class, booleanRenderer);
        eventsTable.setDefaultEditor(Rates.RateValue.class, rateValueEditor);
        eventsTable.setDefaultEditor(Boolean.class, booleanEditor);
    }

    public int getEventRow(ProtocolEvent protocolEvent) {
        if (this.protocol == null || protocolEvent == null) {
            return -1;
        }
        if (this.protocol.defaultEvent == protocolEvent) {
            return 0;
        }
        int row = this.protocol.events.indexOf(protocolEvent);
        return row == -1 ? -1 : row + 1;
    }

    public void setProtocolEvent(ProtocolEvent protocolEvent) {
        System.out.println("ProtocolEventsTableModel.setProtocolEvent");
        if (this.changingProtocolEvent) {
            return;
        }
        this.changingProtocolEvent = true;
        try {
            if (this.protocol != null) {
                if (protocolEvent == this.protocol.defaultEvent) {
                    this.setSelectedRow(0);
                } else {
                    this.setSelectedRow(this.protocol.events.indexOf(protocolEvent) + 1);
                }
                this.updateTableView();
            }
        }
        finally {
            this.changingProtocolEvent = false;
        }
    }

    public ProtocolEvent getProtocolEvent(int rowIndex) {
        if (this.protocol == null || rowIndex < 0 || rowIndex > this.protocol.events.size()) {
            return null;
        }
        if (rowIndex == 0) {
            return this.protocol.defaultEvent;
        }
        return this.protocol.events.get(rowIndex - 1);
    }

    @Override
    public void protocolUpdated() {
        this.updateTableView();
    }

    class BooleanRateRenderer
    implements TableCellRenderer {
        private JCheckBox checkbox = new JCheckBox();

        BooleanRateRenderer() {
            this.checkbox.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.checkbox.setBackground(isSelected ? COLOUR_SELECTED_BG : Color.WHITE);
            if (isSelected) {
                this.checkbox.setBackground(COLOUR_SELECTED_BG);
            } else if (row == 0) {
                this.checkbox.setBackground(COLOUR_DEFAULT_RATE_BG);
            } else if (ProtocolEventsTableModel.this.protocol != null) {
                boolean defaultValue = (Boolean)value;
                switch (column) {
                    case 15: {
                        defaultValue = ProtocolEventsTableModel.this.protocol.getDefaultRates().acidPulsePresent;
                        break;
                    }
                    case 16: {
                        defaultValue = ProtocolEventsTableModel.this.protocol.getDefaultRates().ammoniaPulsePresent;
                        break;
                    }
                    case 14: {
                        defaultValue = ProtocolEventsTableModel.this.protocol.getDefaultRates().tagging;
                    }
                }
                this.checkbox.setBackground((Boolean)value == defaultValue ? COLOUR_DEFAULT_RATE_BG : COLOUR_OVERRIDE_RATE_BG);
            }
            this.checkbox.setSelected((Boolean)value);
            return this.checkbox;
        }
    }

    class RateValueEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public RateValueEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Rates.RateValue rateValue = (Rates.RateValue)value;
            return super.getTableCellEditorComponent(table, rateValue == null ? 0.0 : rateValue.value, isSelected, row, column);
        }
    }

    class RateValueRenderer
    implements TableCellRenderer {
        private JLabel label = new JLabel();

        RateValueRenderer() {
            this.label.setOpaque(true);
            this.label.setFont(new Font("SansSerif", 0, 12));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            block11: {
                Rates.RateValue storedValue;
                block12: {
                    block10: {
                        if (!isSelected) break block10;
                        this.label.setBackground(COLOUR_SELECTED_BG);
                        break block11;
                    }
                    if (ProtocolEventsTableModel.this.protocol == null) break block11;
                    storedValue = null;
                    ProtocolEvent event = ProtocolEventsTableModel.this.getProtocolEvent(row);
                    switch (column) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            storedValue = event.getRates().values[column - 4];
                        }
                    }
                    if (storedValue == null) break block12;
                    switch (storedValue.type) {
                        case FIXED: {
                            this.label.setBackground(COLOUR_OVERRIDE_RATE_BG);
                            this.label.setForeground(COLOUR_OVERRIDE_RATE_FG);
                            break block11;
                        }
                        case INFERRED: {
                            this.label.setBackground(COLOUR_INFERRED_RATE_BG);
                            this.label.setForeground(COLOUR_INFERRED_RATE_FG);
                            break block11;
                        }
                        case INHERITED: {
                            this.label.setBackground(COLOUR_DEFAULT_RATE_BG);
                            this.label.setForeground(COLOUR_DEFAULT_RATE_FG);
                            break block11;
                        }
                        default: {
                            throw new RuntimeException("Unknown rate value type");
                        }
                    }
                }
                this.label.setBackground(storedValue == Rates.RateValue.INHERITED_RATE ? COLOUR_DEFAULT_RATE_BG : COLOUR_OVERRIDE_RATE_BG);
                this.label.setForeground(storedValue == Rates.RateValue.INHERITED_RATE ? COLOUR_DEFAULT_RATE_FG : COLOUR_OVERRIDE_RATE_FG);
            }
            this.label.setText(ProtocolEventsTableModel.this.rateValueStrings[row][column - 4]);
            if (ProtocolEventsTableModel.this.selectedRowAncestorRates != null && ProtocolEventsTableModel.this.selectedRowAncestorRates[row][column - 4]) {
                this.label.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
            } else {
                this.label.setBorder(null);
            }
            return this.label;
        }
    }

    class TimeRenderer
    implements TableCellRenderer {
        private JLabel label = new JLabel();

        public TimeRenderer() {
            this.label.setOpaque(true);
            this.label.setFont(new Font("SansSerif", 0, 12));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == 0) {
                this.label.setBackground(Color.LIGHT_GRAY);
            } else if (row == ProtocolEventsTableModel.this.selectedRow) {
                this.label.setBackground(COLOUR_SELECTED_BG);
            } else if (ProtocolEventsTableModel.this.protocol != null) {
                this.label.setBackground(ProtocolEventsTableModel.this.protocol.isOverlappingTime(row - 1) ? COLOUR_OVERLAP_TIME_BG : COLOUR_SAFE_TIME_BG);
            }
            this.label.setText("" + value);
            return this.label;
        }
    }
}

