/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.FMSim;
import fmsim.gui.ProtocolEventSelectionListener;
import fmsim.gui.ProtocolEventTimingPanel;
import fmsim.gui.ProtocolEventsTableModel;
import fmsim.model.Protocol;
import fmsim.model.ProtocolEvent;
import fmsim.model.Rates;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProtocolEventsPanel
extends JPanel
implements ProtocolEventSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final double F = -1.0;
    private static final double P = -2.0;
    JTable eventsTable;
    private ProtocolEventsTableModel eventsTableModel;
    private JButton eventNewButton;
    private JButton eventRemoveButton;
    Protocol protocol = new Protocol();
    private DefaultRateValueCellPopupMenu tableHeaderPopupMenu;
    private RateValueCellPopupMenu tableCellPopupMenu;
    private boolean allowModification;
    private ProtocolEventTimingPanel eventTimingPanel;
    boolean changingProtocolEvent;

    public ProtocolEventsPanel(boolean allowModification) {
        this.allowModification = allowModification;
        this.setBackground(FMSim.COLOUR_CONTROL_BG);
        if (allowModification) {
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, 10.0, -2.0, 10.0, -2.0}}));
            this.add((Component)this.getEventsTable(), "0,0");
            this.add(this.getEventSelectionActionPanel(), "0,2");
            this.add((Component)this.getEventTimingPanel(), "0,4");
        } else {
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, 10.0, -2.0}}));
            this.add((Component)this.getEventsTable(), "0,0");
            this.add((Component)this.getEventTimingPanel(), "0,2");
        }
    }

    private ProtocolEventTimingPanel getEventTimingPanel() {
        if (this.eventTimingPanel == null) {
            this.eventTimingPanel = new ProtocolEventTimingPanel();
            this.eventTimingPanel.addProtocolEventSelectionListener(this);
        }
        return this.eventTimingPanel;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
        this.eventsTableModel.setProtocol(protocol);
        this.eventTimingPanel.setProtocol(protocol);
        if (protocol != null) {
            this.eventsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.allowModification) {
            this.eventNewButton.setEnabled(protocol != null);
            this.eventRemoveButton.setEnabled(protocol != null);
        }
    }

    private Component getEventSelectionActionPanel() {
        JPanel eventSelectionActionPanel = new JPanel();
        eventSelectionActionPanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        eventSelectionActionPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -2.0, 10.0, -2.0, -1.0}, {-2.0}}));
        this.eventNewButton = new JButton("New");
        this.eventNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProtocolEventsPanel.this.addNewEvent();
            }
        });
        eventSelectionActionPanel.add((Component)this.eventNewButton, "1,0");
        this.eventRemoveButton = new JButton("Remove");
        this.eventRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProtocolEventsPanel.this.removeSelectedEvent();
            }
        });
        eventSelectionActionPanel.add((Component)this.eventRemoveButton, "3,0");
        return eventSelectionActionPanel;
    }

    void removeSelectedEvent() {
        int selectedRow = this.eventsTable.getSelectedRow();
        if (selectedRow > 0) {
            this.eventsTableModel.removeEvent(selectedRow);
            this.eventsTable.getSelectionModel().setSelectionInterval(0, Math.min(selectedRow, this.eventsTableModel.getRowCount() - 1));
        }
    }

    void addNewEvent() {
        ProtocolEvent newEvent = this.eventsTableModel.addNewEvent();
        this.selectedProtocolEventChanged(newEvent);
    }

    private JScrollPane getEventsTable() {
        this.eventsTable = new JTable(this.getEventsTableModel());
        this.eventsTable.setSelectionMode(0);
        this.eventsTable.setCellSelectionEnabled(true);
        this.getEventsTableModel().setTableProperties(this.eventsTable);
        if (this.allowModification) {
            this.eventsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting()) {
                        ProtocolEventsPanel.this.changeSelectedEvent();
                    }
                }
            });
            this.eventsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int row = ProtocolEventsPanel.this.eventsTable.rowAtPoint(e.getPoint());
                        int column = ProtocolEventsPanel.this.eventsTable.columnAtPoint(e.getPoint());
                        if (row > -1 && column > -1) {
                            if (!ProtocolEventsPanel.this.eventsTable.isCellSelected(row, column)) {
                                ProtocolEventsPanel.this.eventsTable.changeSelection(row, column, false, false);
                            }
                            ProtocolEventsPanel.this.showTableCellPopupMenu(e.getPoint());
                        }
                    }
                }
            });
        } else {
            this.eventsTable.setEnabled(false);
        }
        JScrollPane scrollPane = new JScrollPane(this.eventsTable);
        this.eventsTable.setFillsViewportHeight(true);
        return scrollPane;
    }

    void showTableCellPopupMenu(Point point) {
        int popupMenuRow = this.eventsTable.rowAtPoint(point);
        int popupMenuColumn = this.eventsTable.columnAtPoint(point);
        if (ProtocolEventsTableModel.isRateColumn(popupMenuColumn)) {
            if (popupMenuRow == 0) {
                this.getTableHeaderPopupMenu().show(this.eventsTable, point.x, point.y);
            } else {
                this.getTableCellPopupMenu().show(this.eventsTable, point.x, point.y);
            }
        }
    }

    private JPopupMenu getTableHeaderPopupMenu() {
        if (this.tableHeaderPopupMenu == null) {
            this.tableHeaderPopupMenu = new DefaultRateValueCellPopupMenu();
        }
        return this.tableHeaderPopupMenu;
    }

    private JPopupMenu getTableCellPopupMenu() {
        if (this.tableCellPopupMenu == null) {
            this.tableCellPopupMenu = new RateValueCellPopupMenu();
        }
        return this.tableCellPopupMenu;
    }

    void changeSelectedEvent() {
        if (this.changingProtocolEvent) {
            System.out.println("ProtocolEventsPanel.changeSelectedEvent nested");
            return;
        }
        this.changingProtocolEvent = true;
        try {
            int selectedRow = this.eventsTable.getSelectedRow();
            if (this.allowModification) {
                this.eventRemoveButton.setEnabled(selectedRow > 0);
            }
            System.out.println("ProtocolEventsPanel.changeSelectedEvent");
            ProtocolEvent event = this.getEventsTableModel().getProtocolEvent(selectedRow);
            this.getEventTimingPanel().setProtocolEvent(event);
            this.getEventsTableModel().setProtocolEvent(event);
        }
        finally {
            this.changingProtocolEvent = false;
        }
    }

    ProtocolEventsTableModel getEventsTableModel() {
        if (this.eventsTableModel == null) {
            this.eventsTableModel = new ProtocolEventsTableModel();
            this.eventsTableModel.setProtocol(this.protocol);
        }
        return this.eventsTableModel;
    }

    @Override
    public void selectedProtocolEventChanged(ProtocolEvent protocolEvent) {
        System.out.println("ProtocolEventsPanel.selectedProtocolEventChanged");
        int eventIndex = this.eventsTableModel.getEventRow(protocolEvent);
        if (eventIndex > -1) {
            this.eventsTable.getSelectionModel().setSelectionInterval(0, eventIndex);
        }
    }

    class DefaultRateValueCellPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JRadioButtonMenuItem defaultMenuItem = new JRadioButtonMenuItem("Reset to default");
        JRadioButtonMenuItem inferredMenuItem;
        int row;
        int column;

        public DefaultRateValueCellPopupMenu() {
            this.defaultMenuItem.addActionListener(this);
            this.inferredMenuItem = new JRadioButtonMenuItem("Set inferred");
            this.inferredMenuItem.addActionListener(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.defaultMenuItem);
            buttonGroup.add(this.inferredMenuItem);
            this.add(this.defaultMenuItem);
            this.add(this.inferredMenuItem);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            Point point = new Point(x, y);
            this.row = ProtocolEventsPanel.this.eventsTable.rowAtPoint(point);
            this.column = ProtocolEventsPanel.this.eventsTable.columnAtPoint(point);
            Rates.RateValue currentRateValue = (Rates.RateValue)ProtocolEventsPanel.this.getEventsTableModel().getValueAt(this.row, this.column);
            switch (currentRateValue.type) {
                case FIXED: {
                    this.defaultMenuItem.setSelected(true);
                    break;
                }
                case INFERRED: {
                    this.inferredMenuItem.setSelected(true);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected rate value type");
                }
            }
            super.show(invoker, x, y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Rates.RateValue newRateValue;
            if (e.getSource() == this.defaultMenuItem) {
                newRateValue = new Rates.RateValue(0);
            } else {
                Rates.RateValue currentRateValue = (Rates.RateValue)ProtocolEventsPanel.this.getEventsTableModel().getValueAt(this.row, this.column);
                newRateValue = new Rates.RateValue(Rates.RateValue.Type.INFERRED, currentRateValue.value);
            }
            ProtocolEventsPanel.this.getEventsTableModel().setValueAt(newRateValue, this.row, this.column);
            ProtocolEventsPanel.this.eventsTable.repaint();
        }
    }

    class RateValueCellPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JRadioButtonMenuItem fixedMenuItem = new JRadioButtonMenuItem("Set fixed value");
        JRadioButtonMenuItem inheritedMenuItem;
        JRadioButtonMenuItem inferredMenuItem;
        int row;
        int column;

        public RateValueCellPopupMenu() {
            this.fixedMenuItem.addActionListener(this);
            this.inheritedMenuItem = new JRadioButtonMenuItem("Set inherited");
            this.inheritedMenuItem.addActionListener(this);
            this.inferredMenuItem = new JRadioButtonMenuItem("Set inferred");
            this.inferredMenuItem.addActionListener(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.fixedMenuItem);
            buttonGroup.add(this.inheritedMenuItem);
            buttonGroup.add(this.inferredMenuItem);
            this.add(this.fixedMenuItem);
            this.add(this.inheritedMenuItem);
            this.add(this.inferredMenuItem);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            Point point = new Point(x, y);
            this.row = ProtocolEventsPanel.this.eventsTable.rowAtPoint(point);
            this.column = ProtocolEventsPanel.this.eventsTable.columnAtPoint(point);
            Rates.RateValue currentRateValue = (Rates.RateValue)ProtocolEventsPanel.this.getEventsTableModel().getValueAt(this.row, this.column);
            switch (currentRateValue.type) {
                case FIXED: {
                    this.fixedMenuItem.setSelected(true);
                    break;
                }
                case INHERITED: {
                    this.inheritedMenuItem.setSelected(true);
                    break;
                }
                case INFERRED: {
                    this.inferredMenuItem.setSelected(true);
                }
            }
            super.show(invoker, x, y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Rates.RateValue currentRateValue = (Rates.RateValue)ProtocolEventsPanel.this.getEventsTableModel().getValueAt(this.row, this.column);
            Rates.RateValue newRateValue = e.getSource() == this.fixedMenuItem ? new Rates.RateValue(currentRateValue.value) : (e.getSource() == this.inheritedMenuItem ? Rates.RateValue.INHERITED_RATE : new Rates.RateValue(Rates.RateValue.Type.INFERRED, currentRateValue.value));
            ProtocolEventsPanel.this.getEventsTableModel().setValueAt(newRateValue, this.row, this.column);
            ProtocolEventsPanel.this.eventsTable.repaint();
        }
    }
}

