/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.ProtocolEventSelectionListener;
import fmsim.model.Protocol;
import fmsim.model.ProtocolEvent;
import fmsim.model.ProtocolListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class ProtocolEventTimingPanel
extends JPanel
implements ProtocolListener {
    private static final long serialVersionUID = 1L;
    private final List<ProtocolEventSelectionListener> protocolEventSelectionListeners = new ArrayList<ProtocolEventSelectionListener>();
    Protocol protocol = new Protocol();
    private ProtocolEvent selectedProtocolEvent;
    private Map<ProtocolEvent, Rectangle> eventBars = new HashMap<ProtocolEvent, Rectangle>();

    public ProtocolEventTimingPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProtocolEvent clickedEvent = ProtocolEventTimingPanel.this.getProtocolEventFromClick(e.getPoint());
                if (clickedEvent != null) {
                    ProtocolEventTimingPanel.this.fireSelectedProtocolEventChanged(clickedEvent);
                }
            }
        });
        Dimension minimumSize = new Dimension(60, 120);
        this.setMinimumSize(minimumSize);
        this.setPreferredSize(minimumSize);
        this.setSize(minimumSize);
    }

    protected ProtocolEvent getProtocolEventFromClick(Point point) {
        this.calculateEventBars();
        ProtocolEvent selectedEvent = null;
        for (ProtocolEvent event : this.protocol.events) {
            Rectangle eventBar = this.eventBars.get(event);
            if (eventBar.contains(point)) {
                selectedEvent = event;
            }
            if (eventBar.x > point.x) break;
        }
        return selectedEvent;
    }

    public void setProtocol(Protocol protocol) {
        if (this.protocol != null) {
            this.protocol.removeProtocolListener(this);
        }
        this.protocol = protocol;
        this.selectedProtocolEvent = null;
        if (this.protocol != null) {
            this.protocol.addProtocolListener(this);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.protocol == null) {
            return;
        }
        this.calculateEventBars();
        for (ProtocolEvent event : this.protocol.events) {
            Rectangle rectangle = this.eventBars.get(event);
            g2.setColor(event == this.selectedProtocolEvent ? Color.RED : Color.GRAY);
            g2.fill(rectangle);
            g2.setColor(Color.BLACK);
            g2.draw(rectangle);
        }
    }

    private void calculateEventBars() {
        this.eventBars.clear();
        if (this.protocol == null) {
            return;
        }
        int availableWidth = this.getWidth() - 40;
        double startTime = this.protocol.getStartTime();
        double endTime = this.protocol.getEndTime();
        double totalTimeLength = endTime - startTime;
        double scale = (double)availableWidth / totalTimeLength;
        for (ProtocolEvent event : this.protocol.events) {
            int x = (int)(event.getStartTime() * scale) + 20;
            int y = 20;
            int width = (int)(event.getDuration() * scale);
            int height = 20;
            this.eventBars.put(event, new Rectangle(x, y, width, height));
        }
    }

    public void addProtocolEventSelectionListener(ProtocolEventSelectionListener listener) {
        this.protocolEventSelectionListeners.add(listener);
    }

    public void setProtocolEvent(ProtocolEvent protocolEvent) {
        System.out.println("ProtocolEventTimingPanel.setProtocolEvent");
        this.selectedProtocolEvent = protocolEvent;
        this.repaint();
    }

    void fireSelectedProtocolEventChanged(ProtocolEvent event) {
        System.out.println("ProtocolEventTimingPanel.fireSelectedProtocolEventChanged");
        for (ProtocolEventSelectionListener listener : this.protocolEventSelectionListeners) {
            listener.selectedProtocolEventChanged(event);
        }
    }

    @Override
    public void protocolUpdated() {
        System.out.println("ProtocolEventTimingPanel.protocolUpdated");
        this.repaint();
    }
}

