/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import au.com.bytecode.opencsv.CSVWriter;
import fmsim.gui.FMSim;
import fmsim.gui.ProtocolEventsPanel;
import fmsim.model.Protocol;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProtocolEditPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double F = -1.0;
    private static final double P = -2.0;
    JTextField experimentNameText;
    JTextArea experimentNotesText;
    JLabel experimentNameLabel;
    JLabel experimentNotesLabel;
    Protocol protocol = new Protocol();
    private ProtocolEventsPanel protocolEventsPanel;

    public ProtocolEditPanel() {
        this.setName("Protocol");
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -1.0, 10.0}, {10.0, -2.0, 10.0, -1.0, 10.0}}));
        this.setBackground(FMSim.COLOUR_CONTROL_BG);
        this.add(this.getExperimentPanel(), "1,1");
        this.add((Component)this.getProtocolEventsPanel(), "1,3");
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
        this.getProtocolEventsPanel().setProtocol(protocol);
        if (protocol != null) {
            this.experimentNameText.setText(protocol.getExperimentName());
            this.experimentNotesText.setText(protocol.getExperimentNotes());
        } else {
            this.experimentNameText.setText("");
            this.experimentNotesText.setText("");
        }
        this.experimentNameText.setEnabled(protocol != null);
        this.experimentNotesText.setEnabled(protocol != null);
        this.experimentNameLabel.setEnabled(protocol != null);
        this.experimentNotesLabel.setEnabled(protocol != null);
    }

    private ProtocolEventsPanel getProtocolEventsPanel() {
        if (this.protocolEventsPanel == null) {
            this.protocolEventsPanel = new ProtocolEventsPanel(true);
        }
        return this.protocolEventsPanel;
    }

    private Component getExperimentPanel() {
        JPanel experimentPanel = new JPanel();
        experimentPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-2.0, 10.0, -2.0, 10.0, -1.0, -2.0}, {-2.0, 10.0, -2.0}}));
        experimentPanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        this.experimentNameText = new JTextField(this.protocol.getExperimentName(), 40);
        this.experimentNameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtocolEditPanel.this.updateExperimentNameText();
            }
        });
        this.experimentNameText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ProtocolEditPanel.this.updateExperimentNameText();
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        });
        this.experimentNameLabel = new JLabel("Experiment name:");
        this.experimentNameLabel.setLabelFor(this.experimentNameText);
        experimentPanel.add((Component)this.experimentNameLabel, "0,0");
        experimentPanel.add((Component)this.experimentNameText, "2,0");
        this.experimentNotesText = new JTextArea(this.protocol.getExperimentNotes(), 5, 60);
        this.experimentNotesText.setLineWrap(true);
        this.experimentNotesText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ProtocolEditPanel.this.updateExperimentNotesText();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ProtocolEditPanel.this.updateExperimentNotesText();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                ProtocolEditPanel.this.updateExperimentNotesText();
            }
        });
        this.experimentNotesText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ProtocolEditPanel.this.updateExperimentNotesText();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.experimentNotesText);
        this.experimentNotesLabel = new JLabel("Experiment notes:");
        this.experimentNotesLabel.setLabelFor(this.experimentNotesText);
        experimentPanel.add((Component)this.experimentNotesLabel, "0,2,0,2,L,T");
        experimentPanel.add((Component)scrollPane, "2,2,5,2");
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProtocolEditPanel.this.save();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
        });
        experimentPanel.add((Component)saveButton, "5,0");
        return experimentPanel;
    }

    void save() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        if (this.protocol.file != null) {
            fileChooser.setSelectedFile(this.protocol.file);
        } else {
            fileChooser.setSelectedFile(new File(String.valueOf(this.protocol.getExperimentName()) + ".protocol"));
        }
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            CSVWriter writer = new CSVWriter((Writer)new FileWriter(file));
            try {
                writer.writeAll(this.protocol.exportData());
            }
            finally {
                writer.close();
            }
        }
    }

    void updateExperimentNameText() {
        if (this.protocol != null && !this.protocol.getExperimentName().equals(this.experimentNameText.getText().trim())) {
            this.protocol.setExperimentName(this.experimentNameText.getText().trim());
        }
    }

    void updateExperimentNotesText() {
        if (this.protocol != null && !this.protocol.getExperimentNotes().equals(this.experimentNotesText.getText().trim())) {
            this.protocol.setExperimentNotes(this.experimentNotesText.getText().trim());
        }
    }
}

