/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.model.Protocol;
import fmsim.observations.ObservationsModel;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CrosshairLabelGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.Plot;

public class ObservationsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double F = -1.0;
    private static final double P = -2.0;
    private static final Font CONTROL_TITLE_FONT = new Font("SansSerif", 1, 16);
    static final Color COLOUR_CONTROL_BG = new Color(0xCCDDFF);
    private ChartPanel combinedChartPanel;
    ObservationsModel model = ObservationsModel.EMPTY_MODEL;
    File currentDirectory;
    private MeanDisplayOptionsPanel meanDisplayOptionsPanel;
    private DecayCorrectionPanel decayCorrectionPanel;
    Protocol protocol;

    public ObservationsPanel() {
        this.setLayout(new BorderLayout());
        this.setName("Observations");
        this.add((Component)this.getChartsPanel(), "Center");
        this.add((Component)this.getControlPanel(), "West");
    }

    private JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(COLOUR_CONTROL_BG);
        controlPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -1.0, 10.0}, {10.0, -2.0, 10.0, -2.0, 10.0, -2.0, -1.0, 10.0}}));
        controlPanel.add((Component)this.getInputPanel(), "1,1");
        controlPanel.add((Component)this.getMeanDisplayOptionsPanel(), "1,3");
        controlPanel.add((Component)this.getDecayCorrectionPanel(), "1,5");
        return controlPanel;
    }

    private static JPanel getControlSubPanel(String title) {
        JPanel panel = new JPanel();
        ObservationsPanel.initControlSubPanel(panel, title);
        panel.setBackground(COLOUR_CONTROL_BG);
        return panel;
    }

    public static void initControlSubPanel(JPanel panel, String title) {
        panel.setBackground(COLOUR_CONTROL_BG);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        border.setTitleFont(CONTROL_TITLE_FONT);
        border.setTitleJustification(2);
        panel.setBorder(border);
    }

    void redrawCharts() {
        this.model.updatePlots(this.getMeanDisplayOptionsPanel().getVarianceType());
    }

    private MeanDisplayOptionsPanel getMeanDisplayOptionsPanel() {
        if (this.meanDisplayOptionsPanel == null) {
            this.meanDisplayOptionsPanel = new MeanDisplayOptionsPanel();
        }
        return this.meanDisplayOptionsPanel;
    }

    private DecayCorrectionPanel getDecayCorrectionPanel() {
        if (this.decayCorrectionPanel == null) {
            this.decayCorrectionPanel = new DecayCorrectionPanel();
        }
        return this.decayCorrectionPanel;
    }

    private JPanel getInputPanel() {
        JPanel inputPanel = ObservationsPanel.getControlSubPanel("Input");
        inputPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0}}));
        JButton openButton = new JButton("Open...");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fileChooser = new JFileChooser();
                if (ObservationsPanel.this.currentDirectory != null) {
                    fileChooser.setCurrentDirectory(ObservationsPanel.this.currentDirectory);
                }
                fileChooser.setFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
                if (fileChooser.showOpenDialog(ObservationsPanel.this) == 0) {
                    ObservationsPanel.this.openModel(fileChooser.getSelectedFile());
                }
            }
        });
        inputPanel.add((Component)openButton, "2,1");
        return inputPanel;
    }

    void openModel(File inputFile) {
        if (this.protocol == null) {
            return;
        }
        if (inputFile == null) {
            this.model = ObservationsModel.EMPTY_MODEL;
            this.protocol.setObservations(null);
        } else {
            try {
                this.model = new ObservationsModel(inputFile);
                this.currentDirectory = inputFile.getParentFile();
                this.protocol.setObservations(this.model.getObservations());
            }
            catch (Exception ex) {
                this.handleException(ex);
                this.model = ObservationsModel.EMPTY_MODEL;
                this.protocol.setObservations(null);
            }
        }
        boolean enabled = this.model != ObservationsModel.EMPTY_MODEL;
        this.getMeanDisplayOptionsPanel().setEnabled(enabled);
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Frame"));
        combinedPlot.add(this.model.rawMeanPlot);
        combinedPlot.add(this.model.scaledMeanPlot);
        this.combinedChartPanel.setChart(new JFreeChart(null, null, (Plot)combinedPlot, true));
        this.getMeanDisplayOptionsPanel().setModel();
        this.getDecayCorrectionPanel().setModel();
        this.redrawCharts();
    }

    private void handleException(Exception ex) {
        ex.printStackTrace();
        String message = "There was a problem: \n" + ex.getMessage();
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private JPanel getChartsPanel() {
        JPanel chartsPanel = new JPanel();
        chartsPanel.setLayout(new BoxLayout(chartsPanel, 1));
        chartsPanel.setBorder(BorderFactory.createEtchedBorder());
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Frame"));
        this.combinedChartPanel = new ChartPanel(new JFreeChart(null, null, (Plot)combinedPlot, false));
        chartsPanel.add((Component)this.combinedChartPanel);
        return chartsPanel;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
        this.openModel(null);
    }

    private abstract class ControlSubPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ControlSubPanel(String title) {
            ObservationsPanel.initControlSubPanel(this, title);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            ((TitledBorder)this.getBorder()).setTitleColor(enabled ? Color.BLACK : Color.GRAY);
        }
    }

    private class DecayCorrectionPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox useCorrectionCheckbox;
        private JLabel typeLabel;
        private JRadioButton typeLinearRadio;
        private JLabel methodLabel;
        private JRadioButton methodFixedRadio;
        private SpinnerNumberModel fixedValueModel;
        private JSpinner fixedValueSpinner;
        private JLabel fixedValueLabel;

        public DecayCorrectionPanel() {
            super("Decay Correction");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0, -2.0, 5.0, -2.0, 10.0, -2.0, 5.0, -2.0, 10.0, -2.0, 10.0, -2.0, 5.0, -2.0, 10.0}}));
            this.useCorrectionCheckbox = new JCheckBox("Use decay correction");
            this.useCorrectionCheckbox.setBackground(COLOUR_CONTROL_BG);
            this.typeLabel = new JLabel("Type:");
            this.typeLinearRadio = new JRadioButton("Linear");
            this.typeLinearRadio.setBackground(COLOUR_CONTROL_BG);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.typeLinearRadio);
            this.typeLinearRadio.setSelected(true);
            this.methodLabel = new JLabel("Method:");
            this.methodFixedRadio = new JRadioButton("Fixed");
            this.methodFixedRadio.setBackground(COLOUR_CONTROL_BG);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.methodFixedRadio);
            this.methodFixedRadio.setSelected(true);
            this.fixedValueModel = new SpinnerNumberModel(5.0, 0.0, 500000.1, 1.0);
            this.fixedValueSpinner = new JSpinner(this.fixedValueModel);
            this.fixedValueLabel = new JLabel("Fixed value (per s):");
            this.fixedValueLabel.setLabelFor(this.fixedValueSpinner);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DecayCorrectionPanel.this.setEnabled(DecayCorrectionPanel.this.isEnabled());
                    DecayCorrectionPanel.this.recalculateCorrection();
                }
            };
            this.useCorrectionCheckbox.addActionListener(actionListener);
            this.typeLinearRadio.addActionListener(actionListener);
            this.methodFixedRadio.addActionListener(actionListener);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DecayCorrectionPanel.this.recalculateCorrection();
                }
            };
            this.fixedValueSpinner.addChangeListener(changeListener);
            this.add((Component)this.useCorrectionCheckbox, "2,1,4,1");
            this.add((Component)this.typeLabel, "2,3,4,3");
            this.add((Component)this.typeLinearRadio, "2,5");
            this.add((Component)this.methodLabel, "2,7,4,7");
            this.add((Component)this.methodFixedRadio, "2,9");
            this.add((Component)this.fixedValueLabel, "2,11");
            this.add((Component)this.fixedValueSpinner, "4,11");
            this.setEnabled(false);
        }

        protected void recalculateCorrection() {
            boolean useCorrection;
            if (!this.useCorrectionCheckbox.isSelected()) {
                ObservationsPanel.this.model.resetCorrection();
            } else if (this.methodFixedRadio.isSelected()) {
                ObservationsPanel.this.model.setCorrection(this.getCorrectionType(), (Double)this.fixedValueModel.getNumber());
            }
            boolean bl = useCorrection = this.isEnabled() && this.useCorrectionCheckbox.isSelected();
            if (ObservationsPanel.this.protocol != null && ObservationsPanel.this.model != null) {
                ObservationsPanel.this.protocol.setObservations(useCorrection ? ObservationsPanel.this.model.getCorrectedObservations() : ObservationsPanel.this.model.getObservations());
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.useCorrectionCheckbox.setEnabled(enabled);
            boolean useCorrection = enabled && this.useCorrectionCheckbox.isSelected();
            this.typeLabel.setEnabled(useCorrection);
            this.typeLinearRadio.setEnabled(useCorrection);
            this.methodLabel.setEnabled(useCorrection);
            this.methodFixedRadio.setEnabled(useCorrection);
            if (ObservationsPanel.this.protocol != null && ObservationsPanel.this.model != null) {
                ObservationsPanel.this.protocol.setObservations(useCorrection ? ObservationsPanel.this.model.getCorrectedObservations() : ObservationsPanel.this.model.getObservations());
            }
            boolean useFixedCorrection = useCorrection && this.methodFixedRadio.isSelected();
            this.fixedValueLabel.setEnabled(useFixedCorrection);
            this.fixedValueSpinner.setEnabled(useFixedCorrection);
        }

        public ObservationsModel.DECAY_CORRECTION_TYPE getCorrectionType() {
            return this.typeLinearRadio.isSelected() ? ObservationsModel.DECAY_CORRECTION_TYPE.LINEAR : ObservationsModel.DECAY_CORRECTION_TYPE.EXPONENTIAL;
        }

        public void setModel() {
            if (ObservationsPanel.this.model == ObservationsModel.EMPTY_MODEL) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            this.useCorrectionCheckbox.setSelected(false);
        }
    }

    public static class FrameMarker
    extends Crosshair {
        private static final long serialVersionUID = 1L;
        private final String label;
        private final int value;

        public FrameMarker(final String label, int value) {
            super((double)value);
            this.label = label;
            this.value = value;
            this.setLabelGenerator(new CrosshairLabelGenerator(){

                public String generateLabel(Crosshair crosshair) {
                    return label;
                }
            });
            this.setLabelVisible(true);
        }

        public String toString() {
            return String.valueOf(this.value) + " : " + this.label;
        }
    }

    private class MeanDisplayOptionsPanel
    extends ControlSubPanel {
        private static final long serialVersionUID = 1L;
        private JLabel errorLabel;
        private JRadioButton errorStddevRadio;
        private JRadioButton errorSemRadio;

        public MeanDisplayOptionsPanel() {
            super("Mean View");
            this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 5.0, -2.0, 10.0}}));
            this.errorSemRadio = new JRadioButton("SEM");
            this.errorStddevRadio = new JRadioButton("Sample STDEV");
            this.errorSemRadio.setBackground(COLOUR_CONTROL_BG);
            this.errorStddevRadio.setBackground(COLOUR_CONTROL_BG);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.errorSemRadio);
            buttonGroup.add(this.errorStddevRadio);
            this.errorSemRadio.setSelected(true);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObservationsPanel.this.redrawCharts();
                }
            };
            this.errorSemRadio.addActionListener(actionListener);
            this.errorStddevRadio.addActionListener(actionListener);
            this.errorLabel = new JLabel("Display error as:");
            this.add((Component)this.errorLabel, "2,1,4,1");
            this.add((Component)this.errorSemRadio, "2,3");
            this.add((Component)this.errorStddevRadio, "4,3");
            this.errorLabel.setEnabled(false);
            this.errorSemRadio.setEnabled(false);
            this.errorStddevRadio.setEnabled(false);
        }

        public ObservationsModel.VARIANCE_TYPE getVarianceType() {
            return this.errorStddevRadio.isSelected() ? ObservationsModel.VARIANCE_TYPE.STDDEV : ObservationsModel.VARIANCE_TYPE.SEM;
        }

        public void setModel() {
            if (ObservationsPanel.this.model == ObservationsModel.EMPTY_MODEL) {
                this.errorLabel.setEnabled(false);
                this.errorSemRadio.setEnabled(false);
                this.errorStddevRadio.setEnabled(false);
            } else {
                this.errorLabel.setEnabled(true);
                this.errorSemRadio.setEnabled(true);
                this.errorStddevRadio.setEnabled(true);
            }
        }
    }
}

