/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.FMSim;
import fmsim.model.Protocol;
import fmsim.model.VesicleModel;
import fmsim.model.VesicleModelConfiguration;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModelConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double F = -1.0;
    private static final double P = -2.0;
    private JCheckBox cmeCheckbox;
    private JCheckBox adbeCheckbox;
    private SpinnerNumberModel rrpCmeVesicleRatioText;
    private SpinnerNumberModel rrpSpacesAvailableText;
    private SpinnerNumberModel totalVesicleCountText;
    private JComboBox fluorescenceTypeList;
    private VesicleModelConfiguration configuration;

    public ModelConfigurationPanel() {
        this.setLayout(new BorderLayout());
        this.setName("Model Configuration");
        this.add((Component)this.getControlPanel(), "Center");
    }

    private JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        controlPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}}));
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ModelConfigurationPanel.this.updateConfiguration();
            }
        };
        this.cmeCheckbox = new JCheckBox("CME active", true);
        this.adbeCheckbox = new JCheckBox("ADBE active", true);
        this.cmeCheckbox.setBackground(FMSim.COLOUR_CONTROL_BG);
        this.adbeCheckbox.setBackground(FMSim.COLOUR_CONTROL_BG);
        this.cmeCheckbox.addChangeListener(changeListener);
        this.adbeCheckbox.addChangeListener(changeListener);
        controlPanel.add((Component)this.cmeCheckbox, "2,1");
        controlPanel.add((Component)this.adbeCheckbox, "2,3");
        this.rrpCmeVesicleRatioText = new SpinnerNumberModel(0.35, 0.0, 1.0, 0.1);
        JSpinner rrpCmeVesicleRatioSpinner = new JSpinner(this.rrpCmeVesicleRatioText);
        JLabel rrpCmeVesicleRatioLabel = new JLabel("Ratio of new CME vesicles to RRP");
        rrpCmeVesicleRatioLabel.setLabelFor(rrpCmeVesicleRatioSpinner);
        this.rrpCmeVesicleRatioText.addChangeListener(changeListener);
        controlPanel.add((Component)rrpCmeVesicleRatioLabel, "2,5");
        controlPanel.add((Component)rrpCmeVesicleRatioSpinner, "4,5");
        this.rrpSpacesAvailableText = new SpinnerNumberModel(10, 1, 1000, 1);
        JSpinner rrpSpacesAvailableSpinner = new JSpinner(this.rrpSpacesAvailableText);
        JLabel rrpSpacesAvailableLabel = new JLabel("Active zone spaces available");
        rrpSpacesAvailableLabel.setLabelFor(rrpSpacesAvailableSpinner);
        this.rrpSpacesAvailableText.addChangeListener(changeListener);
        controlPanel.add((Component)rrpSpacesAvailableLabel, "2,7");
        controlPanel.add((Component)rrpSpacesAvailableSpinner, "4,7");
        this.totalVesicleCountText = new SpinnerNumberModel(100, 1, 1000, 1);
        JSpinner totalVesicleCountSpinner = new JSpinner(this.totalVesicleCountText);
        JLabel totalVesicleCountLabel = new JLabel("Total vesicles in system");
        totalVesicleCountLabel.setLabelFor(totalVesicleCountSpinner);
        this.totalVesicleCountText.addChangeListener(changeListener);
        controlPanel.add((Component)totalVesicleCountLabel, "2,9");
        controlPanel.add((Component)totalVesicleCountSpinner, "4,9");
        this.fluorescenceTypeList = new JComboBox<String>(new String[]{"FM1-43", "FM2-10", "pHluorin"});
        this.fluorescenceTypeList.setSelectedIndex(0);
        JLabel fluorescenceTypeLabel = new JLabel("Fluorescent marker");
        fluorescenceTypeLabel.setLabelFor(this.fluorescenceTypeList);
        this.fluorescenceTypeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelConfigurationPanel.this.updateConfiguration();
            }
        });
        controlPanel.add((Component)fluorescenceTypeLabel, "2,11");
        controlPanel.add((Component)this.fluorescenceTypeList, "4,11");
        return controlPanel;
    }

    void updateConfiguration() {
        if (this.configuration == null) {
            return;
        }
        this.configuration.cme = this.cmeCheckbox.isSelected();
        this.configuration.adbe = this.adbeCheckbox.isSelected();
        this.configuration.rrpCmeVesicleRatio = this.rrpCmeVesicleRatioText.getNumber().doubleValue();
        this.configuration.rrpSpacesAvailable = this.rrpSpacesAvailableText.getNumber().intValue();
        this.configuration.totalVesicleCount = Math.max(this.configuration.rrpSpacesAvailable, this.totalVesicleCountText.getNumber().intValue());
        String fluorescenceTypeString = (String)this.fluorescenceTypeList.getSelectedItem();
        if ("FM1-43".equals(fluorescenceTypeString)) {
            this.configuration.fluorescenceType = VesicleModel.FluorescenceType.FM143;
        } else if ("FM2-10".equals(fluorescenceTypeString)) {
            this.configuration.fluorescenceType = VesicleModel.FluorescenceType.FM210;
        } else if ("pHluorin".equals(fluorescenceTypeString)) {
            this.configuration.fluorescenceType = VesicleModel.FluorescenceType.PHLUORIN;
        } else {
            throw new RuntimeException("Unknown fluorescence type");
        }
    }

    public void setProtocol(Protocol protocol) {
        this.setConfiguration(protocol == null ? null : protocol.getConfiguration());
    }

    private void setConfiguration(VesicleModelConfiguration configuration) {
        this.configuration = configuration;
        if (configuration == null) {
            return;
        }
        this.cmeCheckbox.setSelected(configuration.cme);
        this.adbeCheckbox.setSelected(configuration.adbe);
        this.rrpCmeVesicleRatioText.setValue(configuration.rrpCmeVesicleRatio);
        this.rrpSpacesAvailableText.setValue(configuration.rrpSpacesAvailable);
        this.totalVesicleCountText.setValue(configuration.totalVesicleCount);
        switch (configuration.fluorescenceType) {
            case FM143: {
                this.fluorescenceTypeList.setSelectedItem("FM1-43");
                break;
            }
            case FM210: {
                this.fluorescenceTypeList.setSelectedItem("FM2-10");
                break;
            }
            case PHLUORIN: {
                this.fluorescenceTypeList.setSelectedItem("pHluorin");
                break;
            }
            default: {
                throw new RuntimeException("Unknown fluorescence type");
            }
        }
    }
}

