/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.InferencePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class InferenceResultsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    static final Color COLOUR_SELECTED_BG = new Color(0xDDDDFF);
    private static final int COLINDEX_ITERATION = 0;
    private static final int COLINDEX_DISTANCE = 1;
    private static final String[] COLUMN_NAMES = new String[]{"Iteration", "Distance"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{Integer.class, Double.class};
    private final List<InferencePanel.IterationData> inferenceResults;

    public InferenceResultsTableModel(List<InferencePanel.IterationData> inferenceResults) {
        this.inferenceResults = inferenceResults;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= COLUMN_TYPES.length) {
            return Object.class;
        }
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.inferenceResults.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.inferenceResults.get((int)row).iteration;
            }
            case 1: {
                return this.inferenceResults.get((int)row).marginal;
            }
        }
        return null;
    }

    public void setTableProperties(JTable inferenceResultsTable) {
        int index = 0;
        while (index < COLUMN_NAMES.length) {
            inferenceResultsTable.getColumnModel().getColumn(index).setHeaderValue(COLUMN_NAMES[index]);
            ++index;
        }
        TableCellRenderer doubleRenderer = new TableCellRenderer(){
            private final DecimalFormat doubleFormat = new DecimalFormat("0.00");
            private JLabel label = new JLabel();
            {
                this.label.setOpaque(true);
                this.label.setFont(new Font("SansSerif", 0, 12));
                this.label.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.label.setBackground(isSelected ? COLOUR_SELECTED_BG : Color.WHITE);
                this.label.setText(this.doubleFormat.format(value));
                return this.label;
            }
        };
        DefaultTableCellRenderer integerRenderer = new DefaultTableCellRenderer();
        integerRenderer.setHorizontalAlignment(0);
        inferenceResultsTable.setDefaultRenderer(Integer.class, integerRenderer);
        inferenceResultsTable.setDefaultRenderer(Double.class, doubleRenderer);
    }
}

