/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.FMSim;
import fmsim.gui.InferenceResultsTableModel;
import fmsim.gui.ProtocolEventsPanel;
import fmsim.inference.InferenceOverallModel;
import fmsim.model.ChartDataModel;
import fmsim.model.InferenceListener;
import fmsim.model.MultipleSimulator;
import fmsim.model.Protocol;
import fmsim.model.ProtocolListener;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public class InferencePanel
extends JPanel
implements ProtocolListener {
    private static final long serialVersionUID = 1L;
    final NumberFormat distanceFormat = new DecimalFormat("0.00");
    private static final double F = -1.0;
    private static final double P = -2.0;
    private static final Font CONTROL_TITLE_FONT = new Font("SansSerif", 1, 18);
    private static final int ITERATION_COUNT = 50000;
    private ChartPanel comparisonChartPanel;
    ChartDataModel chartDataModel = new ChartDataModel();
    JLabel repeatCountLabel;
    JSpinner repeatCountSpinner;
    SpinnerNumberModel repeatCountText;
    JButton runStopButton;
    JButton saveInferredProtocolButton;
    JLabel distanceText;
    JLabel iterationText;
    Protocol inferredProtocol;
    JProgressBar progressBar;
    RunInferenceWorker runningInference;
    private Protocol protocol = new Protocol();
    ProtocolEventsPanel inferredProtocolPanel;
    final List<IterationData> inferenceResults = new ArrayList<IterationData>();
    private InferenceResultsTableModel resultsTableModel;
    private JTable resultsTable;

    public InferencePanel() {
        this.setLayout(new BorderLayout());
        this.setName("Inference");
        this.add((Component)this.getMainPanel(), "Center");
        this.add((Component)this.getControlPanel(), "West");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getChartPanel());
        mainPanel.add(this.getInferredProtocolPanel());
        return mainPanel;
    }

    private JPanel getChartPanel() {
        JPanel chartPanel = new JPanel();
        chartPanel.setLayout(new BoxLayout(chartPanel, 1));
        this.comparisonChartPanel = new ChartPanel(ChartFactory.createXYLineChart(null, (String)"Time", (String)"Normalised fluorescence", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false));
        chartPanel.setBorder(BorderFactory.createEtchedBorder());
        chartPanel.add((Component)this.comparisonChartPanel);
        return chartPanel;
    }

    private ProtocolEventsPanel getInferredProtocolPanel() {
        if (this.inferredProtocolPanel == null) {
            this.inferredProtocolPanel = new ProtocolEventsPanel(false);
        }
        return this.inferredProtocolPanel;
    }

    private JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(FMSim.COLOUR_CONTROL_BG);
        controlPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -2.0, 10.0}, {10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -1.0}}));
        controlPanel.add((Component)this.getActionPanel(), "1,1");
        controlPanel.add((Component)this.getDistancePanel(), "1,3");
        controlPanel.add((Component)this.getResultsTablePanel(), "1,5");
        controlPanel.add((Component)this.getInferredProtocolOutputPanel(), "1,7");
        return controlPanel;
    }

    private JPanel getInferredProtocolOutputPanel() {
        JPanel outputPanel = this.getControlSubPanel("Save inferred protocol");
        outputPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0}}));
        this.saveInferredProtocolButton = new JButton("Save...");
        this.saveInferredProtocolButton.setEnabled(false);
        this.saveInferredProtocolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    InferencePanel.this.saveInferredProtocol();
                }
                catch (IOException e) {
                    InferencePanel.this.handleException(e);
                }
            }
        });
        outputPanel.add((Component)this.saveInferredProtocolButton, "2,1");
        return outputPanel;
    }

    private JPanel getResultsTablePanel() {
        JPanel resultsTablePanel = this.getControlSubPanel("Results");
        resultsTablePanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -2.0, 10.0}, {10.0, -2.0, 10.0}}));
        resultsTablePanel.add((Component)this.getResultsTable(), "1,1");
        return resultsTablePanel;
    }

    private JScrollPane getResultsTable() {
        this.resultsTable = new JTable(this.getResultsTableModel());
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.setAutoCreateRowSorter(true);
        this.getResultsTableModel().setTableProperties(this.resultsTable);
        this.getResultsTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                InferencePanel.this.changeSelectedResult();
            }
        });
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    InferencePanel.this.changeSelectedResult();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.resultsTable);
        this.resultsTable.setFillsViewportHeight(true);
        return scrollPane;
    }

    protected void changeSelectedResult() {
        if (this.resultsTable.getSelectedRowCount() == 1 && this.resultsTable.getSelectedRow() < this.inferenceResults.size()) {
            int repeatCount = this.repeatCountText.getNumber().intValue();
            int resultIndex = this.resultsTable.convertRowIndexToModel(this.resultsTable.getSelectedRow());
            IterationData selectedIteration = this.inferenceResults.get(resultIndex);
            MultipleSimulator simulator = new MultipleSimulator(selectedIteration.protocol, repeatCount);
            simulator.run();
            this.setInferredProtocol(selectedIteration.protocol, "" + selectedIteration.iteration, simulator.getObservations());
        } else {
            this.setInferredProtocol(null, "", null);
        }
    }

    private void setInferredProtocol(Protocol protocol, String iteration, float[][][] simulatedObservations) {
        this.chartDataModel.setSimulatedData(simulatedObservations);
        this.inferredProtocol = protocol;
        this.inferredProtocolPanel.setProtocol(protocol);
        this.iterationText.setText(iteration);
        this.saveInferredProtocolButton.setEnabled(protocol != null);
        this.redrawCharts();
    }

    InferenceResultsTableModel getResultsTableModel() {
        if (this.resultsTableModel == null) {
            this.resultsTableModel = new InferenceResultsTableModel(this.getInferenceResults());
        }
        return this.resultsTableModel;
    }

    private List<IterationData> getInferenceResults() {
        return this.inferenceResults;
    }

    private JComponent getActionPanel() {
        JPanel actionPanel = this.getControlSubPanel("Run Inference");
        actionPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 30.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0}}));
        this.repeatCountText = new SpinnerNumberModel(10, 1, 100000, 1);
        this.repeatCountSpinner = new JSpinner(this.repeatCountText);
        this.repeatCountLabel = new JLabel("Repeat Count");
        this.repeatCountLabel.setLabelFor(this.repeatCountSpinner);
        actionPanel.add((Component)this.repeatCountLabel, "2,1");
        actionPanel.add((Component)this.repeatCountSpinner, "4,1");
        this.progressBar = new JProgressBar(0, 50000);
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        actionPanel.add((Component)this.progressBar, "2,1,4,1");
        this.runStopButton = new JButton("Run");
        this.runStopButton.setEnabled(false);
        this.runStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (InferencePanel.this.runningInference == null) {
                    InferencePanel.this.runStart();
                } else {
                    InferencePanel.this.runStop();
                }
            }
        });
        actionPanel.add((Component)this.runStopButton, "6,1");
        return actionPanel;
    }

    void runStart() {
        this.runStopButton.setText("Stop");
        this.repeatCountLabel.setVisible(false);
        this.repeatCountSpinner.setVisible(false);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
        this.setInferredProtocol(null, "", null);
        this.inferenceResults.clear();
        this.getResultsTableModel().fireTableDataChanged();
        this.runningInference = new RunInferenceWorker();
        this.runningInference.execute();
    }

    void runStop() {
        if (this.runningInference != null) {
            this.runningInference.cancel(true);
        }
        System.out.println("Stopped");
        this.runComplete();
    }

    void runComplete() {
        this.runningInference = null;
        this.runStopButton.setText("Run");
        this.repeatCountLabel.setVisible(true);
        this.repeatCountSpinner.setVisible(true);
        this.progressBar.setVisible(false);
    }

    private JPanel getDistancePanel() {
        JPanel distancePanel = this.getControlSubPanel("Distance");
        distancePanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, 10.0, -2.0, 5.0, -2.0, 10.0, -1.0}, {10.0, -2.0, 10.0, -2.0, 10.0}}));
        this.iterationText = new JLabel("0");
        JLabel iterationLabel = new JLabel("Iteration number");
        distancePanel.add((Component)iterationLabel, "2,1");
        distancePanel.add((Component)this.iterationText, "4,1");
        this.distanceText = new JLabel("Unknown");
        JLabel distanceLabel = new JLabel("Distance from observations");
        distancePanel.add((Component)distanceLabel, "2,3");
        distancePanel.add((Component)this.distanceText, "4,3");
        return distancePanel;
    }

    private JPanel getControlSubPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBackground(FMSim.COLOUR_CONTROL_BG);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        border.setTitleFont(CONTROL_TITLE_FONT);
        border.setTitleJustification(2);
        panel.setBorder(border);
        return panel;
    }

    void saveInferredProtocol() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        if (this.inferredProtocol.file != null) {
            fileChooser.setSelectedFile(this.inferredProtocol.file);
        } else {
            fileChooser.setSelectedFile(new File(String.valueOf(this.inferredProtocol.getExperimentName()) + ".protocol"));
        }
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            this.inferredProtocol.save(file);
        }
    }

    void handleException(Exception ex) {
        ex.printStackTrace();
        String message = "There was a problem: \n" + ex.getMessage();
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    void redrawCharts() {
        this.comparisonChartPanel.setChart(this.createChart());
        this.distanceText.setText(this.distanceFormat.format(this.chartDataModel.distance));
    }

    Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (this.protocol != null) {
            this.protocol.removeProtocolListener(this);
        }
        this.protocol = protocol;
        if (this.protocol != null) {
            this.protocol.addProtocolListener(this);
        }
        this.inferredProtocolPanel.setProtocol(null);
        this.protocolUpdated();
    }

    private JFreeChart createChart() {
        XYIntervalSeriesCollection chartData = this.chartDataModel.getComparisonChartData();
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Time", (String)"Fluorescence", (XYDataset)chartData, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        renderer.setSeriesFillPaint(1, (Paint)Color.GREEN);
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.GREEN);
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    @Override
    public void protocolUpdated() {
        this.runStop();
        this.runStopButton.setEnabled(this.protocol != null && this.protocol.getObservations() != null);
        this.chartDataModel.setObservations(this.protocol != null ? this.protocol.getObservations() : null);
        this.redrawCharts();
    }

    public static class IterationData {
        public final int iteration;
        public final Protocol protocol;
        public final double marginal;

        public IterationData(int iteration, double marginal) {
            this.iteration = iteration;
            this.protocol = null;
            this.marginal = marginal;
        }

        public IterationData(int iteration, Protocol protocol, double marginal) {
            this.iteration = iteration;
            this.protocol = protocol;
            this.marginal = marginal;
        }
    }

    class RunInferenceWorker
    extends SwingWorker<Protocol, IterationData>
    implements InferenceListener {
        RunInferenceWorker() {
        }

        @Override
        protected Protocol doInBackground() throws Exception {
            InferenceOverallModel inferenceModel = new InferenceOverallModel();
            inferenceModel.addInferenceListener(this);
            try {
                InferencePanel.this.inferredProtocol = inferenceModel.runOverall(InferencePanel.this.getProtocol(), InferencePanel.this.chartDataModel.getObservations(), 100, 50000);
            }
            finally {
                inferenceModel.removeInferenceListener(this);
            }
            return InferencePanel.this.inferredProtocol;
        }

        @Override
        protected void done() {
            InferencePanel.this.runComplete();
        }

        @Override
        public void candidateFound(int iteration, Protocol candidateProtocol, double marginal) {
            this.publish(new IterationData(iteration, candidateProtocol, marginal));
        }

        @Override
        protected void process(List<IterationData> chunks) {
            IterationData latest = chunks.get(chunks.size() - 1);
            InferencePanel.this.progressBar.setValue(latest.iteration);
            InferencePanel.this.progressBar.setString(String.valueOf(latest.iteration) + " of " + 50000);
            InferencePanel.this.distanceText.setText(InferencePanel.this.distanceFormat.format(latest.marginal));
            boolean dataChanged = false;
            int index = 0;
            while (index < chunks.size()) {
                IterationData current = chunks.get(index);
                if (current.protocol != null) {
                    InferencePanel.this.inferenceResults.add(current);
                    dataChanged = true;
                }
                ++index;
            }
            if (dataChanged) {
                InferencePanel.this.getResultsTableModel().fireTableDataChanged();
            }
        }

        @Override
        public void setCurrentIteration(int iteration, double marginal) {
            this.publish(new IterationData(iteration, marginal));
        }
    }
}

