/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.InferencePanel;
import fmsim.gui.ModelConfigurationPanel;
import fmsim.gui.ObservationsPanel;
import fmsim.gui.ProtocolEditPanel;
import fmsim.gui.ProtocolLibraryPanel;
import fmsim.gui.ProtocolSelectionListener;
import fmsim.gui.SimulatorPanel;
import fmsim.model.Protocol;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class FMSim
implements ProtocolSelectionListener {
    protected static final String WINDOW_TITLE = "FM-Sim v0.4";
    public static final Color COLOUR_CONTROL_BG = new Color(0xCCDDFF);
    private JFrame frame = new JFrame("FM-Sim v0.4");
    private ProtocolLibraryPanel protocolLibraryPanel;
    private ProtocolEditPanel protocolEditPanel;
    private SimulatorPanel simulatorPanel;
    private ModelConfigurationPanel modelConfigurationPanel;
    private ObservationsPanel observationsPanel;
    private InferencePanel inferencePanel;
    private JTabbedPane tabbedPane;

    public FMSim() throws Exception {
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(this.getProtocolLibraryPanel());
        this.tabbedPane.add(this.getProtocolEditPanel());
        this.tabbedPane.add(this.getModelConfigurationPanel());
        this.tabbedPane.add(this.getObservationsPanel());
        this.tabbedPane.add(this.getSimulatorPanel());
        this.tabbedPane.add(this.getInferencePanel());
        int i = 1;
        while (i < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setEnabledAt(i, false);
            ++i;
        }
        this.selectedProtocolChanged(this.getProtocolLibraryPanel().getSelectedProtocol());
        this.frame.getContentPane().add((Component)this.tabbedPane, "Center");
        this.frame.setMinimumSize(new Dimension(800, 580));
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private ModelConfigurationPanel getModelConfigurationPanel() {
        if (this.modelConfigurationPanel == null) {
            this.modelConfigurationPanel = new ModelConfigurationPanel();
        }
        return this.modelConfigurationPanel;
    }

    private ObservationsPanel getObservationsPanel() {
        if (this.observationsPanel == null) {
            this.observationsPanel = new ObservationsPanel();
        }
        return this.observationsPanel;
    }

    ProtocolLibraryPanel getProtocolLibraryPanel() {
        if (this.protocolLibraryPanel == null) {
            this.protocolLibraryPanel = new ProtocolLibraryPanel();
            this.protocolLibraryPanel.addProtocolSelectionListener(this);
        }
        return this.protocolLibraryPanel;
    }

    private ProtocolEditPanel getProtocolEditPanel() {
        if (this.protocolEditPanel == null) {
            this.protocolEditPanel = new ProtocolEditPanel();
        }
        return this.protocolEditPanel;
    }

    private SimulatorPanel getSimulatorPanel() {
        if (this.simulatorPanel == null) {
            this.simulatorPanel = new SimulatorPanel();
        }
        return this.simulatorPanel;
    }

    private InferencePanel getInferencePanel() {
        if (this.inferencePanel == null) {
            this.inferencePanel = new InferencePanel();
        }
        return this.inferencePanel;
    }

    public static void main(String[] args) throws Exception {
        FMSim fmSim = new FMSim();
    }

    @Override
    public void selectedProtocolChanged(Protocol protocol) {
        System.out.println("FMSim.selectedProtocolChanged");
        this.getProtocolEditPanel().setProtocol(protocol);
        this.getSimulatorPanel().setProtocol(protocol);
        this.getInferencePanel().setProtocol(protocol);
        this.getObservationsPanel().setProtocol(protocol);
        this.getModelConfigurationPanel().setProtocol(protocol);
        int i = 1;
        while (i < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setEnabledAt(i, protocol != null);
            ++i;
        }
    }
}

