/*
 * Decompiled with CFR 0.152.
 */
package fmsim.gui;

import fmsim.gui.FMSim;
import fmsim.model.ProtocolEvent;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class EventTypeCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final double F = -1.0;
    private static final double P = -2.0;
    private static final String EDIT = "edit";
    private static final String DONE = "done";
    private static final String CANCEL = "cancel";
    private static final String UPDATE_EVENT_TYPE = "update eventType";
    private JButton button = new JButton();
    private JDialog dialog;
    private ProtocolEvent event;
    private JComboBox eventTypeList;
    private JLabel eventTypeLabel;
    private JTextField frequencyText;
    private JLabel frequencyLabel;
    private JTextField chemicalNameText;
    private JLabel chemicalLabel;
    private JTextField concentrationText;
    private JLabel concentrationLabel;

    public EventTypeCellEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.dialog = new JDialog(Frame.getFrames()[0], "Event type", true);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this.getEventTypePanel(), "Center");
        this.dialog.getContentPane().add(this.getActionPanel(), "South");
        this.dialog.setMinimumSize(new Dimension(200, 100));
        this.dialog.pack();
        this.setEvent(null);
    }

    private JPanel getEventTypePanel() {
        JPanel panel = new JPanel();
        panel.setBackground(FMSim.COLOUR_CONTROL_BG);
        panel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -2.0, 10.0, -1.0, 20.0, -2.0, 10.0, -1.0, 10.0}, {10.0, -2.0, 10.0, -2.0, 10.0}}));
        this.eventTypeList = new JComboBox<ProtocolEvent.EventType>(ProtocolEvent.EventType.values());
        this.eventTypeList.setSelectedIndex(0);
        this.eventTypeList.addActionListener(this);
        this.eventTypeList.setActionCommand(UPDATE_EVENT_TYPE);
        this.eventTypeLabel = new JLabel("Event type:");
        this.eventTypeLabel.setLabelFor(this.eventTypeList);
        panel.add((Component)this.eventTypeLabel, "1,1");
        panel.add((Component)this.eventTypeList, "3,1,7,1");
        this.frequencyText = new JTextField(10);
        this.frequencyLabel = new JLabel("Frequency:");
        this.frequencyLabel.setLabelFor(this.frequencyText);
        panel.add((Component)this.frequencyLabel, "1,3");
        panel.add((Component)this.frequencyText, "3,3");
        this.concentrationText = new JTextField(10);
        this.concentrationLabel = new JLabel("Concentration:");
        this.concentrationLabel.setLabelFor(this.concentrationText);
        panel.add((Component)this.concentrationLabel, "1,3");
        panel.add((Component)this.concentrationText, "3,3");
        this.chemicalNameText = new JTextField(10);
        this.chemicalLabel = new JLabel("Chemical:");
        this.chemicalLabel.setLabelFor(this.chemicalNameText);
        panel.add((Component)this.chemicalLabel, "5,3");
        panel.add((Component)this.chemicalNameText, "7,3");
        return panel;
    }

    private Component getActionPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(FMSim.COLOUR_CONTROL_BG);
        panel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -2.0, 10.0, -2.0, -1.0}, {10.0, -2.0, 10.0}}));
        JButton doneButton = new JButton("Ok");
        doneButton.setActionCommand(DONE);
        doneButton.addActionListener(this);
        panel.add((Component)doneButton, "1,1");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand(CANCEL);
        cancelButton.addActionListener(this);
        panel.add((Component)cancelButton, "3,1");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else if (DONE.equals(e.getActionCommand())) {
            this.saveChanges();
            this.dialog.setVisible(false);
        } else if (CANCEL.equals(e.getActionCommand())) {
            this.dialog.setVisible(false);
        } else if (UPDATE_EVENT_TYPE.equals(e.getActionCommand())) {
            this.updateEventType();
        } else {
            throw new RuntimeException("Unknown event: " + e.toString());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.event;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.event = (ProtocolEvent)value;
        this.button.setText(this.event.toString());
        this.setEvent((ProtocolEvent)value);
        return this.button;
    }

    private void setEvent(ProtocolEvent event) {
        this.event = event;
        if (event == null) {
            this.eventTypeList.setSelectedItem((Object)ProtocolEvent.EventType.NONE);
            this.frequencyText.setText("");
            this.chemicalNameText.setText("");
            this.concentrationText.setText("");
            this.updateEventType();
            return;
        }
        this.eventTypeList.setSelectedItem((Object)event.getType());
        this.frequencyText.setText(event.getFrequency());
        this.chemicalNameText.setText(event.getChemical());
        this.concentrationText.setText(event.getConcentration());
        this.eventTypeList.setEnabled(true);
        this.eventTypeLabel.setEnabled(true);
        this.setFieldsVisible(event.getType());
    }

    private void setFieldsVisible(ProtocolEvent.EventType type) {
        boolean isElectrical = type == ProtocolEvent.EventType.ELECTRICAL;
        boolean isChemical = type == ProtocolEvent.EventType.CHEMICAL_MODIFIER || type == ProtocolEvent.EventType.CHEMICAL_STIMULUS;
        this.frequencyText.setVisible(isElectrical);
        this.frequencyLabel.setVisible(isElectrical);
        this.chemicalNameText.setVisible(isChemical);
        this.chemicalLabel.setVisible(isChemical);
        this.concentrationText.setVisible(isChemical);
        this.concentrationLabel.setVisible(isChemical);
    }

    private void saveChanges() {
        if (this.event == null) {
            return;
        }
        this.event.setType((ProtocolEvent.EventType)((Object)this.eventTypeList.getSelectedItem()));
        try {
            this.event.setFrequency(this.frequencyText.getText().trim());
        }
        catch (NumberFormatException ex) {
            this.event.setDuration(0.0);
        }
        this.event.setChemical(this.chemicalNameText.getText().trim());
        this.event.setConcentration(this.concentrationText.getText().trim());
    }

    private void updateEventType() {
        ProtocolEvent.EventType type = (ProtocolEvent.EventType)((Object)this.eventTypeList.getSelectedItem());
        this.setFieldsVisible(type);
    }
}

